% Tables 1 and 2 in Sargan paper
rng(284118);

clear all;
small = 1.0e-10;
big = 1.0e+6;
this_date = datestr(now,'yyyymmdd');

% -----  File Directories -- overhead, etc.
 outdir = 'out/';
 figdir = 'fig/';
 matdir = 'mat/';
 p_initial = path;
 utility_dir = 'm_utilities';
 path(utility_dir,p_initial);
 
% Output file
outfile_name = [outdir ['Tables_1_2_v2_' this_date '.csv'] ];
fileID = fopen(outfile_name,'w');

% Sample Period for GK data
[dnobs,calvec,calds] = calendar_make([1979 1],[2012 6],12);
data_mw = dlmread('..\data\sargan_gk.m79');
ii = data_mw==9999;
data_mw(ii==1) = NaN;
cpi = data_mw(:,1);
gs1 = data_mw(:,3);
ip = data_mw(:,5);
ff4 = data_mw(:,7);
ebp = data_mw(:,8);
mort_spread = data_mw(:,9);
cp3m_spread = data_mw(:,10);

% Compute Logs
ln_ip = 100*log(ip);
ln_p = 100*log(cpi);

% Read in Factors from Fred_md
nfac = 4;
str_tmp = [matdir 'factor_estimates_' num2str(nfac)];
load(str_tmp);
calvec_factors = factor_estimates(:,1);
ismpl = smpl(calvec_factors,calds(1,:),calds(end,:),12);
factors = factor_estimates(ismpl==1,2:end);


% Various Sample Periods
nfirst_var_y = [1980 7];
%nfirst_var_y = [1990 1];
nlast_var_y = [2012 6];
nvar_lag_y = 12;
nvar_lag_z = 4;

nirf = 24;         % Number of impulse responses

% Local Projections ---- Col(a) ---  no controls (except constant terms) 

% Instrument
z = ff4;
% Regressor
x = gs1;
% variables
y = [gs1 dif(ln_ip,1) dif(ln_p,1) ebp];
% difference indicators .. 0: y variable in levels; 1: y variable in first differencs
y_dif = [0 1 1 0];
% Construct matrix of controls
xcontrol = ones(dnobs,1);
xreg = [x xcontrol];
zreg = [z xcontrol];
nr = size(xreg,2);

irf_mat = NaN(nirf+1,size(y,2));        % Matrix for storing IRFS
irf_mat_se = NaN(nirf+1,size(y,2));     % IRF Standard errors (from HAC)
irf_mat_smpl = NaN(nirf+1,2);           % First and Last observation in Sample
for iseries = 1:size(y,2);
  for ilead = 0:nirf;
      if y_dif(iseries) == 0;
         yreg = lag(y(:,iseries),-ilead);
      elseif y_dif(iseries) == 1;;
         yreg = y(:,iseries);
         for j = 1:ilead;
              yreg = yreg+lag(y(:,iseries),-j);
         end;
      end;
      tmp = packr([yreg xreg zreg calvec]);
      yp = tmp(:,1);
      xp = tmp(:,2:nr+1);
      zp = tmp(:,nr+2:end-1);
      cp = tmp(:,end);
      [bhat,vbhat,se_bhat]=hac_tsls(yp,xp,zp,nirf+1,1);
      irf_mat(ilead+1,iseries) = bhat(1);
      irf_mat_se(ilead+1,iseries) = se_bhat(1);
      if iseries == 1;
       irf_mat_smpl(ilead+1,1) = cp(1);
       irf_mat_smpl(ilead+1,2) = cp(end);
      end;
  end;
end;
irf_lp_1_est = irf_mat;
irf_lp_1_se = irf_mat_se;
irf_lp_1_smpl = irf_mat_smpl;
% Compute First Stage F statistic
% Homskedastic
tmp = packr([xreg(:,1) zreg]);
yp = tmp(:,1);
xp = tmp(:,2:end);
[bhat,vbhat,se_bhat]=hom_ols(yp,xp);
fstat_1 = (bhat(1)/se_bhat(1))^2;
% HAC ... 12 lags
[bhat,vbhat,se_bhat,ser,rbarsq] = hac_ols(yp,xp,12,1);
fstat_r_1 = (bhat(1)/se_bhat(1))^2;

% ---- Col (b) --- lagged z's and y as controls
ncontrol_lag = 4;
% Instrument
z = ff4;
% Regressor
x = gs1;
% variables
y = [gs1 dif(ln_ip,1) dif(ln_p,1) ebp];
% difference indicators .. 0: y variable in levels; 1: y variable in first differencs
y_dif = [0 1 1 0];
% Construct matrix of controls
tmp = [y z];
xcontrol = ones(dnobs,1);
for i = 1:ncontrol_lag;
    xcontrol = [xcontrol lag(tmp,i)];
end;
xreg = [x xcontrol];
zreg = [z xcontrol];
nr = size(xreg,2);

irf_mat = NaN(nirf+1,size(y,2));    % Matrix for storing IRFS
irf_mat_se = NaN(nirf+1,size(y,2)); % IRF Standard errors (from HAC)
irf_mat_smpl = NaN(nirf+1,2);           % First and Last observation in Sample
for iseries = 1:size(y,2);
  for ilead = 0:nirf;
      if y_dif(iseries) == 0;
         yreg = lag(y(:,iseries),-ilead);
      elseif y_dif(iseries) == 1;;
         yreg = y(:,iseries);
         for j = 1:ilead;
              yreg = yreg+lag(y(:,iseries),-j);
         end;
      end;
      tmp = packr([yreg xreg zreg calvec]);
      yp = tmp(:,1);
      xp = tmp(:,2:nr+1);
      zp = tmp(:,nr+2:end-1);
      cp = tmp(:,end);
      [bhat,vbhat,se_bhat]=hac_tsls(yp,xp,zp,nirf+1,1);
      irf_mat(ilead+1,iseries) = bhat(1);
      irf_mat_se(ilead+1,iseries) = se_bhat(1);
      if iseries == 1;
       irf_mat_smpl(ilead+1,1) = cp(1);
       irf_mat_smpl(ilead+1,2) = cp(end);
      end;
  end;
end;
irf_lp_2_est = irf_mat;
irf_lp_2_se = irf_mat_se;
irf_lp_2_smpl = irf_mat_smpl;
% Compute First Stage F statistic
% Homskedastic
tmp = packr([xreg(:,1) zreg]);
yp = tmp(:,1);
xp = tmp(:,2:end);
[bhat,vbhat,se_bhat]=hom_ols(yp,xp);
fstat_2 = (bhat(1)/se_bhat(1))^2;
[bhat,vbhat,se_bhat,ser,rbarsq] = hac_ols(yp,xp,0,1);
fstat_r_2 = (bhat(1)/se_bhat(1))^2;


% ---- Col (c) .. lagged z's, y's factors as controls
ncontrol_lag = 4;
% Instrument
z = ff4;
% Regressor
x = gs1;
% variables
y = [gs1  dif(ln_ip,1) dif(ln_p,1) ebp];
% difference indicators .. 0: y variable in levels; 1: y variable in first differencs
y_dif = [0 1 1 0];
% Construct matrix of controls
tmp = [factors y z];
xcontrol = ones(dnobs,1);
for i = 1:ncontrol_lag;
    xcontrol = [xcontrol lag(tmp,i)];
end;
xreg = [x xcontrol];
zreg = [z xcontrol];
nr = size(xreg,2);

irf_mat = NaN(nirf+1,size(y,2));    % Matrix for storing IRFS
irf_mat_se = NaN(nirf+1,size(y,2)); % IRF Standard errors (from HAC)
irf_mat_smpl = NaN(nirf+1,2);           % First and Last observation in Sample
for iseries = 1:size(y,2);
  for ilead = 0:nirf;
      if y_dif(iseries) == 0;
         yreg = lag(y(:,iseries),-ilead);
      elseif y_dif(iseries) == 1;;
         yreg = y(:,iseries);
         for j = 1:ilead;
              yreg = yreg+lag(y(:,iseries),-j);
         end;
      end;
      tmp = packr([yreg xreg zreg calvec]);
      yp = tmp(:,1);
      xp = tmp(:,2:nr+1);
      zp = tmp(:,nr+2:end-1);
      cp = tmp(:,end);
      [bhat,vbhat,se_bhat]=hac_tsls(yp,xp,zp,nirf+1,1);
      irf_mat(ilead+1,iseries) = bhat(1);
      irf_mat_se(ilead+1,iseries) = se_bhat(1);
      if iseries == 1;
       irf_mat_smpl(ilead+1,1) = cp(1);
       irf_mat_smpl(ilead+1,2) = cp(end);
      end;
  end;
end;
irf_lp_3_est = irf_mat;
irf_lp_3_se = irf_mat_se;
irf_lp_3_smpl = irf_mat_smpl;
% Compute First Stage F statistic
% Homskedastic
tmp = packr([xreg(:,1) zreg]);
yp = tmp(:,1);
xp = tmp(:,2:end);
[bhat,vbhat,se_bhat]=hom_ols(yp,xp);
fstat_3 = (bhat(1)/se_bhat(1))^2;
[bhat,vbhat,se_bhat,ser,rbarsq] = hac_ols(yp,xp,0,1);
fstat_r_3 = (bhat(1)/se_bhat(1))^2;

%  ---- Col (d) ... SVAR----
var_par.nlag = nvar_lag_y;
var_par.icomp = 2;       % Keep Constant in Companion Matrix
var_par.iconst = 1;
smpl_par.calvec = calvec;
smpl_par.nper = 12;
smpl_par.nfirst = nfirst_var_y;
smpl_par.nlast = nlast_var_y;

% Y for VAR
y = [gs1 dif(ln_ip,1) dif(ln_p,1) ebp];
% difference indicators .. 0: y variable in levels; 1: y variable in first differencs
y_dif = [0 1 1 0];
varout = varest(y,var_par,smpl_par);
u = varout.resid;
G = varout.coef.G;
M = varout.coef.M;
Q = varout.coef.Q;
seps = varout.seps;

% IV regression
z = ff4;
irf_mat = NaN(nirf+1,size(y,2));
i_gs1 = 1;  % location of gs1 in y
y1 = y(:,1);
w = ones(dnobs,1);
for ilag = 1:nvar_lag_y;
    w = [w lag(y,ilag)];
end;
for ilag = 1:nvar_lag_z;
     w = [w lag(z,ilag)];
end;
ismpl = smpl(calvec,nfirst_var_y,nlast_var_y,12);
tmp = [y w z calvec];
tmp = tmp(ismpl==1,:);
tmp = packr(tmp);
yp=tmp(:,1:size(y,2));
ii = size(y,2);
wp=tmp(:,ii+1:ii+size(w,2));
ii = ii+size(w,2);
zp=tmp(:,ii+1:ii+size(z,2));
cp = tmp(:,end);
svar_ivreg_nfirst = cp(1);
svar_ivreg_nlat = cp(end);
zp = [zp wp];
xp = [yp(:,i_gs1) wp];
zx = zp'*xp;
zy = zp'*yp;
b = inv(zx)*zy;
D11 = b(1,1:4)';
D1 = [D11;zeros(size(M,1)-size(u,2),1)];

irf_mat(1,:) = (Q*D1)';
X = D1;
for i = 1:nirf;
    X = M*X;
    irf_mat(i+1,:) = (Q*X)';
end;
for iy = 1:size(y,2);
    if y_dif(iy) == 1;
       irf_mat(:,iy)=cumsum(irf_mat(:,iy));
    end;
end;
irf_var_est = irf_mat;

% Compute Instrument Strength
[bhat,vbhat,se_bhat]=hom_ols(yp(:,1),zp);
fstat_var = (bhat(1)/se_bhat(1))^2;
[bhat,vbhat,se_bhat,ser,rbarsq] = hac_ols(yp(:,1),zp,0,1);
fstat_r_var = (bhat(1)/se_bhat(1))^2;

% Compute GC Tests for lagged z's in each VAR equation
% Form Regressors
yreg = [gs1 dif(ln_ip,1) dif(ln_p,1) ebp];
xreg = ones(dnobs,1);
z = ff4;
for ilag = 1:nvar_lag_y;
    xreg = [xreg lag(yreg,ilag)];
end;
zreg = lag(z,1);
for ilag = 2:nvar_lag_z;
    zreg = [zreg lag(z,ilag)];
end;
% Get sample period
tmp = [calvec yreg zreg xreg];
ismpl = smpl(calvec,nfirst_var_y,nlast_var_y,12);
tmp = tmp(ismpl==1,:);
% Eliminate missing values
tmp = packr(tmp);
cp = tmp(:,1);
ii=1;
yreg_est = tmp(:,ii+1:ii+size(yreg,2));
ii = ii+size(yreg,2);
zreg_est = tmp(:,ii+1:ii+size(zreg,2));
ii = ii+size(zreg,2);
xreg_est = tmp(:,ii+1:ii+size(xreg,2));
ii = ii+size(xreg,2);
gc_z_nfirst = cp(1);
gc_z_nlast = cp(end);

% Run Regressions:
nz = size(zreg,2);
xr = [zreg_est xreg_est];
gc_z_pvalue = zeros(1,size(yreg,2));
for i = 1:size(yreg,2);
    [b,v,se,ser,r2]=hac_ols(yreg_est(:,i),xr,0,1);
    be = b(1:nz);
    vbe = v(1:nz,1:nz);
    vbeinv = inv(vbe);
    wald = be'*vbeinv*be;
    pv = chi2cdf(wald,nz,'upper');
    gc_z_pvalue(i) = pv;
end;

% ... Carry Out Simulations to find SEs for SVAR IRFs or Hausman-type tests
% Step 1: Find Sample period where Z data are available;




% Carry out parametric bootstrap to get SEs for SVAR IRFs
% Set up simulations
% Instrument
z = ff4;
z_smpl = 1 - isnan(z);
tmp = calds(z_smpl==1,:);
nfirst_z = tmp(1,:);
nlast_z = tmp(end,:);

% Step 1: run VAR(3)
var_par_z.nlag = nvar_lag_z;
var_par_z.icomp = 2;    % Keep Constant for use in accumulating
var_par_z.iconst = 1;
smpl_par_z.calvec = calvec;
smpl_par_z.nper = 12;
smpl_par_z.nfirst = nfirst_z;
smpl_par_z.nlast = nlast_z;
varout_z = varest(z,var_par_z,smpl_par_z);
% Step 2 ... set up parameters
Mz = varout_z.coef.M;
My = M;
SEPSy = seps;
SEPSz = varout_z.seps;
Uy = u;
Uz = varout_z.resid;
tmp = [Uy Uz];
tmp = packr(tmp);
UPy = tmp(:,1:end-1);
UPz = tmp(:,end);
SEPSyz = UPy'*UPz/(size(tmp,1));
SEPS = zeros(size(SEPSy,1)+1,size(SEPSy,1)+1);
SEPS(1:end-1,1:end-1) = SEPSy;
SEPS(end,end) = SEPSz;
SEPS(1:end-1,end) = SEPSyz;
SEPS(end,1:end-1) = SEPSyz';

n_y = size(SEPSy,1);
n_z = size(SEPSz,1);
nvar_y = size(My,1);
nvar_z = size(Mz,1);
nvar = nvar_y+nvar_z;
G_gen = zeros(nvar,size(SEPS,1));
Gtmp = chol(SEPS)';
G_gen(1:n_y,:) = Gtmp(1:n_y,:);
G_gen(nvar_y+1:nvar_y+n_z,:)=Gtmp(n_y+1:end,:);
M_gen = zeros(nvar,nvar);
M_gen(1:nvar_y,1:nvar_y) = My;
M_gen(nvar_y+1:end,nvar_y+1:end) = Mz;
Q_gen = zeros(n_y+n_z,nvar);
Q_gen(1:n_y,1:n_y) = eye(n_y);
Q_gen(n_y+1:n_y+n_z,nvar_y+1:nvar_y+n_z)=eye(n_z);
i_gs1 = 1;  % location of gs1 in y

n_bs = 1000;  % Number of bootstrap simulations
n_initial = 1000;
irf_var_sum = zeros(nirf+1,n_y);
irf_var_sum2 = zeros(nirf+1,n_y);
irf_lp_sum = zeros(nirf+1,n_y);
irf_lp_sum2 = zeros(nirf+1,n_y);
irf_dif_sum = zeros(nirf+1,n_y);
irf_dif_sum2 = zeros(nirf+1,n_y);
irf_dif_qf_sum = zeros(nirf+1,nirf+1,n_y);

nbs = 0;
 
for ibs = 1:n_bs;
  % Generate Data
  Xgen = zeros(nvar,1);
  Xgen(nvar_y) = 1.0;          % constant term
  Xgen(nvar_y+nvar_z) = 1.0;   % constant term
  for i = 1:n_initial;
     Xgen = M_gen*Xgen + G_gen*randn(n_y+n_z,1);
  end;
  Y_gen = NaN(dnobs,n_y);
  Zp_gen = NaN(dnobs,n_z);
  for i = 1:dnobs;
    Xgen = M_gen*Xgen + G_gen*randn(n_y+n_z,1);
    X = Q_gen*Xgen;
    Y_gen(i,:)=X(1:n_y)';
    Zp_gen(i,:)=X(n_y+1:end)';
  end;
  Z_gen = NaN(dnobs,1);
  Z_gen(z_smpl==1,:) = Zp_gen(z_smpl==1,:);

  % Compute IRFb
  varout_bs = varest(Y_gen,var_par,smpl_par);
  G_bs = varout_bs.coef.G;
  M_bs = varout_bs.coef.M;
  Q_bs = varout_bs.coef.Q;
  u_bs = varout_bs.resid;
  tmp = max(abs(eig(M_bs)));
  if tmp <= 1.0000001;
    % IV regression
    irf_mat = NaN(nirf+1,n_y);
    w = ones(dnobs,1);
    for ilag = 1:nvar_lag_y;
      w = [w lag(Y_gen,ilag)];
    end;
    for ilag = 1:nvar_lag_z;
       w = [w lag(Z_gen,ilag)];
    end;
    ismpl = smpl(calvec,nfirst_var_y,nlast_var_y,12);
    tmp = [Y_gen w Z_gen];
    tmp = tmp(ismpl==1,:);
    tmp = packr(tmp);
    yp=tmp(:,1:size(Y_gen,2));
    ii = size(Y_gen,2);
    wp=tmp(:,ii+1:ii+size(w,2));
    ii = ii+size(w,2);
    zp=tmp(:,ii+1:ii+size(Z_gen,2));
    zp = [zp wp];
    xp = [yp(:,i_gs1) wp];
    zx = zp'*xp;
    zy = zp'*yp;
    b = inv(zx)*zy;
    D11 = b(1,1:4)';
    D1 = [D11;zeros(size(M,1)-size(u,2),1)];
    irf_mat(1,:) = (Q*D1)';
    X = D1;
    for i = 1:nirf;
      X = M_bs*X;
      irf_mat(i+1,:) = (Q*X)';
    end;
    [bhat,vbhat,se_bhat]=hom_ols(yp(:,1),zp);
    fstat = (bhat(1)/se_bhat(1))^2;
    if fstat > 5;
        nbs=nbs+1;
        for iy = 1:size(y,2);
           if y_dif(iy) == 1;
              irf_mat(:,iy)=cumsum(irf_mat(:,iy));
           end;
        end;
        irf_var = irf_mat;
        % Carry out local projections
        % Instrument
        z = Z_gen;
        % Regressor
        x = Y_gen(:,i_gs1);
        % variables
        y = Y_gen;
        %Construct matrix of controls
        ycontrol = [y z];
        xcontrol = ones(dnobs,1);
        for i = 1:ncontrol_lag;
           xcontrol = [xcontrol lag(ycontrol,i)];
        end;
        xreg = [x xcontrol];
        zreg = [z xcontrol];
        nr = size(xreg,2);
        irf_mat = NaN(nirf+1,size(y,2));
        for iseries = 1:size(y,2);
           for ilead = 0:nirf;
             if y_dif(iseries) == 0;
                 yreg = lag(y(:,iseries),-ilead);
             elseif y_dif(iseries) == 1;
                 yreg = y(:,iseries);
                 for j = 1:ilead;
                   yreg = yreg+lag(y(:,iseries),-j);
                 end;
             end;
             tmp = packr([yreg xreg zreg]);
             yp = tmp(:,1);
             xp = tmp(:,2:nr+1);
             zp = tmp(:,nr+2:end);
             xhat = zp*(inv(zp'*zp)*(zp'*xp));
             xx=xhat'*xhat;
             xxi = inv(xx);
             bhat=xxi*(xhat'*yp);
             irf_mat(ilead+1,iseries) = bhat(1);
          end;
       end;
       irf_lp = irf_mat;  
       irf_dif = irf_var-irf_lp;
       irf_var_sum = irf_var_sum+irf_var;
       irf_var_sum2 = irf_var_sum2+irf_var.^2;
       irf_lp_sum = irf_lp_sum+irf_lp;
       irf_lp_sum2 = irf_lp_sum2+irf_lp.^2;
       irf_dif_sum = irf_dif_sum+irf_dif;
       irf_dif_sum2 = irf_dif_sum2+irf_dif.^2;
       for iseries = 1:size(y,2);
         irf_dif_qf_sum(:,:,iseries) = irf_dif_qf_sum(:,:,iseries)+irf_dif(:,iseries)*irf_dif(:,iseries)';
       end;
     end;
   end;
 end;

irf_var_mean = irf_var_sum/nbs;
irf_var_m2 = irf_var_sum2/nbs;
irf_var_var = irf_var_m2 - irf_var_mean.^2;
irf_var_se = sqrt(abs(irf_var_var));

irf_lp_mean = irf_lp_sum/nbs;
irf_lp_m2 = irf_lp_sum2/nbs;
irf_lp_var = irf_lp_m2 - irf_lp_mean.^2;
irf_lp_se = sqrt(abs(irf_lp_var));

irf_dif_mean = irf_dif_sum/nbs;
irf_dif_m2 = irf_dif_sum2/nbs;
irf_dif_var = irf_dif_m2 - irf_dif_mean.^2;
irf_dif_se = sqrt(abs(irf_dif_var));

irf_dif_qf_mean = irf_dif_qf_sum/nbs;
irf_dif_cov = zeros(size(irf_dif_qf_mean));
for iseries = 1:size(y,2);
  irf_dif_cov(:,:,iseries) = irf_dif_qf_mean(:,:,iseries)-irf_dif_mean(:,iseries)*irf_dif_mean(:,iseries)';
end; 

% Print Results
% Table 1
fprintf(fileID,'Results from Sargan_Tables 1 and 2 \n\n');
fprintf(fileID,'Table 1 Results \n');
nirf_tab1 = [0 6 12 24];
for iseries = 1:4;
    fprintf(fileID,'Series: %2i,',iseries);
    for jlag = 1:size(nirf_tab1,2);
        if jlag > 1;
         fprintf(fileID,',');
        end;
        ilag = nirf_tab1(jlag);
        fprintf(fileID,'%2i,',ilag);
        fprintf(fileID,'%5.2f (%5.2f),',[irf_lp_1_est(ilag+1,iseries) irf_lp_1_se(ilag+1,iseries)]);
        fprintf(fileID,'%5.2f (%5.2f),',[irf_lp_2_est(ilag+1,iseries) irf_lp_2_se(ilag+1,iseries)]);
        fprintf(fileID,'%5.2f (%5.2f),',[irf_lp_3_est(ilag+1,iseries) irf_lp_3_se(ilag+1,iseries)]);
        fprintf(fileID,'%5.2f (%5.2f),,',[irf_var_est(ilag+1,iseries) irf_var_se(ilag+1,iseries)]); 
        fprintf(fileID,'%5.2f (%5.2f)\n',[irf_var_est(ilag+1,iseries)-irf_lp_2_est(ilag+1,iseries) irf_dif_se(ilag+1,iseries)]); 
    end;
    fprintf(fileID,'\n');
end;
fprintf(fileID,'F-Hom,, %4.1f,%4.1f,%4.1f,%4.1f \n',[fstat_1 fstat_2 fstat_3 fstat_var]);
fprintf(fileID,'F-HAC,, %4.1f,%4.1f,%4.1f,%4.1f \n',[fstat_r_1 fstat_r_2 fstat_r_3 fstat_r_var]);



% Table 2
fprintf(fileID,'\n\n Table 2 Results \n');
fprintf(fileID,',Series 1,Series 2,Series 3,Series 4 \n');
fprintf(fileID,'VAR Z-GC test,');
fprintf(fileID,'%5.2f,%5.2f,%5.2f,%5.2f \n',gc_z_pvalue);

% Compute Hausman-type test for lags;
zeta_pvalue = NaN(1,4);
R = zeros(size(nirf_tab1,2)-1,nirf+1);
for i = 1:size(R,1);
    R(i,nirf_tab1(i+1)) = 1;
end;
dif = irf_var_est(:,1)-irf_lp_2_est(:,1);
vdif = squeeze(irf_dif_cov(:,:,1));
Rd = R*dif;
RvR = R*vdif*R';
wstat = Rd'*inv(RvR)*Rd;
pvalue = chi2cdf(wstat,size(R,1),'upper');
zeta_pvalue(1)=pvalue;
tmp = zeros(1,nirf+1);
tmp(1,1) = 1;
R = [tmp;R];
for iseries = 2:4;
  dif = irf_var_est(:,iseries)-irf_lp_2_est(:,iseries);
  vdif = squeeze(irf_dif_cov(:,:,iseries));
  Rd = R*dif;
  RvR = R*vdif*R';
  wstat = Rd'*inv(RvR)*Rd;
  pvalue = chi2cdf(wstat,size(R,1),'upper');
  zeta_pvalue(iseries) = pvalue;
end;
fprintf(fileID,'VAR -LP Difference test,');
fprintf(fileID,'%5.2f,%5.2f,%5.2f,%5.2f \n',zeta_pvalue);

fprintf(fileID,'\n\n Some Sample Periods \n');
fprintf(fileID,'Sample Period for LP-IV in (a) for h = 0: %5.2f - %5.2f \n',irf_lp_2_smpl(1,:));
fprintf(fileID,'Sample Period for LP-IV in (a) for h = %2i: %5.2f - %5.2f',[nirf irf_lp_2_smpl(end,:)]);
fprintf(fileID,'Sample Period for VAR Estimates %4i:%2i - %4i:%2i \n',[nfirst_var_y nlast_var_y]);
fprintf(fileID,'IV for SVAR instruments available from %4i:%2i - %4i:%2i \n',[nfirst_z nlast_z]);


