
program OutliersCorrection 
	
	syntax varlist , start(integer) date(varname) end(integer) 
	* corrections only apply to time periods (specified by date variable) no later than end date (specified by end integer). (Including observation date==end)
	qui {		
		if "`start'"!="" {
			local condition "&`date'>=`start'"
		}
		foreach var of varlist `varlist' {
			_pctile `var' if `date'<=`end' `condition', n(4)
			qui replace `var' = r(r2) if (`var'-r(r2)>4*(r(r3)-r(r1))|`var'-r(r2)<-4*(r(r3)-r(r1)))&`var'!=.&`date'<=`end' `condition'
			qui replace `var' = r(r2) if `var'==.&`date'<=`end' `condition'
		}
	}
end
	
	