#include <oxstd.oxh>
#include "packages\CL95\CL95.ox"
main()
{
	format("%#12.4f");
	decl mtab = loadmat("packages\CL95\Data\Data.xlsx");
	decl mtab0 = selectifr(mtab, mtab[][0] .== 0); // no constant, no trend
	decl mtab1 = selectifr(mtab, mtab[][0] .== 1); // constant, no trend
	decl mtab2 = selectifr(mtab, mtab[][0] .== 2); // constant, trend

	DrawTitle(0, "No constant or trend (10% test)");
	DrawAdjust(ADJ_AREA_Z, 0, -1.8, -1.4);
	DrawXYZ(0, mtab0[][2]', mtab0[][1]', mtab0[][3]', 0, "k", "N", "CR");

	DrawTitle(1, "No constant or trend (5% test)");
	DrawAdjust(ADJ_AREA_Z, 1, -2.2, -1.8);
	DrawXYZ(1, mtab0[][2]', mtab0[][1]', mtab0[][4]', 0, "k", "N", "CR");

	DrawTitle(2, "No constant or trend (1% test)");
	DrawAdjust(ADJ_AREA_Z, 2, -2.8, -2.4);
	DrawXYZ(2, mtab0[][2]', mtab0[][1]', mtab0[][5]', 0, "k", "N", "CR");

	DrawTitle(3, "Constant, no trend (10% test)");
	DrawAdjust(ADJ_AREA_Z, 3, -2.8, -2.4);
	DrawXYZ(3, mtab1[][2]', mtab1[][1]', mtab1[][3]', 0, "k", "N", "CR");

	DrawTitle(4, "Constant, no trend (5% test)");
	DrawAdjust(ADJ_AREA_Z, 4, -3.1, -2.7);
	DrawXYZ(4, mtab1[][2]', mtab1[][1]', mtab1[][4]', 0, "k", "N", "CR");

	DrawTitle(5, "Constant, no trend (1% test)");
	DrawAdjust(ADJ_AREA_Z, 5, -3.7, -3.3);
	DrawXYZ(5, mtab1[][2]', mtab1[][1]', mtab1[][5]', 0, "k", "N", "CR");

	DrawTitle(6, "Constant and trend (10% test)");
	DrawAdjust(ADJ_AREA_Z, 6, -3.3, -2.9);
	DrawXYZ(6, mtab2[][2]', mtab2[][1]', mtab2[][3]', 0, "k", "N", "CR");

	DrawTitle(7, "Constant and trend (5% test)");
	DrawAdjust(ADJ_AREA_Z, 7, -3.6, -3.2);
	DrawXYZ(7, mtab2[][2]', mtab2[][1]', mtab2[][4]', 0, "k", "N", "CR");

	DrawTitle(8, "Constant and trend (1% test)");
	DrawAdjust(ADJ_AREA_Z, 8, -4.3, -3.9);
	DrawXYZ(8, mtab2[][2]', mtab2[][1]', mtab2[][5]', 0, "k", "N", "CR");

	SaveDrawWindow("Figure1.eps");
	CloseDrawWindow();
}