#include <oxstd.oxh>
#include "packages\CL95\CL95.ox"
main()
{
	format("%#12.3f");
	decl mtab = loadmat("packages\CL95\Data\Data.xlsx");
	decl mtab0 = selectifr(mtab, mtab[][0] .== 0); // no constant, no trend
	decl mtab1 = selectifr(mtab, mtab[][0] .== 1); // constant, no trend
	decl mtab2 = selectifr(mtab, mtab[][0] .== 2); // constant, trend
	decl amtab = {mtab0, mtab1, mtab2};
	decl mTable1 = <>;
	decl ors = new CL95::EstRS();
	for (decl i = 0; i < columns(amtab); i++)
	{
		decl vN = amtab[i][][1];
		ors.SetN(vN);
		decl vK = amtab[i][][2];
		ors.SetK(vK);
		for (decl j = 3; j < 6; j++)
		{
			decl vY = amtab[i][][j];
			ors.SetResp(vY);
			ors.Estimate();
			decl ols = ors.GetEstObj();
			mTable1 ~= CL95::Misc::Comb(ols.Coef(), ols.CoefSE()) | ols.RSq() | ols.Sigma() | meanc(fabs(ols.Resid())) | maxc(fabs(ols.Resid()));
		}
	}
	decl mTable2 = <>; // N >= 30
	for (decl i = 0; i < columns(amtab); i++)
	{
		mtab = amtab[i];
		mtab = deleteifr(mtab0, mtab0[][1] - mtab0[][2] .< 30); // for T >= 30 where T = N - k
		decl vN = mtab[][1];
		ors.SetN(vN);
		decl vK = mtab[][2];
		ors.SetK(vK);
		for (decl j = 3; j < 6; j++)
		{
			decl vY = mtab[][j];
			ors.SetResp(vY);
			ors.Estimate();
			decl ols = ors.GetEstObj();
			mTable2 ~= meanc(fabs(ols.Resid())) | maxc(fabs(ols.Resid()));
		}
	}
	decl mTable = mTable1 | mTable2;
	savemat("Table1.xlsx", mTable);
	delete ors;
}