#include <oxstd.oxh>
#include "packages\CL95\CL95.ox"
main()
{
	format("%#12.4f");
	// sample sizes
	decl vN = <18, 20, 22, 25, 27, 30, 33, 36, 39, 42, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100, 150, 200, 250, 300, 350, 400, 500>;
	// lag orders
	decl vK = <1, 2, 3, 4, 5, 6, 7, 9>;
	// ADF test specifications
	decl mCT = <
		0, 0; // no constant, no trend
		1, 0; // constant, no trend
		1, 1>; // constant, trend
	decl osim = new CL95::SimRW();
	decl oadf = new CL95::TestADF();
	osim.SetNumDis(50);
	decl iSeed = 0;
	decl iN, iNumRep, mY, vK2, iK, vTestStat, vRow, mTable = <>;
	for (decl in = 0; in < columns(vN); in++) // for each sample size
	{
		iN = vN[in];
		osim.SetNumObs(iN);
		if (iN <= 30)
			iNumRep = 40000; // default: 40000
		else
			iNumRep = 30000; // default: 30000
		osim.SetNumRep(iNumRep);
		ranseed(++iSeed);
		osim.Simulate();
		mY = osim.GetSeries();
		for (decl ict = 0; ict < rows(mCT); ict++) // for each constant-trend pair
		{
			oadf.SetInt(mCT[ict][0]);
			oadf.SetTrend(mCT[ict][1]);
			if (iN <= 25)
				vK2 = vK[:4];
			else
				vK2 = vK;
			for (decl ik = 0; ik < columns(vK2); ik++) // for each lag order
			{
				iK = vK2[ik];
				// ATTENTION: we use iK - 1 because k = 1 corresponds to the ADF test with 1 lag in the code BUT
				// k = 1 corresponds to the ADF test with 0 lag in the paper (see equation (1))!!!
				oadf.SetMaxLag(iK - 1);
				vTestStat = nans(iNumRep, 1);
				for (decl ir = 0; ir < iNumRep; ir++) // for each replication
				{
					oadf.SetData(mY[][ir]);
					oadf.Run();
					vTestStat[ir] = oadf.TestStat();
				}
				vRow = ict ~ iN ~ iK ~ quantilec(vTestStat, <0.10, 0.05, 0.01>)';
				println(vRow); // to track the progress
				mTable |= vRow;
			}
		}
	}
	savemat("..\Data\Data.xlsx", mTable);
	delete oadf;
	delete osim;
}