#include <oxstd.oxh>
#include "packages\CL95\CL95.ox"
main()
{
	format("%#12.4f");
	decl mdata = loadmat("packages\CL95\Data\qrex3.xlsx");
	decl ve = mdata[][0];
	decl vp = mdata[][1];
	decl o = new CL95::EstOLS();
	o.SetData(ve, 1 ~ vp);
	o.Estimate();
	decl vCert, vCalc;
	println("");
	vCert = <1.41963015830496; -0.007797853951517632>;
	vCalc = o.Coef();
	CL95::Misc::AreEqual(vCert, vCalc, "Coef:\t\t", 1e-14);
	vCert = <0.02909039236359378; 0.0004362972404455234>;
	vCalc = o.CoefSE();
	CL95::Misc::AreEqual(vCert, vCalc, "Coef SE:\t", 1e-16);
	vCert = <48.80065351341245; -17.87280144966052>;
	vCalc = o.CoefT();
	CL95::Misc::AreEqual(vCert, vCalc, "Coef T:\t\t", 1e-12);
	vCert = <0.7726376865110267>;
	vCalc = o.RSq();
	CL95::Misc::AreEqual(vCert, vCalc, "R-Squared:\t", 1e-15);
	delete o;
}