#include <oxstd.oxh>
#include "packages\CL95\CL95.ox"
main()
{
	format("%#12.4f");
	decl mdata = loadmat("packages\CL95\Data\qrex3.xlsx");
	decl ve = mdata[][0];
	decl vp1 = mdata[][1];
	decl vp2 = pow(vp1, 2);
	decl vp3 = pow(vp1, 3);
	decl o = new CL95::EstOLS();
	o.SetData(ve, 1 ~ vp1 ~ vp2 ~ vp3);
	o.Estimate();
	decl vExpected, vActual;
	println("");
	vExpected = <1.819142917012197; -0.02225785224177173; 6.585464649643305e-05; 5.172115209652651e-07>;
	vActual = o.Coef();
	CL95::Misc::AreEqual(vExpected, vActual, "Coef:\t\t\t", 1e-12);
	vExpected = <0.09723811786613295; 0.005968224383522544; 0.0001083106924722044; 5.967494125541804e-07>;
	vActual = o.CoefSE();
	CL95::Misc::AreEqual(vExpected, vActual, "Coef SE:\t\t", 1e-13);
	vExpected = <18.70812554719127; -3.729392665467243; 0.608016115429538; 0.8667147551122326>;
	vActual = o.CoefT();
	CL95::Misc::AreEqual(vExpected, vActual, "Coef T:\t\t\t", 1e-10);
	vExpected = <4.106068814694102e-33; 0.0003315962374914884; 0.5446748601829585; 0.3883531739948431>;
	vActual = o.CoefP();
	CL95::Misc::AreEqual(vExpected, vActual, "Coef P:\t\t\t", 1e-11);
	vExpected = <0.9145350582636002>;
	vActual = o.RSq();
	CL95::Misc::AreEqual(vExpected, vActual, "R-Squared:\t\t", 1e-15);
	o.SetRobust(CL95::HC1);
	o.Estimate();
	vExpected = <0.09023937749034851; 0.005649979334220484; 0.0001008298878791921; 5.423705662369206e-07>;
	vActual = o.CoefSE();
	CL95::Misc::AreEqual(vExpected, vActual, "Coef SE (HC1):\t", 1e-12);
	delete o;
}