function wg = wolfsongini(A)
 
% Written by Melanie Krause, this version 25.07.2016.

% Given a data vector A (without negative values), this function calculates Wolfson's Bi-Polarization
% Measure (see Wolfson, 1992) and also the Gini coefficient:
% wolfson = 2*mu/median* (1- 2*L(0.5) - Gini)

A=sort(A);
n=length(A);
mu=mean(A);
m=median(A);

cum=cumsum(A);
LC=cum/cum(end);

rank_percent=[1:1:n]'/n;

LC05=LC(round(0.5*n));

area=zeros(n,1);
area(1)=0.5*rank_percent(1)*LC(1);
for i=2:n
    area(i)=area(i-1) + (rank_percent(i)-rank_percent(i-1))*LC(i-1) + 0.5*(rank_percent(i)-rank_percent(i-1))*(LC(i)-LC(i-1));
end
gini=1-2*area(end);

wolfson= 2*mu/m*(1-2*LC05-gini);

wg=[wolfson; gini];