function Signific = MM_Bianchi(A, mmin, mmax, points, demarc, trials)
 
% Written by Melanie Krause, this version 25.07.16 

% Bianchi's (1997, p.397) Implementation of the Test for Multimodality of a nonparametrically estimated
% density : Based on a MC simulation, can you reject the Silverman's
% critical bandwidth for m-modality as too high, implying (at least) m+1-modality? 
% Implement this MC experiment with a bootstrap, augmented by
% Efron and Tibshirani's (1993) sample variance adjustment.

% A is the vector containing the observations, mmin to mmax are the values for which
% you would like to execute the test (usually starting at mmin=1), points are the number
% of points where the nonparametric density should be evaluated, demarc is the horizontal
% demarcation line below which tiny modes are neglected (see function function MM_CritBW), 
% trials is the number of MC replications in the bootstrap.

% This function calls the function MM_CritBW to calculate the critical values. 

randn('seed',130514)
rand('seed',130514)

Signific = zeros(mmax-mmin+1,1);
n=length(A); % number of observations
crit_vec = zeros(mmax,1);
crit_vec(mmin:mmax) = MM_CritBW(A, mmin, mmax, points, demarc);  % calculate critical
% bandwidths for original data (to be compared to critical values from the
% bootstraps)

for m=mmin:mmax 
    crit_hm = crit_vec(m);
% Step 1: Draw B Bootstrap samples Y* from Y and then rescale them so that
% variance is correct
      X=zeros(n,trials);
     for b=1:trials
     Ystar=A(ceil(rand(n,1)*n));
     epsilon = randn(n,1);
  for i=1:n
      X(i,b)=mean(Ystar)+(1+crit_hm^2/var(A))^(-0.5)*(Ystar(i)-mean(Ystar)+crit_hm*epsilon(i));
  end
  end

% Step 2: For each of the B samples (columns in X), calculate the critical
% bandwidth consistent with m-modality

Crit_Sample_BWs = zeros(1,trials);
for b=1:trials
Crit_Sample_BWs(b) = MM_CritBW(X(:,b), m, m, points, demarc);
end

% Step 3: Count how often the critical value of the trials exceed the
% critical value from the original sample crit_hm:
 Trial_exceed=Crit_Sample_BWs(Crit_Sample_BWs>crit_hm);
 Signific(m-mmin+1)=(length(Trial_exceed))/trials;
end

% Successively reject the null of m modes in favor of m+1 modes if Signific is
% smaller than 5% (or any other desired significance level)!

