sbrq_function(y, x, tau=0.5, start, sigma, delta, rt=0.15, eps=1.0E-6, nt=20, ns=10, int=T, neps=4, maxevl=10000000, maxhill=1000,	sl, vm, seed1=1, seed2=2, t0=2, lbc, ubc, sgn=1, sa=T, nr=T, hill=T, bc=T, rho=1)
{

#**********************************************************************
#				PART I
#   Check the inputs of the function, read data and set parameters.
#**********************************************************************


###dll.load("sbrq.dll","_sa_")

if(!is.loaded(symbol.C("_sa_"))) stop("Compiled code has not been loaded")


tau <- as.vector(tau)					# Read the quantile(s) to be estimated.
p <- length(tau)						# Number of quantiles  to be estimated.
y <- as.vector(y)           				# Read the dependent latent (0,1) variable.
x <- as.matrix(x)           				# Read the expalnatory variables.
if(int) x <- cbind(1,x)     				# Add an intercept to the model.
nobs <- nrow(x)             				# Number of observations.
k <- ncol(x)                				# Number of explanatory variables.
if(int) {if(k<3) stop()}				# Check that there is a regressor to standardize.
else {if(k<2) stop()} 


# Get the names of the variables.

if(int) xnames <- c("intercept", dimnames(x) [[2]] [2:k])
else xnames <- dimnames(x) [[2]] [1:k]


if(missing(sigma)) {sigma<-rep(nobs^(-1/5),p)} 	# Set the smoothing parameter.
else if(length(sigma)!=p) stop("sigma and tau should have the same lenght.")

if(missing(delta)) {delta<- rep(0.1,p)}         # Set delta.
else if(length(delta)!=p) stop("delta and tau should have the same lenght.")

sigmad <- sigma^(delta)         			# Set the smoothing parameter for Bias Estimation.

lb <- rep(lbc,k-1)					# Set upper bound of the parameter space.
ub <- rep(ubc,k-1)					# Set lower bound of the parameter space.

if(missing(start)) {start <- matrix(rep(rep(1,k),p),k,p)} 			# Set starting values.
else {start <- as.matrix(start)   
	if(ncol(start)!=p) stop("number of columns of start should equal the lenght of tau.")
	if(nrow(start)!=k) stop("number of rows of start should equal the number of columns of x.")
	}


#**************************************************
# Check that the starting values are within bounds.
#**************************************************

for(i in 1:(k-1)) {
	for(m in 1:p){
	   	if(start[i,m]<lb[i] | start[i,m]>ub[i]) stop(
	 	cat("Initial values (start) out of bounds (lbC, ubC).","\n")) 
		}
	}

if(missing(sl)) {sl <- rep(2, k-1)}
if(missing(vm)) {vm <- rep(1, k-1)}


#************************************************
# Check the seed of the random number generator.*
#************************************************

if(seed1<0 | seed1>31328 | seed2<0 | seed2>30081)
    	stop("The first number seed (seed1) must have a value between 0
	and 31328 and the second value seed (seed2) must have a value between
	0 and 30081.")

#*****************************
# Set the initial temperature.  ######### shouldn't be defined for each tau ????
#*****************************

if(missing(t0)) {stop(" The initial temperature (t0) is not positive. 
	Reset t0 to a positive number.")}


cat("\n",
	 "Date: ", substring(date(),1,10), substring(date(),25,28)                , "\n",
	                                                                            "\n",
	 "*******************************************************************"    , "\n",
	 "    ESTIMATION OF SMOOTHED BINARY REGRESSION QUANTILES   "              , "\n",
	 "                BY SIMULATED ANNEALING                   "              , "\n",
	 "*******************************************************************"    , "\n",
	 " Number of Observations                  = ", nobs                      , "\n",
	 " Quantile(s)                             = ", tau                       , "\n",
	 " Initial Bandwidth                       = ", format(round(sigma, 5))   , "\n",
	 " Delta                                   = ", format(round(delta,5))    , "\n")
if(sa) cat(
	 "  Maximum Simulated Annealing Iterations  = ", maxevl                   , "\n",
         " Initial Temperature                     = ", format(round(t0, 10)) , "\n",
         " Lower and Upper Bound                   = ", lbc, ubc                , "\n",
	 " Iterations before Temperature Reduction = ", nt                        , "\n",
	 " Iterations before Step Adjustment       = ", ns                        , "\n",
	 " Temperature Preservation Factor         = ", rt                        , "\n")
else cat("  Simulated Annealing                     = ", "Turned OFF"           , "\n")
if(hill) cat(
	 "  Maximum Hill-Climbing Iterations        = ", maxhill                  , "\n",
	 " Rho for Hill-Climbing                   = ", rho                       , "\n")
else cat("  Hill-Climbing                           = ", "Turned OFF"           , "\n")
cat(	 "*******************************************************************"    , "\n"
	)



#**********************************************************************
#				PART II                               *
#			Maximize the objective function.              *
#**********************************************************************

betavec <- NULL
objvec <- NULL

for(m in 1:p) {
taum <- tau[m]

#***********************************************
# Evaluate the objective at the starting values.
#***********************************************

fstart <- 1/(nobs)*sum((y-(1-taum))*
	pnorm((as.matrix(x[,1:(k-1)],nobs,k-1)%*%start[1:(k-1),m]+sgn*x[,k])/sigma[m]))

cat("\n",
	"*******************************************************************"     , "\n",
	"            Estimation of the", taum, "Quantile Model"                   , "\n",
	"*******************************************************************"     , "\n",
	"                 ", xnames, "Objective",                                 , "\n",
	"-------------------------------------------------------------------"     , "\n",
	" Initial Values  ", format(round(start[,m], 6)), format(round(fstart,6)) , "\n"
	)

beta<-start[,m]
fmax<-fstart


if(sa){
#**********************************************************************
# 		Invoke the SA algorithm for function optimization.    *
#**********************************************************************
cat("\n",
	" Invoking the SA maximization routine."                                 , "\n",
	" Please wait..."                                                        , "\n"
	)

out2 <- .C("_sa_",
         as.double(y),
         as.double(x),
         as.integer(nobs),
         as.integer(k),
         as.double(start[,m]),
         taum = as.double(taum),
         as.logical(T),
         as.double(rt),
         as.double(eps),
         as.integer(ns),
         as.integer(nt),
         as.integer(neps),
         as.integer(maxevl),
         as.double(lb),
         as.double(ub),
         as.double(sl),
         as.double(seed1),
         as.double(seed2),
         as.double(t0),
         as.double(vm),
         coef = as.double(start[,m]),
         obj = as.double(0),
         as.integer(0),
         as.integer(0),
         as.integer(0),
         as.integer(0),
         as.double(start[,m]),
         as.double(start[,m]),
         as.integer(start[,m]),
         aflag = as.integer(0),
         sigmam = as.double(sigma[m]),
	   as.double(sgn)
         )

if(out2$aflag!=0)
    warning("Maximum number of evaluations has been reached. Consider increasing maxevl
             or eps, or decreasing nt or rt. These results are likely
             to be poor.")

cat("\n", " SA finished", "\n")

beta <- as.matrix(out2$coef)
fmax <- 1/(nobs)*sum((y-(1-taum))*
		pnorm((as.matrix(x[,1:(k-1)],nobs,k-1)%*%beta[1:(k-1)]+sgn*x[,k])/sigma[m]))

cat("\n",
	"Estimates After SA"                              , "\n",
	"------------------"                              , "\n",
	xnames, "Objective",                              , "\n", 
	format(round(beta, 8)), format(round(fmax,8))     , "\n"
	)
} 			# end if for SA



if(hill){
	
	#**********************************************************************
	# 			Hill-Climbing Step 			      *
	# Reference: Goldfeld, Quant and Trotter (1996) Econometrica	      *
	#**********************************************************************
	cat("\n", 
		"Hill-Climbing Step", "\n",
		"------------------", "\n"
		)
	
	diff <- 1					# Initialize diff.
	iter <- 0					# Initialize iter.


	while(iter<maxhill & diff>1.0E-50) {
		arg <- (as.matrix(x[,1:(k-1)],nobs,k-1)%*%beta[1:(k-1)]+sgn*x[,k])/sigma[m]
		# Compute Gratient
			TS  <- matrix(0,k-1,1)				
			for(i in 1:(k-1)){
				TS[i,] <- sum((y-(1-taum))*x[,i]*dnorm(arg)/(nobs*sigma[m]))
				}
		# Compute Hessian
			Qtemp <- matrix(0,nobs,k-1)
			for(i in 1:(k-1)){
				Qtemp[,i] <- (y-(1-taum))*x[,i]*(-arg)*dnorm(arg)/(sigma[m]^2)
			}
			Q <- t(x[,1:(k-1)]) %*% Qtemp /nobs
		eigmax <- max(eigen(Q,only.values=T)$values)
		if(eigmax<0) {
			cat("iteration ", iter, ": ")
			beta1 <- c(beta[1:k-1] - solve(Q) %*% TS,sgn*1)		# Newton-Raphson
			}
		else {
			cat("iteration ", iter, "(non concave function encountered) : ")
			beta1 <- c(beta[1:k-1] - solve(Q-as.double(eigmax+rho*sqrt(crossprod(TS)))*diag(k-1)) %*% TS,sgn*1)
			}
		ftrial <- 1/nobs*sum((y-(1-taum))*
				pnorm((as.matrix(x[,1:(k-1)],nobs,k-1)%*%beta1[1:(k-1)]+sgn*x[,k])/sigma[m]))
		diff <- ftrial - fmax
		if(diff>0) {
			fmax <- ftrial
			beta <- beta1
			cat("objective =",
#				format(round(beta, 8)), 
				format(round(fmax,8)), "\n"
				)
			}
		iter <- iter + 1
		}


	cat("\n",
		"Hill-Climbing finished."                        , "\n")
	
	if(iter>maxhill) cat("Maximum number of Hill-Climbing iterations reached without convergence.")

	}				# End of Hill-Climbing iterations.

cat("\n",
	"Final Estimates"                                 , "\n",
	"---------------"                                 , "\n",
	xnames, "Objective",                              , "\n", 
	format(round(beta, 8)), format(round(fmax,8))     , "\n\n"
	)

betavec <- cbind(betavec,beta)
objvec <- cbind(objvec,fmax)
}					# End of tau iteration.


#print(betavec)
#**********************************************************************


#**********************************************************************
#	  			PART III			      
#       Calculation of Covariance matrix and Bias Correction.	      
#**********************************************************************

lambda <- matrix(0,p,1)
sigmaopt <- matrix(0,p,1)

for(m in 1:p){
       taum <- tau[m]
       argm  <- (as.matrix(x[,1:(k-1)],nobs,k-1)%*%betavec[1:(k-1),m]+sgn*x[,k])/sigma[m]
       argmd <- (as.matrix(x[,1:(k-1)],nobs,k-1)%*%betavec[1:(k-1),m]+sgn*x[,k])/sigmad[m]
#*****
       Dtemp <- matrix(0,nobs,k-1)									# Initialize Dtemp.
       for(i in 1:(k-1)){
	         Dtemp[,i] <- 0.282094792*taum*(1-taum)*x[,i]*dnorm(argm)
	         }
       Dmm <- t(as.matrix(x[,1:(k-1)],nobs,k-1)) %*% Dtemp / (sigma[m]*nobs)		# Compute Dmm.
#*****
       Qtemp <- matrix(0,nobs,k-1)									# Initialize Qtemp.
       for(i in 1:(k-1)){
	       Qtemp[,i] <- (y-(1-taum))*x[,i]*(-argm)*dnorm(argm)
	       }
       Qm <- t(x[,1:(k-1)]) %*% Qtemp / (nobs*sigma[m]^2)					# Compute Qm.
#*****
       Am <- matrix(0,k-1,1)										# Initialize Am.
       for(i in 1:(k-1)){
	       Am[i] <- 1/(nobs*sigmad[m]^3)*sum((y-(1-taum))*x[,i]*dnorm(argmd))
	       }
#*****
       Smm <- solve(Qm) %*% Dmm %*% solve(Qm)							# Compute Smm.

       Bm <- solve(Qm) %*% Am

       lambda[m]  <- as.double(sum(diag(Smm))/(4*t(Bm)%*%Bm))				# Compute lambdam.

       sigmaopt[m] <- (lambda[m]/nobs)^(1/5)

}

Svec <- NULL
Biasvec <- NULL

for(m in 1:p) {
   Svectemp <- NULL
   for (r in 1:p) {
       taum <- tau[m]
       taur <- tau[r]

       argm  <- (as.matrix(x[,1:(k-1)],nobs,k-1)%*%betavec[1:(k-1),m]+sgn*x[,k])/sigma[m]
       argr  <- (as.matrix(x[,1:(k-1)],nobs,k-1)%*%betavec[1:(k-1),r]+sgn*x[,k])/sigma[r]
       argmd <- (as.matrix(x[,1:(k-1)],nobs,k-1)%*%betavec[1:(k-1),m]+sgn*x[,k])/sigmad[m]
       argrd <- (as.matrix(x[,1:(k-1)],nobs,k-1)%*%betavec[1:(k-1),r]+sgn*x[,k])/sigmad[r]
#*****  
       Dtemp <- matrix(0,nobs,k-1)					# Initialize Dtemp.
       if(taum==taur){
         for(i in 1:(k-1)){
	         Dtemp[,i] <- 0.282094792*taum*(1-taum)*x[,i]*dnorm(argm)
	         }
         }
       else{
         for(i in 1:(k-1)){
	         Dtemp[,i] <- (min(taum,taur)-taum*taur)*x[,i]*dnorm(argm)*dnorm(argr)
	         }
         }
       Dmr <- t(as.matrix(x[,1:(k-1)],nobs,k-1)) %*% Dtemp / (sqrt(sigma[m])*sqrt(sigma[r])*nobs)	# Compute Dmr.

#*****
       Qtemp <- matrix(0,nobs,k-1)									# Initialize Qtemp.
       for(i in 1:(k-1)){
	       Qtemp[,i] <- (y-(1-taum))*x[,i]*(-argm)*dnorm(argm)
	       }
       Qm <- t(as.matrix(x[,1:(k-1)],nobs,k-1)) %*% Qtemp / (nobs*sigma[m]^2)		# Compute Qm.

#*****
       Qtemp <- matrix(0,nobs,k-1)									# Initialize Qtemp.
       for(i in 1:(k-1)){
	       Qtemp[,i] <- (y-(1-taur))*x[,i]*(-argr)*dnorm(argr)
	       }
       Qr <- t(as.matrix(x[,1:(k-1)],nobs,k-1)) %*% Qtemp / (nobs*sigma[r]^2)		# Compute Qr.

#*****
       Am <- matrix(0,k-1,1)										# Initialize Am.
       for(i in 1:(k-1)){
	       Am[i] <- 1/(nobs*sigmad[m]^3)*sum((y-(1-taum))*x[,i]*dnorm(argmd))
	       }
#*****
       Ar <- matrix(0,k-1,1)										# Initialize Ar.
       for(i in 1:(k-1)){
	       Ar[i] <- 1/(nobs*sigmad[r]^3)*sum((y-(1-taur))*x[,i]*dnorm(argrd))
	       }
#*****
       Smr <- solve(Qm) %*% Dmr %*% solve(Qr)							# Compute Smr.
       Bm <- solve(Qm) %*% Am
       Br <- solve(Qr) %*% Ar

if(bc){Svectemp <- cbind(Svectemp,lambda[m]^(-1/10)*Smr*lambda[r]^(-1/10))}		# Construct Svectemp.
else {Svectemp <- cbind(Svectemp,Smr)}
	
       }

       Svec <- rbind(Svec,Svectemp)									# Construct Svec.
       Biasm <- -(lambda[m]/nobs)^(2/5) * Bm							# Compute Biasm.
       Biasvec <- cbind(Biasvec,Biasm)								# Construct Biasvec.
   }


#***************************
# Bias Corrected estimates.*
#***************************
betavecbc <- betavec	
if(bc){													# Initialize betavecbc(tau).
	for(m in 1:p){						
		betavecbc[1:(k-1),m] <- betavec[1:(k-1),m]-Biasvec[,m]
		}
	}	
else {
	for(m in 1:p){						
		betavecbc[1:(k-1),m] <- betavec[1:(k-1),m]
		}
	}	
	

#**************************
# Compute standard errors.*
#**************************
Svecdiag<-diag(Svec)

sigmaiter <- NULL
for (m in 1:p){
	sigmaiter<-c(sigmaiter,rep(sigma[m],k-1))
	}

ses <- matrix(0,(k-1)*p,1)
numiter <-(k-1)*p
for (iter in 1:numiter){
	ses[iter] <- sqrt( Svecdiag[iter]/(nobs*sigmaiter[iter]) )
	}
ses <- matrix(ses,k-1,p)
ses <- rbind(ses,rep(NA,p))



#***********************
# Compute t-statistics.*
#***********************

tstats<-matrix(0,k,p)
for(m in 1:p) {
	tstats[,m] <- betavecbc[1:k,m] / ses[,m]
	}


#return(betabc=betavecbc,ses=ses,tstats=tstats)
#*********************************************************
# Set names for the columns and rows of computed matrices.
#*********************************************************
#dimnames(D) <- list(xnames[1:(k-1)], xnames[1:(k-1)])
#dimnames(Q) <- list(xnames[1:(k-1)], xnames[1:(k-1)])
#dimnames(A) <- list(xnames[1:(k-1)],"")
#dimnames(B) <- list(xnames[1:(k-1)],"")
#dimnames(S) <- list(xnames[1:(k-1)], xnames[1:(k-1)])

dimnames(Svec) <- list(rep(xnames[1:(k-1)],p), rep(xnames[1:(k-1)],p))

#**********************************************************************
#	  			PART III
#	     Print Coefficient Estimates and Covariance matrix.
#**********************************************************************

for(m in 1:p){
 cat("\n",
	"*******************************************************************"                    , "\n",
	"                      COEFFICIENT ESTIMATES   "                                         , "\n",
	"*******************************************************************"                    , "\n",
	" Quantile                                   = ", tau[m]                                 , "\n",
	" Number of Observations                     = ", nobs                                   , "\n",
	" Delta                                      = ", format(round(delta[m],5))              , "\n",
	" Lambda                                     = ", format(round(lambda[m],5))             , "\n",
	" Initial Bandwidth                          = ", format(round(sigma[m], 5))             , "\n",
	" Estimated Optimal Bandwidth                = ", format(round(sigmaopt[m], 5))          , "\n",
	" Objective                                  = ", format(round(objvec[m], 10))           , "\n",
	"*******************************************************************"                    , "\n"
	)

tabcoef <- cbind(betavec[,m],betavecbc[,m],ses[,m],tstats[,m],2*(1-pt(abs(tstats[,m]),nobs-k)))

dimnames(tabcoef)<-list(xnames[1:k],c("Uncorrected","Bias-Corrected", "Std. Error", "t-stat.", "p-value"))

print(round(tabcoef,4))

 cat(	"*******************************************************************", "\n" )

}



Summary.info_list(tau=tau, delta=delta, lambda=lambda, sigma=round(sigma,5), 
	sigmaopt=round(sigmaopt,5), objvec=round(objvec, 10), tabcoef=tabcoef, xnames=xnames,
	beta=beta, fmax=fmax,hill=hill, sa=sa,
	maxevl=maxevl,t0=t0,lbc=lbc,ubc=ubc, nt=nt, ns=ns, rt=rt, maxhill=maxhill, rho=rho)

results_list(coef=betavecbc,var=round(Svec,8)/(nobs*sigmaiter	[iter]),k=k,nobs=nobs,sigma=sigma,Summary.info=Summary.info)

class(results)_"sbrq"

return(results)

}


summary.sbrq_function(results)
{
	info_results$Summary.info
	k_results$k
	nobs_results$nobs

	cat("\n",
	"*******************************************************************"             	, "\n",
	"                      COEFFICIENT ESTIMATES   "                                  	, "\n",
	"*******************************************************************"             	, "\n",
	" Quantile                                	= ", info$tau                           	, "\n",
	" Number of Observations                  	= ", nobs	                            	, "\n",
	" Delta                                   	= ", format(round(info$delta,5))        	, "\n",
	" Lambda                                  	= ", format(round(info$lambda,5))       	, "\n",
	" Initial Bandwidth                       	= ", format(round(info$sigma, 5))       	, "\n",
	" Estimated Optimal Bandwidth             	= ", format(round(info$sigmaopt, 5))    	, "\n",
	" Objective                               	= ", format(round(info$objvec, 10))     	, "\n",
	)
	if(info$sa) 
	cat(
	" Maximum Simulated Annealing Iterations	= ", info$maxevl               		, "\n",
      " Initial Temperature                     	= ", format(round(info$t0, 10))		, "\n",
      " Lower and Upper Bound                   	= ", info$lbc, info$ubc      			, "\n",
	" Iterations before Temperature Reduction 	= ", info$nt                       		, "\n",
	" Iterations before Step Adjustment       	= ", info$ns                       		, "\n",
	" Temperature Preservation Factor         	= ", info$rt                       		, "\n"
	)
	else cat(
	" Simulated Annealing 		            	= ", "Turned OFF"           			, "\n"
	)
	if(info$hill) 
	cat(
	"  Maximum Hill-Climbing Iterations	      	= ", info$maxhill                  		, "\n",
	" Rho for Hill-Climbing                   	= ", info$rho                      		, "\n"
	)
	else cat(
	" Hill-Climbing                           	= ", "Turned OFF" 	          		, "\n"
	)
	cat(" *******************************************************************", "\n" )


	print(round(info$tabcoef,4))

	cat(" *******************************************************************", "\n" )

}


normalize_function(results,scale=1)
{
  UseMethod("normalize")
  results$coef/scale	
}

normalize.sbrq_function(results)
{
	beta <- results$coef
	S <- results$var
	k <- results$k
	info_results$Summary.info
	sigma <- info$sigma
	nobs <- results$nobs
	xnames_info$xnames
	
	norm <-  as.double((sum(beta^2))^(1/2))
	betan <- beta/norm
	G <- (1/norm)*rbind(diag(k-1),matrix(0,1,k-1)) - ((beta[1:k] %*% t(beta[1:(k-1)])/norm^3))
	GSG <- G %*% S %*% t(G)
	ses<-sqrt(diag(GSG)/(sigma*nobs))
	tstats<-betan/ses

	tabcoef <- cbind(betan, ses, tstats, 2*(1-pt(abs(tstats),nobs-k)))

	dimnames(tabcoef)<-list(xnames[1:k],c("Coefficient", "Std. Error", "t-stat.", "p-value"))
	
	cat("\n",
	"*******************************************************************"             	, "\n",
	"       COEFFICIENT ESTIMATES - NORMALIZED TO ||BETA||=1  "                        	, "\n",
	"*******************************************************************"             	, "\n",
	" Quantile                                	= ", info$tau                           	, "\n",
	" Number of Observations                  	= ", nobs	                            	, "\n",
	" Delta                                   	= ", format(round(info$delta,5))        	, "\n",
	" Lambda                                  	= ", format(round(info$lambda,5))       	, "\n",
	" Initial Bandwidth                       	= ", format(round(info$sigma, 5))       	, "\n",
	" Estimated Optimal Bandwidth             	= ", format(round(info$sigmaopt, 5))    	, "\n",
	" Objective                               	= ", format(round(info$objvec, 10))     	, "\n",
	)
   if(info$sa) 
	cat(
	" Maximum Simulated Annealing Iterations	= ", info$maxevl               		, "\n",
      " Initial Temperature                     	= ", format(round(info$t0, 10))		, "\n",
      " Lower and Upper Bound                   	= ", info$lbc, info$ubc      			, "\n",
	" Iterations before Temperature Reduction 	= ", info$nt                       		, "\n",
	" Iterations before Step Adjustment       	= ", info$ns                       		, "\n",
	" Temperature Preservation Factor         	= ", info$rt                       		, "\n"
	)
   else cat(
	" Simulated Annealing 		            	= ", "Turned OFF"           			, "\n"
	)
   if(info$hill) 
	cat(
	"  Maximum Hill-Climbing Iterations	      	= ", info$maxhill                  		, "\n",
	" Rho for Hill-Climbing                   	= ", info$rho                      		, "\n"
	)
   else cat(
	" Hill-Climbing                           	= ", "Turned OFF" 	          		, "\n"
	)
	cat(" *******************************************************************", "\n" )


	print(round(tabcoef,4))

	cat(" *******************************************************************", "\n" )


}
