#
# This is a striped function which is called by the bootstrap section of the brq function.
# You should not be using this function directly. 
#
#
brq.b_function(data, tau=0.5, start, lbc, ubc, rt=0.15, eps=1.0E-6,
       ns=10, nt=20, int=T, neps=4, maxevl=10000000, sl, vm, seed1=1,
       seed2=2, t=10, sgn=1)
{

###if(!is.loaded(symbol.For("sams"))) dyn.load("sams.o")

###dll.load("brq.dll",c("_saa_","_fcna_"))

if(!is.loaded(symbol.C("_saa_"))) stop("Compiled code has not been loaded")
if(!is.loaded(symbol.C("_fcna_"))) stop("Compiled code has not been loaded")


#**********************************************************************
#				PART I
#   Check the inputs of the function, read data and set parameters.
#**********************************************************************

nvar_ncol(data)
x <- as.matrix(data[,2:nvar])
if(int) x <- cbind(1,x)
y <- as.vector(data[,1])
nobs <- nrow(x)
k <- ncol(x)

if(missing(start)){
	prob.mod<-glm(y~1+x,family=binomial(link=probit))
	start <- coef(prob.mod)/coef(prob.mod)[k]
	}
else{start <- as.vector(start)}

if(missing(lbc)) {stop("You must supply a lower bound for the parameter space (lbc)")}
if(missing(ubc)) {stop("You must supply an upper bound for the parameter space (ubc)")}

lb <- c(rep(lbc, k),1)
ub <- c(rep(ubc, k),1)

#**************************************************
# Get the names of the variables.
#**************************************************

if(int) xnames <- c("intercept", dimnames(x) [[2]] [2:k])
else xnames <- dimnames(x) [[2]] [1:k]



#**************************************************
# Check that the starting values are within bounds.
#**************************************************

for(i in 1:k) {
   	if(start[i]<lb[i] | start[i]>ub[i]) stop("The starting values
	(start) are out of bounds. Respecify start and/or lbc and ubc so
	that -lbc < start(i) < ubc,  i=1,..,k") 
	}

if(missing(sl)) {sl <- rep(2, k)}
if(missing(vm)) {vm <- rep(1, k)}


#************************************************
# Check the seed of the random number generator.*
#************************************************

if(seed1<0 | seed1>31328 | seed2<0 | seed2>30081)
    	stop("The first number seed (seed1) must have a value between 0
	and 31328 and the second value seed (seed2) must have a value between
	0 and 30081.")

#***********************************************
# Check initial temperature
#***********************************************

if(t<=0) stop(" The initial temperature (t) is not positive.
Reset t to a positive number.")



#***********************************************
# Evaluate the objective at the starting values.
#***********************************************

out1 <- .C("_fcna_",
         as.double(y),
         as.double(x),
         as.integer(nobs),
         as.integer(k),
         start = as.double(start),
         obj = as.double(0),
         tau = as.double(tau),
	   as.double(sgn)
         )


#**********************************************************************
# 		Invoke the SA algorithm for function optimization.    *
#**********************************************************************


out2 <- .C("_saa_",
         as.double(y),
         as.double(x),
         as.integer(nobs),
         as.integer(k),
         as.double(start),
         tau = as.double(tau),
         as.logical(T),
         as.double(rt),
         as.double(eps),
         as.integer(ns),
         as.integer(nt),
         as.integer(neps),
         as.integer(maxevl),
         as.double(lb),
         as.double(ub),
         as.double(sl),
         as.double(seed1),
         as.double(seed2),
         as.double(t),
         as.double(vm),
         coef = as.double(start),
         obj = as.double(0),
         as.integer(0),
         as.integer(0),
         as.integer(0),
         as.integer(0),
         as.double(start),
         as.double(start),
         as.integer(start),
         aflag = as.integer(0),
	   as.double(sgn)
         )

if(out2$aflag!=0)
	warning("Maximum number of evaluations has been reached. Consider increasing maxevl	
	or eps, or decreasing nt or rt. These results are likely to be poor.")

return(coef=out2$coef)
}
