brq_function(y, x, tau=0.5, start, lbc, ubc, rt=0.15, eps=1.0E-6,
       ns=10, nt=20, int=T, neps=4, maxevl=10000000, sl, vm, seed1=1,
       seed2=2, t=10, sgn=1, bstrap=F, B=20)
{

###if(!is.loaded(symbol.For("sams"))) dyn.load("sams.o")

###dll.load("brq.dll",c("_saa_","_fcna_"))

if(!is.loaded(symbol.C("_saa_"))) stop("Compiled code has not been loaded")
if(!is.loaded(symbol.C("_fcna_"))) stop("Compiled code has not been loaded")
	

#**********************************************************************
#				PART I
#   Check the inputs of the function, read data and set parameters.
#**********************************************************************

x <- as.matrix(x)
if(int) x <- cbind(1,x)
y <- as.vector(y)
nobs <- nrow(x)
k <- ncol(x)

if(missing(start)) {
	prob.mod<-glm(y~1+x,family=binomial(link=probit))
	start <- coef(prob.mod)/coef(prob.mod)[k]
	}
else{start <- as.vector(start)}


if(missing(lbc)) {stop("You must supply a lower bound for the parameter space (lbc)")}
if(missing(ubc)) {stop("You must supply a upper bound for the parameter space (lbc)")}

lb <- c(rep(lbc, k),1)
ub <- c(rep(ubc, k),1)

#**************************************************
# Get the names of the variables.
#**************************************************

if(int) xnames <- c("intercept", dimnames(x) [[2]] [2:k])
else xnames <- dimnames(x) [[2]] [1:k]



#**************************************************
# Check that the starting values are within bounds.
#**************************************************

for(i in 1:k) {
   	if(start[i]<lb[i] | start[i]>ub[i]) stop("The starting values
	(start) are out of bounds. Respecify start and/or lbc and ubc so
	that lbc < start(i) < ubc,  i=1,..,k") 
	}

if(missing(sl)) {sl <- rep(2, k)}
if(missing(vm)) {vm <- rep(1, k)}


#************************************************
# Check the seed of the random number generator.*
#************************************************

if(seed1<0 | seed1>31328 | seed2<0 | seed2>30081)
    stop("The first number seed (seed1) must have a value between 0
and 31328 and the second value seed (seed2) must have a value between
0 and 30081.")

#***********************************************
# Check initial temperature
#***********************************************

if(t<=0) stop(" The initial temperature (t) is not positive.
Reset t to a positive number.")


#***********************************************
# Evaluate the objective at the starting values.
#***********************************************

out1 <- .C("_fcna_",
         as.double(y),
         as.double(x),
         as.integer(nobs),
         as.integer(k),
         start = as.double(start),
         obj = as.double(0),
         tau = as.double(tau),
	   as.double(sgn)
         )


cat("\n",
	 "Date: ", substring(date(),1,10), substring(date(),25,28)                , "\n",
	                                                                            "\n",
	 "*******************************************************************"    , "\n",
	 "         ESTIMATION OF BINARY REGRESSION QUANTILES   "                  , "\n",
	 "                BY SIMULATED ANNEALING                   "              , "\n",
	 "*******************************************************************"    , "\n",
	 " Quantile                                = ", tau                       , "\n",
	 " Number of Observations                  = ", nobs                      , "\n",
	 " Maximum Simulated Annealing Iterations  = ", maxevl                    , "\n",
       " Initial Temperature                     = ", format(round(t, 10))      , "\n",
       " Lower and Upper Bound                   = ", lbc, ubc                  , "\n",
	 " Iterations before Temperature Reduction = ", nt                        , "\n",
	 " Iterations before Step Adjustment       = ", ns                        , "\n",
	 " Temperature Preservation Factor         = ", rt                        , "\n")
if(bstrap) cat(
	 "  Number of bootstrap replications        = ", B                         , "\n")
else cat(
	 "  Number of bootstrap replications        = ", "TURNED OFF"              , "\n")
cat(	 "*******************************************************************"    , "\n")


#**********************************************************************
# 		Invoke the SA algorithm for function optimization.    *
#**********************************************************************

cat("\n",
	" Invoking the SA maximization routine."                                 , "\n",
	" Please wait..."                                                        , "\n"
	)

out2 <- .C("_saa_",
         as.double(y),
         as.double(x),
         as.integer(nobs),
         as.integer(k),
         as.double(start),
         tau = as.double(tau),
         as.logical(T),
         as.double(rt),
         as.double(eps),
         as.integer(ns),
         as.integer(nt),
         as.integer(neps),
         as.integer(maxevl),
         as.double(lb),
         as.double(ub),
         as.double(sl),
         as.double(seed1),
         as.double(seed2),
         as.double(t),
         as.double(vm),
         coef = as.double(start),
         obj = as.double(0),
         as.integer(0),
         as.integer(0),
         as.integer(0),
         as.integer(0),
         as.double(start),
         as.double(start),
         as.integer(start),
         aflag = as.integer(0),
	 as.double(sgn)
         )

if(out2$aflag!=0)
    warning("Maximum number of evaluations has been reached. Consider increasing maxevl
             or eps, or decreasing nt or rt. These results are likely
             to be poor.")

cat("\n", " SA finished", "\n")

beta <- out2$coef

beta[k]_beta[k]*sgn


#**********************************************************************
#	        			PART III			      
#       Bootstrap standard errors and confindence intervals	      
#**********************************************************************

if(bstrap)
{
	cat("\n", " Computing bootstrap replications... ", "\n")

	data_cbind(y, x[,2:k])
	args_list(tau=tau, start=beta, lbc=lbc, ubc=ubc, rt=rt, eps=eps,
      	ns=20, nt=20, int=int, neps=neps, maxevl=maxevl, sl=sl, vm=vm, seed1=seed1,
       	seed2=seed2, t=t, sgn=sgn)
	
	bootstrap.results_bootstrap(data, brq.b, args.stat=args, B=B, trace=F, block.size=5)

	ci_limits.emp(bootstrap.results)
}

#**********************************************************************
#	  			PART III
#	     Print Coefficient Estimates and Covariance matrix.
#**********************************************************************



if(bstrap){
	tabcoef <- cbind(beta,bootstrap.results$estimate[,3],ci[,1],ci[,4])
	dimnames(tabcoef)<-list(xnames[1:k],c("Coefficient","Standard error", "CI lower bound", "CI upper bound"))
	}
else {
	tabcoef <- as.vector(beta)
	names(tabcoef)<-xnames[1:k]
	}

Summary.info_list(tau=tau, start=start, lbc=lbc, ubc=ubc, rt=rt, eps=eps,
      ns=ns, nt=nt, int=int, neps=neps, maxevl=maxevl, sl=sl, vm=vm, seed1=seed1,
      seed2=seed2, t=t, sgn=sgn, bstrap=bstrap,B=B, 
	xnames=xnames, beta=beta, fmax=out2$obj, k=k, nobs=nobs, tabcoef=tabcoef)



cat("\n",
	"*******************************************************************"         , "\n",
	"                      COEFFICIENT ESTIMATES          "                       , "\n",
	"*******************************************************************"         , "\n",
	" Quantile                                = ", tau                            , "\n",
	" Number of Observations                  = ", nobs                           , "\n",
	" Objective                               = ", format(round(out2$obj, 10))    , "\n")
if(bstrap) cat(
      "  Number of bootstrap replications        = ", B                         	, "\n")
else cat(
      "  Number of bootstrap replications        = ", "TURNED OFF"              	, "\n")
cat(	 "*******************************************************************"    	, "\n")

print(round(tabcoef,4))

 cat(	"*******************************************************************", "\n" )

if(bstrap) cat(
	" 95% Confidence Intervals based on empirical percentiles method. "      , "\n")



if(bstrap) results_list(coef=beta, tau=out2$tau, bootstrap.results=bootstrap.results, Summary.info=Summary.info)
else results_list(coef=beta, tau=out2$tau, Summary.info=Summary.info)

class(results)_"brq"


return(results)

}




summary.brq_function(results)
{
	info_results$Summary.info
	k_info$k
	nobs_info$nobs

	cat("\n",
	"*******************************************************************"             	, "\n",
	"                      COEFFICIENT ESTIMATES   "                                  	, "\n",
	"*******************************************************************"             	, "\n",
	" Quantile                                	= ", info$tau                       , "\n",
	" Number of Observations                  	= ", nobs	                        , "\n",
	" Objective                               	= ", format(round(info$fmax, 10))   , "\n",
	" Maximum Simulated Annealing Iterations        = ", info$maxevl               	, "\n",
      " Initial Temperature                     	= ", format(round(info$t, 10))	, "\n",
      " Lower and Upper Bound                   	= ", info$lbc, info$ubc      		, "\n",
	" Iterations before Temperature Reduction 	= ", info$nt                       	, "\n",
	" Iterations before Step Adjustment       	= ", info$ns                       	, "\n",
	" Temperature Preservation Factor         	= ", info$rt                       	, "\n"
	)
if(info$bstrap) cat(
      "  Number of bootstrap replications        	= ", info$B                         		, "\n")
else cat(
      "  Number of bootstrap replications        = ", "TURNED OFF"              		, "\n")
cat(	 " *******************************************************************"    		, "\n")

	print(round(info$tabcoef,4))

cat(" *******************************************************************"			, "\n" )

}
