function [forecasts_for] = forecasts_from2for(forecasts_from)
% re-allocates forecasts, such that each row in forecasts_for corresponds
% to forecasts FOR a certain period t, whereas each row in forecasts_from
% corresponds to forecasts FROM a certain period t

% input
% forecasts_from: (TxH) matrix of forecasts y(t+h|t), t= 1,2,...,T, h=1,2,...,H
%                  i.e. element forecasts_from(t,h) contains forecast y(t+h|t)

% output
% forecasts_for: (TxH) matrix of forecasts FOR a certain period t
%                 i.e. element forecasts_for(t,h) contains forecast y(t|t-h)
%                 elements in upper right corner are NaNs
%                 for instance, forecasts_for(1,1) is NaN, because forecast y(1|0) is unknown
%                 forecasts_for(1,2) and forecasts_for(2,2) are NaN, because forecasts y(1|-1) and y(2|0) are unknown
%                 etc.
%                 Moreover, all forecasts for t+h are deleted

T = size(forecasts_from,1);
H = size(forecasts_from,2);

forecasts_for = NaN(T,H);
for h = 1:H
    forecasts_for(1+h:T,h) = forecasts_from(1:T-h,h);
end
    
