MAcoefs <- function (Sigma, ARcoefs, H = 10)
{
    nstep <- H - 1
    nstep <- abs(as.integer(nstep))
    K <- dim(Sigma)[1]
    p <- length(ARcoefs)
    if (nstep >= p) {
        As <- array(0, dim = c(K, K, nstep + 1))
        for (i in (p + 1):(nstep + 1)) {
            As[, , i] <- matrix(0, nrow = K, ncol = K)
        }
    }
    else {
        As <- array(0, dim = c(K, K, p))
    }
    for (i in 1:p) {
        As[, , i] <- ARcoefs[[i]]
    }
    Phi <- array(0, dim = c(K, K, nstep + 1))
    Phi[, , 1] <- diag(K)
    Phi[, , 2] <- Phi[, , 1] %*% As[, , 1]
    if (nstep > 1) {
        for (i in 3:(nstep + 1)) {
            tmp1 <- Phi[, , 1] %*% As[, , i - 1]
            tmp2 <- matrix(0, nrow = K, ncol = K)
            idx <- (i - 2):1
            for (j in 1:(i - 2)) {
                tmp2 <- tmp2 + Phi[, , j + 1] %*% As[, , idx[j]]
            }
            Phi[, , i] <- tmp1 + tmp2
        }
    }
    return(Phi)
} 

data_vola <- read.csv(file="WeeklyVolatilities.csv")
require(vars)
EstRes <- VAR(data_vola[-c(1,2)],p=2)
Sigma <- summary(EstRes)$covres
A <-  MAcoefs(Sigma,Acoef(EstRes), 10)
require(fastSOM)
#Attention: if you run soi_avg_exact, this may take some time. Using R 2.15.2., it took about 42 minutes on an Intel Core i7-2600 CPU@3.40 GHz, using R 3.0.0, it took 38 minutes.
#			soi_avg_exact computes (inter alia) the exact minimal and maximal value of the spillover measure applied to the whole data set.
#res_Ret <- soi_avg_exact(Sigma,A,ncores=0)

#Remark: for the figures in the paper, the above procedure was done for a rolling windows approach, i.e. the VAR command was applied to all 630 windows of length 200 weeks each, 
#			and then for each of these, soi_avg_exact was invoked.