clear;clc;close all;

%-------------------------------------------------------------------
% call getdata.m to fetch the data, adjust the getdata.m function if
% different / more variables shall be used
%-------------------------------------------------------------------
[years,y,g,t,r,ex,p,infl,ly,lg,lt,ls,ld,lex,lp,countries,ifs,year,crisis,lrate,mgov,mpers,Dmgov,wardummy,mgov2,taxrate,infl2,...
    eq_tr,eq_capgain,capital_tr,risky_tr,safe_tr,nex,inv,linv,c]=getdata_jst_panel_inv;

%Specify time period
Myear=reshape(year,[years,countries]);
t1=find(Myear(:,1)==1917);              %Start date
t2=find(Myear(:,1)==2016);              %End date

y=cutsample(t1,t2,y);
g=cutsample(t1,t2,g);
t=cutsample(t1,t2,t);
r=cutsample(t1,t2,r);
ex=cutsample(t1,t2,ex);
p=cutsample(t1,t2,p);
infl=cutsample(t1,t2,infl./100);
infl2=cutsample(t1,t2,infl2./100);
ly=cutsample(t1,t2,ly);
lg=cutsample(t1,t2,lg);
mgov2=cutsample(t1,t2,mgov2.*100);
lmg=log(mgov2);
Dmgov=cutsample(t1,t2,Dmgov.*100);
lt=cutsample(t1,t2,lt);
ls=cutsample(t1,t2,ls);
ld=cutsample(t1,t2,ld);
lex=cutsample(t1,t2,lex);
lp=cutsample(t1,t2,lp);
year=cutsample(t1,t2,year);
crisis=cutsample(t1,t2,crisis);
lrate=cutsample(t1,t2,lrate./100);
ifs=cutsample(t1,t2,ifs);
wardummy=cutsample(t1,t2,wardummy);

eq_tr=cutsample(t1,t2,eq_tr);
eq_capgain=cutsample(t1,t2,eq_capgain);
capital_tr=cutsample(t1,t2,capital_tr);
risky_tr=cutsample(t1,t2,risky_tr);
safe_tr=cutsample(t1,t2,safe_tr);

inv=cutsample(t1,t2,inv);
linv=cutsample(t1,t2,linv);

years=size(y,1)./countries;


Mr=reshape(r,[years,countries]);
Mcrisis=reshape(crisis,[years,countries]);
Myear=reshape(year,[years,countries]);
r=r./100;

interestrate=eq_capgain./10;

ci = 1.645;  %90%
ci2 = 1;      %68%

egy=0.0;        %Elastictiy of G to Y

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Calculate Indicator Variable
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

meanr=mean(Mr(:,:));
stdr=std(Mr(:,:));
quan= quantile(Mr(:,:),0.05);

%Constant Interest Rates
MIr=zeros(size(Mr));
MIr2=zeros(size(Mr));

for i=1:countries
   for j=1:size(MIr2,1)-1
       MIr2(j+1,i)=Mr(j+1,i)-Mr(j,i);
   end
end


for i=1:countries
   for j=1:size(MIr,1)-1
       %if Mr(j,i)<=meanr(:,i)-1*stdr(:,i)
       %if Mr(j,i)<=quan(:,i)
       %if abs(MIr2(j,i))<=0.01
       if Mr(j,i)<=1
        MIr(j+1,i)=1;
        %elseif Mr(j,i)>meanr(:,i)-1*stdr(:,i)
        %elseif Mr(j,i)>quan(:,i)
        %elseif abs(MIr2(j,i))~=0.01
        elseif Mr(j,i)>1
       MIr(j+1,i)=0;
        end
   end   
end


Ir=reshape(MIr,[countries*years,1]);
I=Ir;

nlags=4; %Number of lags we are interested in +1

MI = reshape(I,[years,countries]);
MI(1:nlags-1,:) =[];
I= reshape(MI,[countries*years-countries*(nlags-1),1]);

MLy=reshape(ly,[years,countries]);
MLy=MLy(nlags-1:end-1,:);
Ly = reshape(MLy,[countries*years-countries*(nlags-1),1]);

ML2y=reshape(ly,[years,countries]);
ML2y=ML2y(nlags-2:end-2,:);
L2y = reshape(ML2y,[countries*years-countries*(nlags-1),1]);

ML3y=reshape(ly,[years,countries]);
ML3y=ML3y(nlags-3:end-3,:);
L3y = reshape(ML3y,[countries*years-countries*(nlags-1),1]);

MLg = reshape(lg,[years,countries]);
MLg=MLg(nlags-1:end-1,:);
Lg = reshape(MLg,[countries*years-countries*(nlags-1),1]);

ML2g=reshape(lg,[years,countries]);
ML2g=ML2g(nlags-2:end-2,:);
L2g = reshape(ML2g,[countries*years-countries*(nlags-1),1]);

ML3g=reshape(lg,[years,countries]);
ML3g=ML3g(nlags-3:end-3,:);
L3g = reshape(ML3g,[countries*years-countries*(nlags-1),1]);

MLmg = reshape(lmg,[years,countries]);
MLmg=MLmg(nlags-1:end-1,:);
Lmg = reshape(MLmg,[countries*years-countries*(nlags-1),1]);

ML2mg=reshape(lmg,[years,countries]);
ML2mg=ML2mg(nlags-2:end-2,:);
L2mg = reshape(ML2mg,[countries*years-countries*(nlags-1),1]);

ML3mg=reshape(lmg,[years,countries]);
ML3mg=ML3mg(nlags-3:end-3,:);
L3mg = reshape(ML3mg,[countries*years-countries*(nlags-1),1]);

MLr = reshape(r,[years,countries]);
MLr=MLr(nlags-1:end-1,:);
Lr = reshape(MLr,[countries*years-countries*(nlags-1),1]);

ML2r=reshape(r,[years,countries]);
ML2r=ML2r(nlags-2:end-2,:);
L2r = reshape(ML2r,[countries*years-countries*(nlags-1),1]);

ML3r=reshape(r,[years,countries]);
ML3r=ML3r(nlags-3:end-3,:);
L3r = reshape(ML3r,[countries*years-countries*(nlags-1),1]);

MLR = reshape(interestrate,[years,countries]);
MLR=MLR(nlags-1:end-1,:);
LR = reshape(MLR,[countries*years-countries*(nlags-1),1]);

ML2R=reshape(interestrate,[years,countries]);
ML2R=ML2R(nlags-2:end-2,:);
L2R = reshape(ML2R,[countries*years-countries*(nlags-1),1]);

ML3R=reshape(interestrate,[years,countries]);
ML3R=ML3R(nlags-3:end-3,:);
L3R = reshape(ML3R,[countries*years-countries*(nlags-1),1]);

MLrlong = reshape(lrate,[years,countries]);
MLrlong=MLrlong(nlags-1:end-1,:);
Lrlong = reshape(MLrlong,[countries*years-countries*(nlags-1),1]);

ML2rlong=reshape(lrate,[years,countries]);
ML2rlong=ML2rlong(nlags-2:end-2,:);
L2rlong = reshape(ML2rlong,[countries*years-countries*(nlags-1),1]);

ML3rlong=reshape(lrate,[years,countries]);
ML3rlong=ML3rlong(nlags-3:end-3,:);
L3rlong = reshape(ML3rlong,[countries*years-countries*(nlags-1),1]);

MLex = reshape(lex,[years,countries]);
MLex=MLex(nlags-1:end-1,:);
Lex = reshape(MLex,[countries*years-countries*(nlags-1),1]);

ML2ex=reshape(lex,[years,countries]);
ML2ex=ML2ex(nlags-2:end-2,:);
L2ex = reshape(ML2ex,[countries*years-countries*(nlags-1),1]);

ML3ex=reshape(lex,[years,countries]);
ML3ex=ML3ex(nlags-3:end-3,:);
L3ex = reshape(ML3ex,[countries*years-countries*(nlags-1),1]);

MLp = reshape(lp,[years,countries]);
MLp=MLp(nlags-1:end-1,:);
Lp = reshape(MLp,[countries*years-countries*(nlags-1),1]);

ML2p=reshape(lp,[years,countries]);
ML2p=ML2p(nlags-2:end-2,:);
L2p = reshape(ML2p,[countries*years-countries*(nlags-1),1]);

ML3p=reshape(lp,[years,countries]);
ML3p=ML3p(nlags-3:end-3,:);
L3p = reshape(ML3p,[countries*years-countries*(nlags-1),1]);

MLinfl = reshape(infl,[years,countries]);
MLinfl=MLinfl(nlags-1:end-1,:);
Linfl = reshape(MLinfl,[countries*years-countries*(nlags-1),1]);

ML2infl=reshape(infl,[years,countries]);
ML2infl=ML2infl(nlags-2:end-2,:);
L2infl = reshape(ML2infl,[countries*years-countries*(nlags-1),1]);

ML3infl=reshape(infl,[years,countries]);
ML3infl=ML3infl(nlags-3:end-3,:);
L3infl = reshape(ML3infl,[countries*years-countries*(nlags-1),1]);

MLs = reshape(ls,[years,countries]);
MLs=MLs(nlags-1:end-1,:);
Ls = reshape(MLs,[countries*years-countries*(nlags-1),1]);

ML2s=reshape(ls,[years,countries]);
ML2s=ML2s(nlags-2:end-2,:);
L2s = reshape(ML2s,[countries*years-countries*(nlags-1),1]);

ML3s=reshape(ls,[years,countries]);
ML3s=ML3s(nlags-3:end-3,:);
L3s = reshape(ML3s,[countries*years-countries*(nlags-1),1]);

MLinv = reshape(linv,[years,countries]);
MLinv=MLinv(nlags-1:end-1,:);
Linv = reshape(MLinv,[countries*years-countries*(nlags-1),1]);

ML2inv=reshape(linv,[years,countries]);
ML2inv=ML2inv(nlags-2:end-2,:);
L2inv = reshape(ML2inv,[countries*years-countries*(nlags-1),1]);

ML3inv=reshape(linv,[years,countries]);
ML3inv=ML3inv(nlags-3:end-3,:);
L3inv = reshape(ML3inv,[countries*years-countries*(nlags-1),1]);

Mcountry = reshape(ifs,[years,countries]);
Mcountry(1:nlags-1,:) =[];
country = reshape(Mcountry,[countries*years-countries*(nlags-1),1]);

Mwar = reshape(wardummy,[years,countries]);
Mwar(1:nlags-1,:) =[];
Iwar = reshape(Mwar,[countries*years-countries*(nlags-1),1]);

Mcrisis = reshape(crisis,[years,countries]);
Mcrisis(1:nlags-1,:) =[];
Icrisis = reshape(Mcrisis,[countries*years-countries*(nlags-1),1]);

constant= ones(length(Ly),1);
tt=1:1:length(Ly)/countries;
for i=1:countries
    Mt(:,i)=tt;
end
trend=reshape(Mt,[countries*years-countries*(nlags-1),1]);
tsq=trend.^2;

DC=zeros((years-nlags+1)*countries,countries);
for i=1:countries
    DC((i-1)*(years-nlags+1)+1:i*(years-nlags+1),i)=1;
end

DT = zeros((years-nlags+1)*countries,years-nlags+1);
for i=1:countries
    DT((i-1)*(years-nlags+1)+1,1)=1;
end

for j=1:years-nlags+1
      DT(j:end,j)=DT(1:end-j+1,1);
end

%Creating part of the new variables that enter the RHS, which are in
%levels, not logs.
Mynew=reshape(y,[years,countries]);
Mynew=Mynew(nlags:end,:);
ynew = reshape(Mynew,[countries*years-countries*(nlags-1),1]);

MLynew=reshape(y,[years,countries]);
MLynew=MLynew(nlags-1:end-1,:);
Lynew = reshape(MLynew,[countries*years-countries*(nlags-1),1]);

Mrnew=reshape(interestrate,[years,countries]);
Mrnew=Mrnew(nlags:end,:);
rnew = reshape(Mrnew,[countries*years-countries*(nlags-1),1]);

MLrnew=reshape(interestrate,[years,countries]);
MLrnew=MLrnew(nlags-1:end-1,:);
Lrnew = reshape(MLrnew,[countries*years-countries*(nlags-1),1]);

Mgnew=reshape(g,[years,countries]);
Mgnew=Mgnew(nlags:end,:);
gnew = reshape(Mgnew,[countries*years-countries*(nlags-1),1]);

MLgnew=reshape(g,[years,countries]);
MLgnew=MLgnew(nlags-1:end-1,:);
Lgnew = reshape(MLgnew,[countries*years-countries*(nlags-1),1]);

Minvnew=reshape(inv,[years,countries]);
Minvnew=Minvnew(nlags:end,:);
invnew = reshape(Minvnew,[countries*years-countries*(nlags-1),1]);

MLinvnew=reshape(inv,[years,countries]);
MLinvnew=MLinvnew(nlags-1:end-1,:);
Linvnew = reshape(MLinvnew,[countries*years-countries*(nlags-1),1]);

%Gshock identification
ge=Dmgov;
Mshock=reshape(ge,[years,countries]);
Mshock=Mshock(nlags:end,:);
shock = reshape(Mshock,[countries*years-countries*(nlags-1),1]);   

hor=5;
zz=zeros(1,hor);

Xcontrols=[I.*Lg, I.*L2g, I.*L3g, I.*Ly, I.*L2y,  I.*L3y, I.*Lmg, I.*L2mg, I.*L3mg,...
     I.*Lr, I.*L2r, I.*L3r,... 
     I.*Linv, I.*L2inv, I.*L3inv,... 
     I.*Linfl, I.*L2infl, I.*L3infl,... 
     I.*Lex, I.*L2ex,  I.*L3ex,...
     I.*Iwar,...
    (1-I).*Lg, (1-I).*L2g, (1-I).*L3g, (1-I).*Ly, (1-I).*L2y, (1-I).*L3y, (1-I).*Lmg, (1-I).*L2mg, (1-I).*L3mg...
     (1-I).*Lr, (1-I).*L2r, (1-I).*L3r,...
      (1-I).*Linv, (1-I).*L2inv, (1-I).*L3inv,...
    (1-I).*Linfl, (1-I).*L2infl, (1-I).*L3infl,...
    (1-I).*Lex, (1-I).*L2ex, (1-I).*L3ex,...
    (1-I).*Iwar];

%Vector of conrols
X=[I.*shock, (1-I).*shock, constant, I,... 
   Xcontrols,...
    DT(:,1:end-hor), DC(:,2:end)];
rpos=1; %position of the shock
[r,nn]=size(X);

t=size(X,1)/countries;
Mc = reshape(country,[t,countries]);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%LINEAR (Point-to-Point)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear reg b bint se
clear confidence

ggnc=zeros(size(gnew,1),hor);
gIVc=zeros(size(ggnc,1),hor);
ggnd=zeros(size(gnew,1),hor);
gIVd=zeros(size(ggnd,1),hor);

xc=[I.*shock, (1-I).*shock,constant, I,... 
  Xcontrols,...
    DT(:,1:end-hor), DC(:,2:end)];

Xc=[constant, I,... 
   Xcontrols,...
    DT(:,1:end-hor), DC(:,2:end)];
rpos=1;


for i=1:hor

y11=(Mgnew(i:end,:) - MLgnew(1:end-i+1,:))./ Mynew(1:end-i+1,:);
y1 = reshape(y11,[countries*(years-(nlags-1)-i+1),1]);
Mcc = Mc(i:end,:);
c0 = reshape(Mcc,[(t-i+1)*countries,1]);

for k=1:countries 

Mx = zeros((t-i+1)*countries,nn);    
Mxx = reshape(X((k-1)*t+1:k*t,:),t, nn);
Mx = Mxx(1:t-i+1,:);
xx((k-1)*(t-i+1)+1:k*(t-i+1),:) = Mx;
end

results = clusterreg(y1, xx(1:end,:), c0);
bg(:,i) = results(:,1);
gIVc(1:end-i+1,i)=xc(1:end-i+1,:)*bg(:,1);
clear xx
end

clear reg b bint se yhat
clear confidence

shockIVc=gIVc.*I;
shockIVd=gIVc.*(1-I);

for i=1:hor

y22=((Minvnew(i:end,:) - MLinvnew(1:end-i+1,:))./ MLinvnew(1:end-i+1,:));
y2 = reshape(y22,[countries*(years-(nlags-1)-i+1),1]);
Mcc = Mc(i:end,:);
c0 = reshape(Mcc,[(t-i+1)*countries,1]);
gshockc=shockIVc(:,i);
gshockd=shockIVd(:,i);

for k=1:countries 

xYstatec=[gshockc, gshockd, Xc];    
Mx = zeros((t-i+1)*countries,nn);    
Mxx = reshape(xYstatec((k-1)*t+1:k*t,:),t, nn);
Mx = Mxx(1:t-i+1,:);
xx((k-1)*(t-i+1)+1:k*(t-i+1),:) = Mx;
end

results = clusterreg(y2, xx(1:end,:), c0);
by(:,i) = results(:,1);
bint(:,1)= by(:,i)-(results(:,2)*ci);
bint(:,2) = by(:,i)+(results(:,2)*ci);
bint2(:,1)= by(:,i)-(results(:,2)*ci2);
bint2(:,2) = by(:,i)+(results(:,2)*ci2);
confidencey(:,:,i)=bint;
confidencey2(:,:,i)=bint2;

clear xx
end
confidencey=reshape(confidencey,2*nn,hor);
confidencey2=reshape(confidencey2,2*nn,hor);


figure(2)
subplot(1,2,1)
plot(0:1:hor-1, by(rpos,:),'k', 'LineWidth',1.5);
hold on
plot(0:1:hor-1, confidencey2(rpos,:),'k--', 0:1:hor-1, confidencey2(rpos+nn,:),'k--');
hold on
plot(0:1:hor-1, confidencey(rpos,:),'k-.', 0:1:hor-1, confidencey(rpos+nn,:),'k-.');
hold on
plot(0:1:hor-1, zz, 'k:','LineWidth', 0.25)
title('Inv - ZLB')
ylim([-3 7])
xlabel('Years')
subplot(1,2,2)
plot(0:1:hor-1, by(rpos+1,:),'r', 'LineWidth',1.5);
hold on
plot(0:1:hor-1, confidencey2(rpos+1,:),'r--', 0:1:hor-1, confidencey2(rpos+1+nn,:),'r--');
hold on
plot(0:1:hor-1, confidencey(rpos+1,:),'r-.', 0:1:hor-1, confidencey(rpos+1+nn,:),'r-.');
hold on
plot(0:1:hor-1, zz, 'k:','LineWidth', 0.25)
title('Inv - No ZLB')
ylim([-3 7])
xlabel('Years')


Inv_ZLB=[by(rpos,:)' confidencey(rpos,:)' confidencey(rpos+nn,:)'];
Inv_NoZLB=[by(rpos+1,:)' confidencey(rpos+1,:)' confidencey(rpos+1+nn,:)'];
dlmwrite('Inv_Mil_ZLB.txt',Inv_ZLB);
dlmwrite('Inv_Mil_NoZLB.txt', Inv_NoZLB);