clear;clc;close all;

Irfs_Investment_MilitarySpending
Irfs_Investment_BP
Irfs_EmpRatio_MilitarySpending
Irfs_EmpRatio_BP
Irfs_Inflation_MilitarySpending
Irfs_Inflation_BP
Irfs_NominalRate_MilitarySpending
Irfs_NominalRate_BP
Irfs_Taxes_MilitarySpending
Irfs_Taxes_BP
Irfs_Deficit_MilitarySpending
Irfs_Deficit_BP


inv_zlb = dlmread('Inv_Mil_ZLB.txt');
inv = dlmread('Inv_Mil_NoZLB.txt');
inv_bp_zlb = dlmread('Inv_BP_ZLB.txt');
inv_bp = dlmread('Inv_BP_NoZLB.txt');
e_zlb = dlmread('E_Mil_ZLB.txt');
e = dlmread('E_Mil_NoZLB.txt');
e_bp_zlb = dlmread('E_BP_ZLB.txt');
e_bp = dlmread('E_BP_NoZLB.txt');
p_zlb = dlmread('P_Mil_ZLB.txt');
p = dlmread('P_Mil_NoZLB.txt');
p_bp_zlb = dlmread('P_BP_ZLB.txt');
p_bp = dlmread('P_BP_NoZLB.txt');
r_zlb = dlmread('R_Mil_ZLB.txt');
r = dlmread('R_Mil_NoZLB.txt');
r_bp_zlb = dlmread('R_BP_ZLB.txt');
r_bp = dlmread('R_BP_NoZLB.txt');
t_zlb = dlmread('T_Mil_ZLB.txt');
t = dlmread('T_Mil_NoZLB.txt');
t_bp_zlb = dlmread('T_BP_ZLB.txt');
t_bp = dlmread('T_BP_NoZLB.txt');
d_zlb = dlmread('Deficit_Mil_ZLB.txt');
d = dlmread('Deficit_Mil_NoZLB.txt');
d_bp_zlb = dlmread('Deficit_BP_ZLB.txt');
d_bp = dlmread('Deficit_BP_NoZLB.txt');

hor=4;
zz=zeros(1,hor+1);


set(0,'DefaultAxesFontName','Times');
set(0,'DefaultAxesFontSize',10);


figure(1)
subplot(6,2,1)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [inv_zlb(:,2)', fliplr(inv_zlb(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
hold on
plot(0:1:hor, inv_zlb(:,1),'k--', 'LineWidth', 1.5)
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, inv_bp_zlb(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, inv_bp_zlb(:,2), 'r--')
hold on
plot(0:1:hor, inv_bp_zlb(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -3.5 5.5]);
ylabel('Investment','FontSize',10,...
       'FontWeight','bold','Color','k')
title('ZLB')   
subplot(6,2,2)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [inv(:,2)', fliplr(inv(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, inv(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, inv_bp(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, inv_bp(:,2), 'r--')
hold on
plot(0:1:hor, inv_bp(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -3.5 5.5]);
title('Outside ZLB')
subplot(6,2,3)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [e_zlb(:,2)', fliplr(e_zlb(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, e_zlb(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, e_bp_zlb(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, e_bp_zlb(:,2), 'r--')
hold on
plot(0:1:hor, e_bp_zlb(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -0.35 2]);
ylabel('Emp. Ratio','FontSize',10,...
       'FontWeight','bold','Color','k')
subplot(6,2,4)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [e(:,2)', fliplr(e(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
l1=plot(0:1:hor, e(:,1),'k--', 'LineWidth', 1.5);
hold on
l2=plot(0:1:hor, e_bp(:,1),'r-o', 'LineWidth', 1.5);
hold on
plot(0:1:hor, e_bp(:,2), 'r--')
hold on
plot(0:1:hor, e_bp(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -0.35 2]);
subplot(6,2,5)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [p_zlb(:,2)', fliplr(p_zlb(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, p_zlb(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, p_bp_zlb(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, p_bp_zlb(:,2), 'r--')
hold on
plot(0:1:hor, p_bp_zlb(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -0.3 0.8]);
ylabel('Inflation','FontSize',10,...
       'FontWeight','bold','Color','k')
subplot(6,2,6)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [p(:,2)', fliplr(p(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, p(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, p_bp(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, p_bp(:,2), 'r--')
hold on
plot(0:1:hor, p_bp(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -0.3 0.8]);
subplot(6,2,7)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [r_zlb(:,2)', fliplr(r_zlb(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, r_zlb(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, r_bp_zlb(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, r_bp_zlb(:,2), 'r--')
hold on
plot(0:1:hor, r_bp_zlb(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -0.75 0.75]);
ylabel('Nominal Interest Rate','FontSize',10,...
       'FontWeight','bold','Color','k')
subplot(6,2,8)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [r(:,2)', fliplr(r(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, r(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
plot(0:1:hor, r_bp(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, r_bp(:,2), 'r--')
hold on
plot(0:1:hor, r_bp(:,3), 'r--')
axis([0 hor -0.75 0.75]);
subplot(6,2,9)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [t_zlb(:,2)', fliplr(t_zlb(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, t_zlb(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, t_bp_zlb(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, t_bp_zlb(:,2), 'r--')
hold on
plot(0:1:hor, t_bp_zlb(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -2 5.5]);
ylabel('Taxes','FontSize',10,...
       'FontWeight','bold','Color','k')
subplot(6,2,10)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [t_zlb(:,2)', fliplr(t(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, t(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, t_bp(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, t_bp(:,2), 'r--')
hold on
plot(0:1:hor, t_bp(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -2 5.5]);
subplot(6,2,11)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [d_zlb(:,2)', fliplr(d_zlb(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, d_zlb(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, d_bp_zlb(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, d_bp_zlb(:,2), 'r--')
hold on
plot(0:1:hor, d_bp_zlb(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -1 3.5]);
ylabel('Deficit','FontSize',10,...
       'FontWeight','bold','Color','k')
subplot(6,2,12)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [d(:,2)', fliplr(d(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
l1=plot(0:1:hor, d(:,1),'k--', 'LineWidth', 1.5);
hold on
l2=plot(0:1:hor, d_bp(:,1),'r-o', 'LineWidth', 1.5);
hold on
plot(0:1:hor, d_bp(:,2), 'r--')
hold on
plot(0:1:hor, d_bp(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -1 3.5]);
legend([l2 l1],'BP','Military Spending')
legend boxoff     
