% JOINTL1.M

function [bayes,credibleset,index]=jointL1(IRF)

M=size(IRF,1);
absolute_loss = zeros(M,1);
for i=1:M
   for j=1:M
       absolute_loss(i,1) = absolute_loss(i,1)+sum(abs(IRF(j,:)-IRF(i,:)));
   end
end
[~,IL1]=min(absolute_loss);
bayes = IRF(IL1,:);
[a,I] = sort(absolute_loss);
credibleset = IRF(I(1:ceil(0.68*M)),:);
index=I(1:ceil(0.68*M));