% FIGURE1C.M 

clear

% Load posterior draws
load posterior0_chol; 

% Shells for impulse responses of admissible structural models
IRF11=zeros(size(z,1),H+1); IRF21=zeros(size(z,1),H+1); IRF31=zeros(size(z,1),H+1); 

for j=1:size(z,1)
        
    A      = (reshape(z(j,1:(1+n*p)*n),1+n*p,n))';   % RF level parameters
    B0inv  = reshape(z(j,(1+n*p)*n+n*n+1:(1+n*p)*n+2*n*n),n,n);    
    irf=irfvar([A(:,2:p*n+1); eye((p-1)*n,(p-1)*n) zeros((p-1)*n,n)],B0inv,p,H);	                    
    IRF11(j,:)=cumsum(irf(1,:)); IRF21(j,:)=irf(2,:);   IRF31(j,:)=irf(3,:); 

end

% Stack posterior draws for impulse responses
IRF=[IRF11 IRF21 IRF31]; 

clear A B0inv irf;

% Bayes estimate of vector of inpulse responses for joint inference and 68% joint credible set
[irfmed,jcs,index]=jointmedian(IRF); clear IRF;    

IRF11med=irfmed(1,0*(H+1)+1:1*(H+1));
IRF21med=irfmed(1,1*(H+1)+1:2*(H+1));
IRF31med=irfmed(1,2*(H+1)+1:3*(H+1));

IRF11jcs=jcs(:,0*(H+1)+1:1*(H+1));
IRF21jcs=jcs(:,1*(H+1)+1:2*(H+1));
IRF31jcs=jcs(:,2*(H+1)+1:3*(H+1));

z=z(index,:);
save models_posterior0_chol index M z p n H t Ydep X;
clear M rep z p n t Ydep X index j jcs irfmed; 

IRF11med=IRF11med*100; IRF11jcs=IRF11jcs*100;

subplot(3,3,7); plot(0:1:H,IRF11jcs,'r-',0:1:H,IRF11med,'k-',0:1:H,zeros(1,H+1),'k-','linewidth',3); axis([0 H  -9 9])
ylabel('Nominal gas price','fontsize',15)
title('Nominal gasoline price shock','fontsize',15)
subplot(3,3,8); plot(0:1:H,IRF21jcs,'r-',0:1:H,IRF21med,'k-',0:1:H,zeros(1,H+1),'k-','linewidth',3); axis([0 H -0.1 0.25])
ylabel('Headline inflation','fontsize',15)
title('Nominal gasoline price shock','fontsize',15)
subplot(3,3,9); plot(0:1:H,IRF31jcs,'r-',0:1:H,IRF31med,'k-',0:1:H,zeros(1,H+1),'k-','linewidth',3); axis([0 H -0.1 0.5])
ylabel('Inflation expectation','fontsize',15)
title('Nominal gasoline price shock','fontsize',15)


