% CONSTRUCTDATA.M

clear;

% FRED CPI for all urban consumers, seasonally adjusted
load cpiaucsa68_1_20_4.txt; cpi=log(cpiaucsa68_1_20_4(120:end)); infl=(cpi(2:end)-cpi(1:end-1))*100;
cpi=cpi(2:end);

% Michigan Survey of Consumers
% Mean of 1yr inflation expectation 
% (Expected Change in Prices During the Next Year)
load inflexp1yr_78_01.txt;
inflexp1yrmean=inflexp1yr_78_01(:,end-6);

% EIA MER monthly gasoline price
load pgasunlead.txt; pgas=[0.665; pgasunlead]; pgas=pgasunlead(1:end); pgas=log(pgas); dpgas=dif(pgas);

% Data for VAR model
time=1978+1/12:1/12:2020+4/12;
y=[[NaN; dpgas] infl inflexp1yrmean];
y=y(43:end,:);
save data_chol time y;

