% TABLE1c.M

clear; 

% 1990.1-2020.4, monthly data

% Mean 1yr inflation expectation 
% (Expected Change in Prices During the Next Year)
load inflexp1yr_78_01.txt; inflexp1yrmean=inflexp1yr_78_01(:,end-6); inflexp=inflexp1yrmean(145:end); 

% WTI wpot price, EIA
load wti_78_01.txt; wti=wti_78_01; dwti=(log(wti(145:end))-log(wti(144:end-1))); wti=wti(145:end); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Original regression
t=length(wti);
y=inflexp;  
X=[ones(t,1) log(wti)];

CORR=corrcoef([inflexp log(wti)]);
[~,~,~,~,ehat,~,~,R2]=ols(y,X);
[~,~,~,~,ehat,~,~,R2]=ols(y,X);
M=andrews([X(:,1).*ehat X(:,2).*ehat]);
[betapoint,tstatpoint]=nwest(y,X,M);
[CORR(1,2)*100; R2; betapoint(2); tstatpoint(2)]
   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DGP: oil price
t=length(wti);
muoil=mean(dwti);
sigoil=std(dwti);

% DGP: Inflation expectation
[beta,~,~,~,ehat,sigma2,~,~]=ols(inflexp(2:end),[ones(t-1,1) inflexp(1:end-1)]);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Generate data
randn('seed',12324)
rand('seed',0)
nmc=100000;
for j=1:nmc
    
    %disp(j)
    
    o=cumsum(muoil+sigoil*trnd(4,t,1)/sqrt(2));    
    O=exp(o);
    
    y=ones(1,t)*NaN;
    pos=fix(rand(1,1)*t)+1;
	y(1,1)=inflexp(pos,1);
    for i=1:t-1
        y(1,i+1)=beta(1)+beta(2)*y(:,i)+sqrt(sigma2)'*randn(1,1);
    end;            
    y=y'; 
    yy=y;

    % Run regression and generate t-statistic
    XX=[ones(t,1) o];
    [~,~,~,~,eehat,~,~,~]=ols(yy,XX);
    M=andrews([XX(:,1).*eehat XX(:,2).*eehat]);
    [~,tstat]=nwest(yy,XX,M);
    tstatvec(j,1)=tstat(2);

end;

% P-value
disp('p-value')
mean(tstatvec>tstatpoint(2))
