% HWTEST.M

function [wald,B,U,k,SIGMA]=hwtest(y)

[t,q]=size(y);
z=y(:,1)-y(:,2);
t=t-1;
z_1  =z(1:t,:); 
ydiff=y(2:t+1,:)-y(1:t,:); 
Y_1=y(1:t,:);

%k=aicvec1(y);
k=sicvec1(y);

% Define the Y and X for EGLS

if k==0
        X=[ones(t-k,1) z_1(k+1:t,:)];
elseif k==1
        X=[ones(t-k,1) z_1(k+1:t,:) ydiff(k:t-1,:)];
elseif k==2
        X=[ones(t-k,1) z_1(k+1:t,:) ydiff(k:t-1,:) ydiff(k-1:t-2,:)];
elseif k==3
        X=[ones(t-k,1) z_1(k+1:t,:) ydiff(k:t-1,:)   ydiff(k-1:t-2,:) ydiff(k-2:t-3,:)];
elseif k==4
        X=[ones(t-k,1) z_1(k+1:t,:) ydiff(k:t-1,:)   ydiff(k-1:t-2,:) ydiff(k-2:t-3,:) ydiff(k-3:t-4,:)];
elseif k==5
        X=[ones(t-k,1) z_1(k+1:t,:) ydiff(k:t-1,:)   ydiff(k-1:t-2,:) ydiff(k-2:t-3,:) ydiff(k-3:t-4,:) ydiff(k-4:t-5,:)];
elseif k==6
        X=[ones(t-k,1) z_1(k+1:t,:) ydiff(k:t-1,:)   ydiff(k-1:t-2,:) ydiff(k-2:t-3,:) ydiff(k-3:t-4,:) ydiff(k-4:t-5,:) ydiff(k-5:t-6,:)];
elseif k==7
        X=[ones(t-k,1) z_1(k+1:t,:) ydiff(k:t-1,:)   ydiff(k-1:t-2,:) ydiff(k-2:t-3,:) ydiff(k-3:t-4,:) ydiff(k-4:t-5,:) ydiff(k-5:t-6,:) ydiff(k-6:t-7,:)];
elseif k==8
        X=[ones(t-k,1) z_1(k+1:t,:) ydiff(k:t-1,:)   ydiff(k-1:t-2,:) ydiff(k-2:t-3,:) ydiff(k-3:t-4,:) ydiff(k-4:t-5,:) ydiff(k-5:t-6,:) ydiff(k-6:t-7,:) ydiff(k-7:t-8,:)];
else
        disp('Error: k must not exceed 8.')
	break
end;

% Make endogenous variable conformable with X matrix
Y = ydiff(k+1:t,:);       
Y_1 = Y_1(k+1:t,:);
	
[TT,v]=size(X);
B=(X'*X)\(X'*Y);        
SIGMA=(Y-X*B)'*(Y-X*B)/TT;
CORR=[SIGMA(1,1)/SIGMA(1,1)		     SIGMA(1,2)/sqrt(SIGMA(1,1)*SIGMA(2,2));
      SIGMA(1,2)/sqrt(SIGMA(1,1)*SIGMA(2,2)) SIGMA(2,2)/SIGMA(2,2)];

U=Y-X*B;

%y=cumsum(Y);
%yhat=X*B;
%yhat=cumsum(yhat);
%plot(y(:,2))
%hold
%plot(yhat(:,2))
%hold
%pause
%plot(y(:,1))
%hold
%plot(yhat(:,1))
%hold
%pause

a=[1 ; -1]; Z=X(:,[1 [] 3:v]); M=eye(TT,TT)-Z*inv(Z'*Z)*Z';
wald=vec(Y'*M*Y_1*a)'*kron(inv(a'*Y_1'*M*Y_1*a),inv(SIGMA))*vec(Y'*M*Y_1*a);

B=B'; U=U';
