% DGP.M

% Basic parameters 
c=1;    % Canada

load mark_s;load mark_f;s = mark_s(:,c); f = mark_f(:,c); y=[s f];
[U,A0,H,A1,A2,A3,A4,SIGMA]=restrict(y);
clear y s e U;

t=97; tthrow=500; T=t+tthrow; nmc=1000;rand('seed',12345); randn('seed',9867); 
final=zeros(6,5); size=zeros(6,5); sizer=size; ufuk=-999*ones(30,nmc);

for h=1:nmc
        epsi=zeros(2,T); 
	epsi(:,1:T)=chol(SIGMA)'*randn(2,T);

	dy=zeros(2,T);
	y=zeros(2,T);
	z=zeros(1,T);

	for i=4+1:T
	  dy(1:2,i)= A0 + H.*z(1,i-1) + A1*dy(:,i-1) + A2*dy(:,i-2) + A3*dy(:,i-3) + A4*dy(:,i-4) + epsi(:,i);
	  y=cumsum(dy')';
	  z(1,i)  = y(1,i)-y(2,i);
	end;
	y=y';
	y=y(tthrow+1:T,:);

% Point estimate of LH regression
	[Ur,A0r,Hr,A1r,A2r,A3r,A4r]=restrict(y);
	[cv,cvj]=point(y);

% Bootstrap under H(0)
	[finalr]=boot(Ur,A0r,Hr,A1r,A2r,A3r,A4r,cv,cvj);
	for rr=1:6
	 for cc=1:5
	   if finalr(rr,cc) < 0.1
		sizer(rr,cc)=1;
	   else
		sizer(rr,cc)=0;	
	   end;
	 end;
	end;

        ufuk(:,h)=vec(sizer);
	final=(final+finalr);
	size=(size+sizer);

        save result final size h nmc ufuk;
		
end;

