% ACVS.M
% IT RETURNS VECTOR OF THE SAMPLE AUTOCOVARIANCE OF A TIME SERIES.
% INPUT:  X= (t,1) TIME SERIES (COLUMN VECTOR);
%         TAU= MAXIMUM ORDER OF AUTOCOVARIANCE;
% OUTPUT: VECG= (1+tau,1) VECTOR OF SAMPLE AUTOCOVARIANCE.
%
% Note:   biased estimate is computed, i.e., divisor is T not T-1. This
%         estimator warranties positive semidefiniteness of an asy-var
%         estimator based on this procedure.

function vecg=acvs(dt,tau)
     d    = dt-mean(dt);
     t    = size(d,1);
     vecg = d'*d/t;
     tt   = 1;
     while tt <= tau;
            vecg  = [vecg ; d(1:t-tt)'*d(1+tt:t)/t];
     tt   = tt + 1;
     end;

