% EGLS.M
% Lutz Kilian
% University of Michigan
% January 1997
%
% This program calculates the EGLS estimate for the Mark model restricted under
% the null of no predictability and cointegration.  Reference: Lutekepohl (1991),
% secton 5.2

function [B,SIGMA,np]=egls(Y,X,k)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Luetkepohl (1991), pp. 168:  Let beta=R*gamma+r such that no coefficient is 
% unrestricted in equation 1 and all coefficients are unrestricted in equation 2

[q,t]=size(Y);
[v,t]=size(X);
R=[zeros(1,v); [1 zeros(1,v-1)]];
for i=0:q*k
	R=[R; [zeros(1,v); [zeros(1,1+i) 1 zeros(1,v-2-i)]]];
end;

r=zeros(2*v,1);
y=vec(Y);
x=y-kron(X',eye(q,q))*r;

% Estimate SIGMA by restriced LS as recommended on pp. 171/172 in Luetkepohl (1991)
gammar=inv(R'*kron(X*X',eye(q))*R)*R'*kron(X,eye(q))*x;
betar=R*gammar+r;
Br=reshape(betar,q,v);
SIGMAr=(Y-Br*X)*(Y-Br*X)'/t;

% Estimate restricted parameter vector
gamma=inv(R'*kron(X*X',inv(SIGMAr))*R)*R'*kron(X,inv(SIGMAr))*x;
np=length(gamma);

% Estimate full parameter vector
beta=R*gamma+r;
B=reshape(beta,q,v);
SIGMA=(Y-B*X)*(Y-B*X)'/t;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if B(2,2)<=0
%	disp('Inequality constraint binding')

R=[zeros(1,v-1); [1  zeros(1,v-2)]; zeros(2,v-1)];
if k>0
	for i=1:q*k
		R=[R; [zeros(1,v-1); [zeros(1,i) 1 zeros(1,v-2-i)] ]];
	end;
end;

r=zeros(2*v,1);
r(4,1)=0.000000001;

y=vec(Y);
x=y-kron(X',eye(q,q))*r;

% Estimate SIGMA by restriced LS as recommended on pp. 171/172 in Luetkepohl (1991)
gammar=inv(R'*kron(X*X',eye(q))*R)*R'*kron(X,eye(q))*x;
betar=R*gammar+r;
Br=reshape(betar,q,v);
SIGMAr=(Y-Br*X)*(Y-Br*X)'/t;

% Estimate restricted parameter vector
gamma=inv(R'*kron(X*X',inv(SIGMAr))*R)*R'*kron(X,inv(SIGMAr))*x;
beta=R*gamma+r;
B=reshape(beta,q,v);
SIGMA=(Y-B*X)*(Y-B*X)'/t;

end;
