% COUNTRY.M

% Basic parameters 
c=4; % Switzerland

%load mark_s;load mark_f;		% 1973-1997
 load old_s;load old_f; 		% 1973-1991

s = mark_s(:,c); f = mark_f(:,c); y=[s f]; [T,q]=size(y);
rand('seed',12345); randn('seed',9867)


% Point estimate of LH regression
[U,A0,H,A1,A2,A3,A4]=restrict(y);
[A0 H A1 A2 A3]

% Checking the dominant root of the implied process for z(t):
%   AA=[1-H(1)-H(2)+A1(2,2)  -A1(2,2); 1 0];										% k<=1 augmented terms
%   AA=[1-H(1)-H(2)+A1(2,2)  -A1(2,2)+A2(2,2)  -A2(2,2); 1 0 0; 0 1 0]; % k<=2
   AA=[1-H(1)-H(2)+A1(2,2)  -A1(2,2)+A2(2,2)  -A2(2,2)+A3(2,2)  -A3(2,2); ...
         1 0 0 0; 0 1 0 0; 0 0 1 0];   											% k<=3
   max(abs(eig(AA)))
   
% Point estimate
[cv,cvj]=point(y);

% Bootstrap under H(0)
[final]=boot(U,A0,H,A1,A2,A3,A4,cv,cvj,T)
	
