% DIFVAR.M
%
% This program selects the lag order for a VAR with drift in first differences

function [B,SIGMA,U,k]=difvar(y)

[t,q]=size(y);
t=t-1;
ydiff=y(2:t+1,:)-y(1:t,:);

	%k=aicvar(y);
	k=sicvar(y);

	if k==0
                X=[ones(t-k,1)]';
	elseif k==1
                X=[ones(t-k,1) ydiff(k:t-1,:)]';  
	elseif k==2
                X=[ones(t-k,1) ydiff(k:t-1,:) ydiff(k-1:t-2,:)]';
	elseif k==3
                X=[ones(t-k,1) ydiff(k:t-1,:) ydiff(k-1:t-2,:) ydiff(k-2:t-3,:)]';
	elseif k==4
                X=[ones(t-k,1) ydiff(k:t-1,:) ydiff(k-1:t-2,:) ydiff(k-2:t-3,:) ydiff(k-3:t-4,:)]';
	elseif k==5
                X=[ones(t-k,1) ydiff(k:t-1,:) ydiff(k-1:t-2,:) ydiff(k-2:t-3,:) ydiff(k-3:t-4,:) ydiff(k-4:t-5,:)]';
	elseif k==6
                X=[ones(t-k,1) ydiff(k:t-1,:) ydiff(k-1:t-2,:) ydiff(k-2:t-3,:) ydiff(k-3:t-4,:) ydiff(k-4:t-5,:) ydiff(k-5:t-6,:)]';
	elseif k==7
                X=[ones(t-k,1) ydiff(k:t-1,:) ydiff(k-1:t-2,:) ydiff(k-2:t-3,:) ydiff(k-3:t-4,:) ydiff(k-4:t-5,:) ydiff(k-5:t-6,:) ydiff(k-6:t-7,:)]';
	elseif k==8
                X=[ones(t-k,1) ydiff(k:t-1,:) ydiff(k-1:t-2,:) ydiff(k-2:t-3,:) ydiff(k-3:t-4,:) ydiff(k-4:t-5,:) ydiff(k-5:t-6,:) ydiff(k-6:t-7,:) ydiff(k-7:t-8,:)]';
	else
		disp('Error: k must not exceed 8.')
		break
	end;

	% Make endogenous variable conformable with X matrix
        Y = ydiff(k+1:t,:)';   
	[K,T]=size(X);

	B=Y*X'*inv(X*X');        
	SIGMA=(Y-B*X)*(Y-B*X)'/T;
	U=Y-B*X;
