function [cv,cvj]=point(y)

 e=y(:,1); f=y(:,2); z=f-e;  % Data
 k=[1;4;8;12;16]; 	     % prediction horizons, in qts. 


 ik    =  1; 
 while ik <= length(k)

      %CREATE VARIABLES OF SUITABLE DIMENSIONS%

      %e(t+k) - e(t), sample-k obs.s
       ey    =  (trimr(e,k(ik),0)  - trimr(e,0,k(ik)))/k(ik);
       nk    =  size(ey,1);

      %f(t) - e(t), sample-k obs.s
       zxk   =  trimr(z,0,k(ik));
       zx    =  [ones(nk,1) zxk];

% IN-SAMPLE: START ESTIMATION OF LONG HORIZON REGRESSIONS%

       izxzx =  inv(zx'*zx);                   % inv. of design matrix 
       bk    =  izxzx*zx'*ey;                  % OLS alpha and beta 
       uk    =  ey - zx*bk;                    % estimated residuals 
       s2uk  =  uk'*uk/(nk-2);                 % residuals variance 

%      %GENERATE R-SQ. AND T_STATS%
%       r2k   =  1-(uk'*uk)/(detrend(ey,0)'*detrend(ey,0));       % R-sq. 

%      %OLS t-stats
%       tk_ls =  bk./sqrt(diag(izxzx*s2uk));

      %asy t-stats (Newey-West, Bartlett window, truncation lag=20)
       eta=[zx(:,1).*uk zx(:,2).*uk];	
       tk_20 =  bk./sqrt(diag(izxzx*s0(eta,20)*izxzx*nk));

      %asy t-stats (Newey-West, Bartlett window, Andrews automatic truncation-lag rule
       tk_a  =  bk./sqrt(diag(izxzx*s0(eta,andrews(eta))*izxzx*nk));

%OUT-OF-SAMPLE: GENERATE RW AND REGRESSION-BASED FORECASTS AND PREDICTION ERRORS
       nn00  =  (1:1:32-k(ik))';
       nnkk  =  (32+1:1:nk)';  

      %Regression prediction errors: ey(t0+k)-eyf(t0+k), where eyf(t+k)
      %is the predicted value of a regression using data up to period t0
       izz_j0 =  inv(zx(nn00,:)'*zx(nn00,:));
       pek_rg =  -9*ones(size(nnkk,1),1);

      %Recursive estimation is carried out using updating formulae of
      %PcGive (see manual p.267)
       in0k   =  32-k(ik);
       jk     =  in0k+1; 
       while jk <= nk-k(ik);
          lzz_j  =  izz_j0 * zx(jk,:)';
          izz_j  =  izz_j0 - ( lzz_j*lzz_j' / (1+lzz_j'*zx(jk,:)') );
          bk_j   =  izz_j * zx(1:jk,:)'*ey(1:jk);
          pek_rg(jk-in0k) =  ey(jk+k(ik))-(zx(jk+k(ik),:)*bk_j);
          izz_j0 =  izz_j;
        jk    =  jk + 1;
       end;

       pek2rg = pek_rg.*pek_rg;               % squared rg pred errors %

       pek_rw = ey(nnkk,1);			
       pek2rw = pek_rw.*pek_rw;               % squared rw pred errors %

      %GENERATE U-STATS AND DIEBOLD-MARIANO STATS
       spek2rw=  sum(pek2rw);
       spek2rg=  sum(pek2rg);
       ustatk =  sqrt(spek2rg/spek2rw);

       dmk_20 =  dm0(pek_rw,pek_rg,20);
       dmk_a  =  dm0(pek_rw,pek_rg,andrews(pek2rw-pek2rg));

      %STORE MONTE CARLO PATHS
%      b(ik,1)    = bk(2);
%      t_ls(ik,1) = tk_ls(2);
       t_20(ik,1) = tk_20(2);
       t_a(ik,1)  = tk_a(2);
%      r2(ik,1)   = r2k;
       ustat(ik,1)= ustatk;
       dm_20(ik,1)= dmk_20;
       dm_a(ik,1) = dmk_a;

ik=ik+1;
end;

% Test statistics from actual LH regressions for k=1,4,8,12,16      
cv=[t_20 t_a ustat dm_20 dm_a];         

% Joint test statistics      
cvj=[max(t_20) max(t_a) min(ustat) max(dm_20) max(dm_a)];
