% BOOT.M
% Bootstrap critical values for long-horizon regression.

function [final,mom,prct]=boot(U,A0,B0,B1,B2,B3,B4,B5,B6,B7,cv,cvj,sample)

%rand('seed',2029651105);     % random seed
 rand('seed',0)
 mcrep  = 2000;               % no. of MC replications 


 T=1000+sample;		      % lenght of initial MC draw 
 tbeg   = T - sample +1;      % initial observation
 tend   = tbeg+sample-1;      % last observation 
 k      = [1;4;8;12;16];      % prediction horizons, in qts. 
 rowsk  = length(k);

%MONTE CARLO MATRIX INITIALIZATION
 b      = -9*ones(mcrep,rowsk); % initialize matrix of MC betas 
 t_ls   = b;			% initialize matrix of MC t_ls 
 t_20   = b;                    % initialize matrix of MC t_20 
 t_a    = b;                    % initialize matrix of MC t_a 
%r2     = b;                    % initialize matrix of MC r2 
 ustat  = b;                    % initialize matrix of MC ustat 
 dm_20  = b;                    % initialize matrix of MC dm_20 
 dm_a   = b;                    % initialize matrix of MC dm_a 

uhat=[U U U U U U U U U U U U U U U U];

%BEGINNING OF MONTE CARLO REPLICATIONS
rep    =  1; 
while rep <= mcrep;
rep
	%GENERATE DATA
	u=zeros(2,T);
	uindex=rand(T-7,1);
	uindex=floor(uindex.*(T-7))+1;
	u(1:2,7+1:T)=uhat(1:2,uindex);

	de=zeros(1,T);
	e=zeros(1,T);
	z=zeros(1,T);

	i=7+1;
	while i <= T;
	  de(1,i)= A0 + u(1,i); 
	  z(1,i) = B0 + B1*z(1,i-1) + B2*z(1,i-2) + B3*z(1,i-3) + ...
		        B4*z(1,i-4) + B5*z(1,i-5) + B6*z(1,i-6) + B7*z(1,i-7) + u(2,i); 
	  i=i+1;
	end;
   e=cumsum(de');
	z=z';
	e=e(tbeg:tend,1);
	z=z(tbeg:tend,1);

      ik    =  1; 
      while ik <= length(k)

      %CREATE VARIABLES OF SUITABLE DIMENSIONS%

      %e(t+k) - e(t), sample-k obs.s
       ey    =  (trimr(e,k(ik),0)  - trimr(e,0,k(ik)))/k(ik);
       nk    =  size(ey,1);

      %f(t) - e(t), sample-k obs.s
       zxk   =  trimr(z,0,k(ik));
       zx    =  [ones(nk,1) zxk];

% IN-SAMPLE: START ESTIMATION OF LONG HORIZON REGRESSIONS%

       izxzx =  inv(zx'*zx);                   % inv. of design matrix 
       bk    =  izxzx*zx'*ey;                  % OLS alpha and beta 
       uk    =  ey - zx*bk;                    % estimated residuals 
       s2uk  =  uk'*uk/(nk-2);                 % residuals variance 

%      %GENERATE R-SQ. AND T_STATS%
%       r2k   =  1-(uk'*uk)/(detrend(ey,0)'*detrend(ey,0));       % R-sq. 

%      %OLS t-stats
%       tk_ls =  bk./sqrt(diag(izxzx*s2uk));

      %asy t-stats (Newey-West, Bartlett window, truncation lag=20)
       eta=[zx(:,1).*uk zx(:,2).*uk];	
       tk_20 =  bk./sqrt(diag(izxzx*s0(eta,20)*izxzx*nk));

      %asy t-stats (Newey-West, Bartlett window, Andrews automatic truncation-lag rule
       tk_a  =  bk./sqrt(diag(izxzx*s0(eta,andrews(eta))*izxzx*nk));

%OUT-OF-SAMPLE: GENERATE RW AND REGRESSION-BASED FORECASTS AND PREDICTION ERRORS
       nn00  =  (1:1:32-k(ik))';
       nnkk  =  (32+1:1:nk)';  

      %Regression prediction errors: ey(t0+k)-eyf(t0+k), where eyf(t+k)
      %is the predicted value of a regression using data up to period t0
       izz_j0 =  inv(zx(nn00,:)'*zx(nn00,:));
       pek_rg =  -9*ones(size(nnkk,1),1);

      %Recursive estimation is carried out using updating formulae of
      %PcGive (see manual p.267)
       in0k   =  32-k(ik);
       jk     =  in0k+1; 
       while jk <= nk-k(ik);
          lzz_j  =  izz_j0 * zx(jk,:)';
          izz_j  =  izz_j0 - ( lzz_j*lzz_j' / (1+lzz_j'*zx(jk,:)') );
          bk_j   =  izz_j * zx(1:jk,:)'*ey(1:jk);
          pek_rg(jk-in0k) =  ey(jk+k(ik))-(zx(jk+k(ik),:)*bk_j);
          izz_j0 =  izz_j;
       jk    =  jk + 1;
       end;

       pek2rg = pek_rg.*pek_rg;               % squared rg pred errors %

       pek_rw = ey(nnkk,1);
       pek2rw = pek_rw.*pek_rw;               % squared rw pred errors %

      %GENERATE U-STATS AND DIEBOLD-MARIANO STATS
       spek2rw=  sum(pek2rw);
       spek2rg=  sum(pek2rg);
       ustatk =  sqrt(spek2rg/spek2rw);

       dmk_20 =  dm0(pek_rw,pek_rg,20);
       dmk_a  =  dm0(pek_rw,pek_rg,andrews(pek2rw-pek2rg));

      %STORE MONTE CARLO PATHS
%      b(rep,ik)    = bk(2);
%      t_ls(rep,ik) = tk_ls(2);
       t_20(rep,ik) = tk_20(2);
       t_a(rep,ik)  = tk_a(2);
%      r2(rep,ik)   = r2k;
       ustat(rep,ik)= ustatk;
       dm_20(rep,ik)= dmk_20;
       dm_a(rep,ik) = dmk_a;

    ik    =  ik +1;
    end;

 rep    =  rep + 1;
 end;

% Calculate maximum and minimum statistics for joint test
t_20j=max(t_20')';
t_aj=max(t_a')';
dm_20j=max(dm_20')';
dm_aj=max(dm_a')';
ustatj=min(ustat')';


	 x=[t_20 t_a ustat dm_20 dm_a];	% (mcrep x 5*length(k))

         mom  = [mean(x); std(x); skewness(x); kurtosis(x)]; 
         prct = prctile(x,[1 5 10 50 90 95 99]);

         % Compute empirical p-values 
	 cv=vec(cv);
	 pval=-99*ones(25,1);
	 xsort=sort(x);


	 for l=1:size(xsort,2)
		pval(l,1)=sum(xsort(:,l)>cv(l,1))/mcrep;
	 end;
 	 pval(11,1)=1-pval(11,1);
 	 pval(12,1)=1-pval(12,1);
 	 pval(13,1)=1-pval(13,1);
 	 pval(14,1)=1-pval(14,1);
 	 pval(15,1)=1-pval(15,1);

         % Compute empirical p-values for max-stats
	 xj=[t_20j t_aj ustatj dm_20j dm_aj];	% (mcrep x 5)

	 cvj=vec(cvj);
	 pvalj=-99*ones(1,5);
	 xsortj=sort(xj);

	 for l=1:5
		pvalj(1,l)=sum(xsortj(:,l)>cvj(l,1))/mcrep;
	 end;
	 pvalj(1,3)=1-pvalj(1,3);
	 
final=[reshape(pval,5,5); pvalj];



