% OLSVARC.M
% Lutz Kilian
% University of Pennsylvania
% September 1995
%
% This program estimates a VAR(p) with intercept by OLS. (q=1, p<=8)

function [sA0,sA1,sA2,sA3,sA4,sA5,sA6,sA7,sA8,SOMEGA,sephatmat,A]=olsvarc(y,sicorder);  

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[t,q]=size(y);
con=ones(t-sicorder,1);

syy = y(sicorder+1:t,:);	

% Setting the RHS predetermined variables for each j

if sicorder == 0
	sxx = [con];
elseif sicorder == 1
	sxx = [con y(sicorder:t-1,:)];	
elseif sicorder == 2
	sxx = [con y(sicorder:t-1,:) y(sicorder-1:t-2,:)];
elseif sicorder == 3
	sxx = [con y(sicorder:t-1,:) y(sicorder-1:t-2,:) ...
		y(sicorder-2:t-3,:)];
elseif sicorder == 4
	sxx = [con y(sicorder:t-1,:) y(sicorder-1:t-2,:) ...
		y(sicorder-2:t-3,:) y(sicorder-3:t-4,:)];
elseif sicorder == 5
	sxx = [con y(sicorder:t-1,:) y(sicorder-1:t-2,:) ...
		y(sicorder-2:t-3,:) y(sicorder-3:t-4,:) y(sicorder-4:t-5,:)];
elseif sicorder == 6
	sxx = [con y(sicorder:t-1,:) y(sicorder-1:t-2,:) ...
		y(sicorder-2:t-3,:) y(sicorder-3:t-4,:) y(sicorder-4:t-5,:) ...
		y(sicorder-5:t-6,:)];
elseif sicorder == 7
	sxx = [con y(sicorder:t-1,:) y(sicorder-1:t-2,:) ...
		y(sicorder-2:t-3,:) y(sicorder-3:t-4,:) y(sicorder-4:t-5,:) ...
		y(sicorder-5:t-6,:) y(sicorder-6:t-7,:)];
elseif sicorder == 8
	sxx = [con y(sicorder:t-1,:) y(sicorder-1:t-2,:) ...
		y(sicorder-2:t-3,:) y(sicorder-3:t-4,:) y(sicorder-4:t-5,:) ...
		y(sicorder-5:t-6,:) y(sicorder-6:t-7,:) y(sicorder-7:t-8,:)];
end;   

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sbhat1=(sxx'*sxx)\(sxx'*syy(:,1));
sephat1=syy(:,1)-sxx*sbhat1;          

SOMEGA(1,1)=(sephat1'*sephat1)/(t-sicorder-q*sicorder-1);
sephatmat=[sephat1'];
sA0=sbhat1(1); 

if sicorder > 0
	sbhat1=sbhat1(2:1+sicorder*q);
	[sA1,sA2,sA3,sA4,sA5,sA6,sA7,sA8]=varcoef1(sicorder,sbhat1);  
	A=[sA1 sA2 sA3 sA4 sA5 sA6 sA7 sA8; eye(8-1,8-1) zeros(8-1,1)];
	max(abs(eig(A)))
	A=A(1:q*sicorder,1:q*sicorder);
else
	sA1=0; sA2=0; sA3=0; sA4=0; sA5=0; sA6=0; sA7=0; sA8=0; 
end;