% File: F0.G
% Procedure to compute 2*pi*F(0), where F(0) is the estimated spectral
%  density of a vector series at frequency zero, i.e., 2*pi*F(0) =
%  asy variance of vector series.
%  Note: Bartlett window is used, i.e., this estimator corresponds to
%        the Newey-West (1987) estimator of the long-run variance.
%
%        INPUT:  X(T,1)   vector of data.
%                m(1,1)   bandwidth parameter (from ANDREWS.g if Andrews
%                         (1991) plug-in bandwidth choice is to be
%                         implemented).
%
%        OUTPUT: F0(1,1)  inv(2*pi) * asyvar(x).
%
%  Reference: Hamilton (1994), pag. 281.


function s=f0(x,m)
     
       g     = acvs(x,m);
       g0    = g(1);
       gm    = g(2:m+1);
       w     = (1/(1+m):1/(1+m):m/(m+1))';
       bartw = 1-w;
       s     = g0 + bartw'*gm + bartw'*gm;

