% ASYBC.M
% Lutz Kilian
% University of Michigan
% April 1997
%
% Source: Pope (1990), JTSA

function [bcA1,bcA2,bcA3,bcA4,bcA5,bcA6,bcA7,bcA8]=asybc(A,SIGMA,t,p)

q=1; 
T=t-p;

SIGMA=[SIGMA 0  0  0  0  0  0  0 
         0    0  0  0  0  0  0  0
         0    0  0  0  0  0  0  0
         0    0  0  0  0  0  0  0
         0    0  0  0  0  0  0  0
         0    0  0  0  0  0  0  0
         0    0  0  0  0  0  0  0
         0    0  0  0  0  0  0  0];
SIGMA=SIGMA(1:q*p,1:q*p);

vecSIGMAY=inv(eye((q*p)^2)-kron(A,A))*vec(SIGMA);
SIGMAY=reshape(vecSIGMAY,q*p,q*p); clear vecSIGMAY;
I=eye(q*p,q*p);
B=A';

% There are q*p eigenvalues by construction
peigen=eig(A);
sumeig=zeros(q*p,q*p);
for h=1:q*p
	sumeig = sumeig + (peigen(h).*inv(I-peigen(h)*B));
end;

bias=SIGMA*(inv(I-B)+B*inv(I-B^2)+sumeig)*inv(SIGMAY);
Abias=-bias/T;
clear SIGMA SIGMAY bias B sumeig peigen I;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
bcstab=9;         % Arbitrary default value > 1
delta=1;          % Adjustment factor

if any(abs(eig(A-0.5*Abias))>=1)
%        disp('shortcut')
	delta=0.5;
end;

while bcstab >= 1

	% Adjust bias-correction proportionately
	bcA=A-delta*Abias;

	bcmod=abs(eig(bcA));
		if any(bcmod>=1)
			bcstab=1;
		else
			bcstab=0;
		end;
	delta=delta-0.01;
	
	if delta <= 0
		bcstab=0;
	end;
end;

max(abs(eig(bcA)))

clear Abias A;

if p==1
	bcA1=bcA(1:q,    1:1*q);
	bcA2=zeros(q,q);
	bcA3=zeros(q,q);
	bcA4=zeros(q,q);
	bcA5=zeros(q,q);
	bcA6=zeros(q,q);
	bcA7=zeros(q,q);
	bcA8=zeros(q,q);
	bcA9=zeros(q,q);
	bcA10=zeros(q,q);
	bcA11=zeros(q,q);
	bcA12=zeros(q,q);
elseif p==2
	bcA1=bcA(1:q,    1:1*q);
	bcA2=bcA(1:q,  q+1:2*q);
	bcA3=zeros(q,q);
	bcA4=zeros(q,q);
	bcA5=zeros(q,q);
	bcA6=zeros(q,q);
	bcA7=zeros(q,q);
	bcA8=zeros(q,q);
	bcA9=zeros(q,q);
	bcA10=zeros(q,q);
	bcA11=zeros(q,q);
	bcA12=zeros(q,q);
elseif p==3
	bcA1=bcA(1:q,    1:1*q);
	bcA2=bcA(1:q,  q+1:2*q);
	bcA3=bcA(1:q,2*q+1:3*q);
	bcA4=zeros(q,q);
	bcA5=zeros(q,q);
	bcA6=zeros(q,q);
	bcA7=zeros(q,q);
	bcA8=zeros(q,q);
	bcA9=zeros(q,q);
	bcA10=zeros(q,q);
	bcA11=zeros(q,q);
	bcA12=zeros(q,q);
elseif p==4
	bcA1=bcA(1:q,    1:1*q);
	bcA2=bcA(1:q,  q+1:2*q);
	bcA3=bcA(1:q,2*q+1:3*q);
	bcA4=bcA(1:q,3*q+1:4*q);
	bcA5=zeros(q,q);
	bcA6=zeros(q,q);
	bcA7=zeros(q,q);
	bcA8=zeros(q,q);
	bcA9=zeros(q,q);
	bcA10=zeros(q,q);
	bcA11=zeros(q,q);
	bcA12=zeros(q,q);
elseif p==5
	bcA1=bcA(1:q,    1:1*q);
	bcA2=bcA(1:q,  q+1:2*q);
	bcA3=bcA(1:q,2*q+1:3*q);
	bcA4=bcA(1:q,3*q+1:4*q);
	bcA5=bcA(1:q,4*q+1:5*q);
	bcA6=zeros(q,q);
	bcA7=zeros(q,q);
	bcA8=zeros(q,q);
	bcA9=zeros(q,q);
	bcA10=zeros(q,q);
	bcA11=zeros(q,q);
	bcA12=zeros(q,q);
elseif p==6
	bcA1=bcA(1:q,    1:1*q);
	bcA2=bcA(1:q,  q+1:2*q);
	bcA3=bcA(1:q,2*q+1:3*q);
	bcA4=bcA(1:q,3*q+1:4*q);
	bcA5=bcA(1:q,4*q+1:5*q);
	bcA6=bcA(1:q,5*q+1:6*q);
	bcA7=zeros(q,q);
	bcA8=zeros(q,q);
	bcA9=zeros(q,q);
	bcA10=zeros(q,q);
	bcA11=zeros(q,q);
	bcA12=zeros(q,q);
elseif p==7
	bcA1=bcA(1:q,    1:1*q);
	bcA2=bcA(1:q,  q+1:2*q);
	bcA3=bcA(1:q,2*q+1:3*q);
	bcA4=bcA(1:q,3*q+1:4*q);
	bcA5=bcA(1:q,4*q+1:5*q);
	bcA6=bcA(1:q,5*q+1:6*q);
	bcA7=bcA(1:q,6*q+1:7*q);
	bcA8=zeros(q,q);
	bcA9=zeros(q,q);
	bcA10=zeros(q,q);
	bcA11=zeros(q,q);
	bcA12=zeros(q,q);
elseif p==8
	bcA1=bcA(1:q,    1:1*q);
	bcA2=bcA(1:q,  q+1:2*q);
	bcA3=bcA(1:q,2*q+1:3*q);
	bcA4=bcA(1:q,3*q+1:4*q);
	bcA5=bcA(1:q,4*q+1:5*q);
	bcA6=bcA(1:q,5*q+1:6*q);
	bcA7=bcA(1:q,6*q+1:7*q);
	bcA8=bcA(1:q,7*q+1:8*q);
	bcA9=zeros(q,q);
	bcA10=zeros(q,q);
	bcA11=zeros(q,q);
	bcA12=zeros(q,q);
end;

