% IT RETURNS THE DIEBOLD-MARIANO STATISTICS.
% INPUTS: u1(n,1)     first series of forecast errors.
%                     (benchmark, typically rw prediction error).
%        u2(n,1)     second series of forecast errors
%        lagS0(1,1)  number of lags for computation of spectrum at zero.
%
% OUTPUT: DM-stat(1,1)
%
% NOTE:  The formula used is:
%
%                             DM = dbar / se_dbar
%        where, dbar is the mean of the difference of the squared
%        prediction errors, i.e.,
%            dbar = (1/n) SUM(t= 1 to n) (u1_t^2 - u2_t^2)
%        and se_dbar is the square root of the (HAC) variance of
%                the mean of (u1_t^2 - u2_t^2), i.e., of dbar.
%
%        A finding of DM >0 implies that model 2 (from which u2 is
%        computed) has better predictive power than model 1. However for
%        this result to be statistically significant, it is needed that
%        abs(DM) > 1.964 (5% normal critical value).
%
%        The computation of the HAC Var is performad using the f0
%        procedure.

function dm=dm0(u1,u2,lagS0)
  
       u1s = u1.*u1;
       u2s = u2.*u2;
       us  = u1s-u2s;
       dm=mean(us)/sqrt(f0(us,lagS0)/(size(us,1)-1));
