% JAEDATA.M
% Lutz Kilian
% University of Michigan
% June 1998
% 
% Program loads and transforms quarterly data for 1973.I-1997.IV for Mark model
% Project
 clear
 load cdex.txt;  load bdex.txt;  load jpex.txt;  load swex.txt; 
 load cdgnp.txt; load bdgnp.txt; load jpgnp.txt; load swgdp.txt; load usgnp.txt;
 load cdm3.txt;  load bdm1.txt;  load jpm1.txt;  load swm1.txt;  load usm1.txt;

% INTEREST RATE ELASTICITY 
  lambda = 1;
% NUMBER OF DATA POINTS LOADED 
  [t1]=length(cdex);
% DATA POINTS LOST AT BEG OF SAMPLE BECAUSE OF DESEASONALIZATION PROCEDURE
  t0     = 4;
% EFFECTIVE NUMBER OF OBSERVATIONS AVAILABLE AFTER DESEASONALIZATION 
  nobs   = t1-t0+1;

% Construct money (M1, except Can-M3), real income and spot rate (./$) 
 msus  = usm1;  mscd  = cdm3;  msgm  = bdm1;  msjy  = jpm1;  mssf  = swm1;
 yyus  = usgnp; yycd  = cdgnp; yygm  = bdgnp; yyjy  = jpgnp; yysf  = swgdp;
 sscd  = cdex;  ssgm  = bdex;  ssjy  = jpex;  sssf  = swex;

% Generate log ratio of domestic (US) and foreign SA moneys  
% Note: money series are summed over four periods to eliminate seasonal as in 
% Mark (1995) 
 mcd = log((msus(t0:t1,1)+msus(t0-1:t1-1,1)+msus(t0-2:t1-2,1)+msus(t0-3:t1-3,1))./ ...
	 (mscd(t0:t1,1)+mscd(t0-1:t1-1,1)+mscd(t0-2:t1-2,1)+mscd(t0-3:t1-3,1)));
 mgm = log((msus(t0:t1,1)+msus(t0-1:t1-1,1)+msus(t0-2:t1-2,1)+msus(t0-3:t1-3,1))./ ...
	 (msgm(t0:t1,1)+msgm(t0-1:t1-1,1)+msgm(t0-2:t1-2,1)+msgm(t0-3:t1-3,1)));
 mjy = log((msus(t0:t1,1)+msus(t0-1:t1-1,1)+msus(t0-2:t1-2,1)+msus(t0-3:t1-3,1))./ ...
	 (msjy(t0:t1,1)+msjy(t0-1:t1-1,1)+msjy(t0-2:t1-2,1)+msjy(t0-3:t1-3,1)));
 msf = log((msus(t0:t1,1)+msus(t0-1:t1-1,1)+msus(t0-2:t1-2,1)+msus(t0-3:t1-3,1))./ ...
	 (mssf(t0:t1,1)+mssf(t0-1:t1-1,1)+mssf(t0-2:t1-2,1)+mssf(t0-3:t1-3,1)));

% Generate log ratio of domestic (US) and foreign real incomes 
 ycd = log(yyus(t0:t1)./yycd(t0:t1));
 ygm = log(yyus(t0:t1)./yygm(t0:t1));
 yjy = log(yyus(t0:t1)./yyjy(t0:t1));
 ysf = log(yyus(t0:t1)./yysf(t0:t1));

% Generate log of spot rates (./$) 
 scd = log(sscd(t0:t1));
 sgm = log(ssgm(t0:t1));
 sjy = log(ssjy(t0:t1));
 ssf = log(sssf(t0:t1));

% Generate fundamentals, assuming lambda=1, as: (m - m*) - (y - y*) 
 fcd = mcd - ycd;
 fgm = mgm - ygm;
 fjy = mjy - yjy;
 fsf = msf - ysf;

% Save spot rates and fundamentals 
 mark_s = [scd sgm sjy ssf];
 mark_f = [fcd fgm fjy fsf];

 save mark_s mark_s;
 save mark_f mark_f;


