setwd("this should be set to the directory where the data are stored")

library(maptools)
library(spdep)
library(splm)
source("predictors.R")
source("kpt.panel.R")

data_cor <- read.csv("cornwell1.csv")
shape1<-readShapePoly("north_carol")
coord<-coordinates(shape1)

index <- data_cor[, 1]
tindex <- data_cor[, 2]
names(index) <- row.names(data_cor)
ind <- index[which(names(index) %in% row.names(data_cor))]
tind <- tindex[which(names(index) %in% row.names(data_cor))]
spord <- order(tind, ind)
data_cor <- data_cor[spord, ]
n <- length(unique(data_cor$county))
time <- length(unique(data_cor$year))
IN <- Diagonal(n)
Itime <- Diagonal(time)

knn<- knearneigh(coord, k = 10)
nbnc<-knn2nb(knn)
nc_listw<-nb2listw(nbnc)
pol <- poly2nb(shape1)
nc_listw2<-nb2listw(pol)

# under the null there is the queen
Wa <- Matrix(listw2mat(nc_listw2))
Wb <- Matrix(listw2mat(nc_listw))
IWa <- kronecker(Itime, Wa)
IWb <- kronecker(Itime, Wb)


xtot <- cbind(data_cor$lpolpc ,data_cor$lprbarr, data_cor$lprbconv, data_cor$lprbpris, data_cor$lavgsen, data_cor$ldensity, data_cor$lwcon, data_cor$lwtuc, data_cor$lwtrd, data_cor$lwfir, data_cor$lwser, data_cor$lwmfg, data_cor$lwfed, data_cor$lwsta, data_cor$lwloc, data_cor$lpctymle,  data_cor$d82, data_cor$d83, data_cor$d84, data_cor$d85, data_cor$d86, data_cor$d87)

indic <- rep(1:n,time)

Xwithin <- splm:::panel.transformations(xtot,indic, type= "within")
WAXwithin <- IWa %*% Xwithin[,-((ncol(xtot)-5):ncol(xtot))]
WWAXwithin <- IWa %*% WAXwithin
WBXwithin <- IWb %*% Xwithin[,-((ncol(xtot)-5):ncol(xtot))]
WWBXwithin <- IWb %*% WBXwithin
Ha <- cbind(as.matrix(Xwithin), as.matrix(WAXwithin), as.matrix(WBXwithin), as.matrix(WWAXwithin), as.matrix(WWBXwithin))


fm <- lcrmrte~  lprbconv+ lprbpris+ lavgsen+ ldensity+ lwcon+ lwtuc+ lwtrd+ lwfir+ lwser+ lwmfg+ lwfed+ lwsta+ lwloc+ lpctymle+lpctmin+  west+ central+ urban+ d82+ d83+ d84+ d85+ d86+ d87 

endog = ~ lpolpc +lprbarr 
instruments = ~ ltaxpc + lmix

# # # # Fixed With endogeneous 
sarar_H0 <-spgm(fm, data=data_cor, lag = TRUE, listw = Wb, endog = endog, instruments = instruments, spatial.error = TRUE, model = "within", optim.method = "nlminb", pars = c(0.2, 1) )
summary(sarar_H0)

sarar_H1 <-spgm(fm, data=data_cor, lag = TRUE, listw = Wa, endog = endog, instruments = instruments, spatial.error = T, model = "within", optim.method = "nlminb", pars = c(0, 0) )
summary(sarar_H1)

predictor <- predictors_mod(sarar_H0, sarar_H1, y = data_cor$lcrmrte, xreg = xtot, w0 = IWb, w1 = IWa, nobs = n, time = time, IN = IN, IT = Itime) 


test_p1 <- try(kptest(data_cor$lcrmrte, sarar_H0,  pred = predictor[,1], x0 = xtot, w0 = IWb,  instruments = Ha, nobs = n, time = time))
test_p2 <- try(kptest(data_cor$lcrmrte, sarar_H0, pred = predictor[,2], x0 = xtot, w0 = IWb,  instruments = Ha, nobs = n, time = time))
STAT <- qchisq(0.05,1,lower.tail=FALSE)