
% Produces a 2-step verison of Pesaran's (2006) estimator. That is, 
% rather than using cross-section averages as the proxies, it uses 
% principal component factors applied to CCE y-b*x residuals. 
% Otherwise, estimation is carried out in the same way

%order specifies the order of a unit-specic trend to be removed from data. order=0 specifies that no trend is removed

%S is a matrix that places each cross-section, i, unit into one of M groups
%(M<N) (i.e., grouping each county into a specific state). This is used for
%removeing group rather than unit trends. Set S=0 to if no grouping is
%necessary

function [betaCCEmg, seCCEmg, betaCCEp, seCCEp, betaCCEi, M, Mmg, varcovCCEmg, AvarbCCEp] = CCEfunction2step(X1,Y1,order,S, demean, mgfe, Fcce, Fccei); 
[T,N,p]=size(X1);


% remove state-specific trends
[Xdet,Ydet] = RemoveTimeTrends(X1,Y1,order,S);
% remove fixed effects
if demean==0
    Xdot=Xdet;
    Ydot=Ydet;
elseif demean==1
    [Xdot,Ydot]=CSDemean(Xdet,Ydet,1);
elseif demean==2
    [Xdot,Ydot]=TimeDemean(Xdet,Ydet,1);
elseif demean==3
    [Xdot,Ydot]=DemeanData(Xdet,Ydet);
end
if mgfe==1
    [Xmg,Ymg]=TimeDemean(Xdet,Ydet,1);
elseif mgfe==0
    Xmg=Xdet;
    Ymg=Ydet;
end
X=Xdot;
Y=Ydot;

% Estimation
%Create the H-bar matrix -a proxy for the factors- and the M-bar matrix from Pesaran (2006)
Hwmg=[Fccei];

Mmg=eye(T) - Hwmg*inv(Hwmg'*Hwmg)*Hwmg';

% Mean Group Estimator
% beta-CCEmg
betaCCEi=zeros(p,N);
for i=1:N
    Xi=zeros(T,p);
    for j=1:p
        Xi(:,j)=Xmg(:,i,j);
    end;
    Yi=Ymg(:,i);
    betaCCEi(:,i)=inv(Xi'*Mmg*Xi)*Xi'*Mmg*Yi;
end;
betaCCEmg=mean(betaCCEi,2);

% standard error-CCEmg
squaredCCEmg=zeros(p,p,N);
for i=1:N
    squaredCCEmg(:,:,i)=(betaCCEi(:,i)-betaCCEmg)*(betaCCEi(:,i)-betaCCEmg)';
end;
varcovCCEmg=(1/(N*(N-1)))*sum(squaredCCEmg,3);
seCCEmg=sqrt(diag(varcovCCEmg));


% Pooled Estimator
%Create the H-bar matrix -a proxy for the factors- and the M-bar matrix from Pesaran (2006)
Hw=[Fcce];

M=eye(T) - Hw*inv(Hw'*Hw)*Hw';

% beta - CCEp
XX=zeros(p,p,N);
XY=zeros(p,1,N);
for i=1:N
    Xi=zeros(T,p);
    for j=1:p
        Xi(:,j)=X(:,i,j);
    end;
    XX(:,:,i)=(1/N)*(Xi'*M*Xi);
end;
for i=1:N
    Xi=zeros(T,p);
    for j=1:p
        Xi(:,j)=X(:,i,j);
    end;
    Yi=Y(:,i);
    XY(:,:,i)=(1/N)*(Xi'*M*Yi);
end;
XXsum=sum(XX,3);
XYsum=sum(XY,3);
betaCCEp=inv(XXsum)*XYsum;

% standard error - CCEp
simats=zeros(p,p,N);
for i=1:N
    Xi=zeros(T,p);
    for j=1:p
        Xi(:,j)=X(:,i,j);
    end;
    simats(:,:,i)=(1/N)*((Xi'*M*Xi)/T);
end;
sihat=sum(simats,3);
Rmats=zeros(p,p,N);
for i=1:N
    Xi=zeros(T,p);
    for j=1:p
        Xi(:,j)=X(:,i,j);
    end;
    Rmats(:,:,i)=(((1/N)/sqrt(inv(N)*N*(1/N)^2))^2)*((Xi'*M*Xi)/T)*(betaCCEi(:,i)-betaCCEmg)*(betaCCEi(:,i)-betaCCEmg)'*((Xi'*M*Xi)/T);
end;
Rhat=(1/(N-1))*sum(Rmats,3);
AvarbCCEp=(N*((1/N)^2))*inv(sihat)*Rhat*inv(sihat);
seCCEp=sqrt(diag(AvarbCCEp));


betaCCEmg;
seCCEmg;

betaCCEp;
seCCEp;



