% This program produces the IFE, IFEMG, CCEP, CCEMG, CCEP-2, and CCEMG-2
% estimates in Table 4 (it also produces the OLS and OLSMG
% estimates, for comparision with the Stata results)


LASTN=maxNumCompThreads(12)
addpath('matlabprograms')
addpath('../mydata')
clear;
clc;


%% TABLE 4 PART A AND TABLE 5: FACTOR MODELS WITH PERSON FIXED EFFECTS

%LOAD DATA (exported from STATA into .xls files using p4)
%NOTE: if any variables are going to be excluded from the CCE cross-section, put those at the end. 
Y=xlsread('GSFlogearn_insampleBOTH2_1ch.xls')';
X1=xlsread('GSFeducyears2_insampleBOTH2_1ch.xls')';
X2=xlsread('GSFageq_insampleBOTH2_1ch.xls')'; 
X3=X2.^2; 
X4=X2.^4; 
S=0; %Can be a Nxm matrix to assign each person into one of m groups, m<N, in order to produce group-specific, rather than person-specific, trends. Not used in this paper
[T,N]=size(Y);


%SPECIFY MODEL SETTINGS
order=0; %Set the order of person/group-specific trend to be included in the model (via de-trending, before estimation) [always 0 in our paper]
k=4; %Number of regressors
kcsavg=2; %Number of cross-section averages for CCE -> number of independent variables + 1 (minus the number of age variables used as regressors if any, because age is a "d_t" variable in Pesaran paper, not an "x_it" variable)
demean=1; %Type of fixed effects to include in the model (seperate from interactive fixed effects); 0-no fixed effects, 1-time period fixed effects, 2-person fixed effects, 3-two-way fixed effects
mgfe=0; %removes person FE (i.e., person intercept) in individual-level regs


%PLACE REGRESSORS TOGETHER INTO SINGLE X MATRIX
X=zeros(T,N,k);
X(:,:,1)=X1;
X(:,:,2)=X2;
X(:,:,3)=X3;
X(:,:,4)=X4;


%ESTIMATION
%first, demean the variables for use later
[Xdet,Ydet]=RemoveTimeTrends(X,Y,order,S); %Remove unit-specific trends time trends (no trends if order=0)
[Xdott,Ydott]=CSDemean(Xdet,Ydet,1); %Demean along the cross section dimension, which removes time fixed effects
[Xdoti,Ydoti]=TimeDemean(Xdet,Ydet,1); %Demean along the time dimension, which removes individual fixed effects
[Xdot2,Ydot2]=DemeanData(Xdet,Ydet); %Demean in both directions, to remove person and time fixed effects

%OLS pooled
if demean==1
    Yolsp=Ydott;
    Xolsp=Xdott;
elseif demean==2
    Yolsp=Ydoti;
    Xolsp=Xdoti;
elseif demean==3
    Yolsp=Ydot2;
    Xolsp=Xdot2;
end
[betaOLSp]=Mul_panelbeta(Xolsp,Yolsp,eye(T));

%CCE (pooled and heterogeneous)
[betaCCEmg, seCCEmg, betaCCEp, seCCEp, betaCCEi,M, Mmg, varcovCCEp, varcovCCEmg] = CCEfunction(X,Y,order,S,demean,mgfe,kcsavg); %always send in non-demeaned data; any de-meaning handled inside

%CCE two-step (pooled and heterogeneous)
if demean==1
    Ycce2=Ydott;
    Xcce2=Xdott;
elseif demean==2
    Ycce2=Ydoti;
    Xcce2=Xdoti;
elseif demean==3
    Ycce2=Ydot2;
    Xcce2=Xdot2;
end
Uccep=Ycce2;
for p=1:k
    Uccep=Uccep-Xcce2(:,:,p)* betaCCEp(p,1);
end
[r2step,~,~,~]=nbplog(Uccep,10,1,0);
[Fcce2step,Lcce2step,VNTcce2step]=panelFactorNew(Uccep,r2step);

if mgfe==1
    Ycce2i=Ydoti;
    Xcce2i=Xdoti;
elseif mgfe==0
    Ycce2i=Ydet;
    Xcce2i=Xdet;
end
Uccei=Ycce2i;
for p=1:k
	for i=1:N
    		Uccei(:,i)=Uccei(:,i)-Xcce2i(:,i,p)* betaCCEi(p,i);
	end
end
[r2stepi,~,~,~]=nbplog(Uccei,10,1,0);
Uccei=Ycce2i;
for p=1:k
    Uccei=Uccei-Xcce2i(:,:,p)* betaCCEmg(p,1);
end
[Fcce2stepi,Lcce2stepi,VNTcce2stepi]=panelFactorNew(Uccei,r2stepi);

[betaCCEmg2step, seCCEmg2step, betaCCEp2step, seCCEp2step, betaCCEi2step, M2step, Mmg2step, varcovCCEmg2step, varcovCCEp2step] = CCEfunction2step(X,Y,order,S, demean, mgfe, Fcce2step, Fcce2stepi); %always send in non-demeaned data

%IFE (note, for full analysis, IFE is estimated for each of 1-10 factors, and then the final number is chosen in p6. The replication code only generates the estimates chosen in p6 for the paper, for the sake of run time)
%[betaIFE1, seIFE1, sigma21, SSR1, nnn1, r11, r21, betaIFE01, betaOLS1, F11, L11, F21, L21, VNT11, VNT21, varcovIFE1] = IFEfunction(X,Y,order,S,demean,1,1); %always send in non-demeaned data; any de-meaning handled inside
%[betaIFE2, seIFE2, sigma22, SSR2, nnn2, r12, r22, betaIFE02, betaOLS2, F12, L12, F22, L22, VNT12, VNT22, varcovIFE2] = IFEfunction(X,Y,order,S,demean,2,1);
%[betaIFE3, seIFE3, sigma23, SSR3, nnn3, r13, r23, betaIFE03, betaOLS3, F13, L13, F23, L23, VNT13, VNT23, varcovIFE3] = IFEfunction(X,Y,order,S,demean,3,1);
%[betaIFE4, seIFE4, sigma24, SSR4, nnn4, r14, r24, betaIFE04, betaOLS4, F14, L14, F24, L24, VNT14, VNT24, varcovIFE4] = IFEfunction(X,Y,order,S,demean,4,1);
%[betaIFE5, seIFE5, sigma25, SSR5, nnn5, r15, r25, betaIFE05, betaOLS5, F15, L15, F25, L25, VNT15, VNT25, varcovIFE5] = IFEfunction(X,Y,order,S,demean,5,1);
%[betaIFE6, seIFE6, sigma26, SSR6, nnn6, r16, r26, betaIFE06, betaOLS6, F16, L16, F26, L26, VTN16, VNT26, varcovIFE6] = IFEfunction(X,Y,order,S,demean,6,1);
[betaIFE7, seIFE7, sigma27, SSR7, nnn7, r17, r27, betaIFE07, betaOLS7, F17, L17, F27, L27, VNT17, VNT27, varcovIFE7] = IFEfunction(X,Y,order,S,demean,7,1);
%[betaIFE8, seIFE8, sigma28, SSR8, nnn8, r18, r28, betaIFE08, betaOLS8, F18, L18, F28, L28, VNT18, VNT28, varcovIFE8] = IFEfunction(X,Y,order,S,demean,8,1);
%[betaIFE9, seIFE9, sigma29, SSR9, nnn9, r19, r29, betaIFE09, betaOLS9, F19, L19, F29, L29, VNT19, VNT29, varcovIFE9] = IFEfunction(X,Y,order,S,demean,9,1);
%[betaIFE10, seIFE10, sigma210, SSR10, nnn10, r110, r210, betaIFE010, betaOLS10, F110, L110, F210, L210, VNT110, VNT210, varcovIFE10] = IFEfunction(X,Y,order,S,demean,10,1);

save('../mydata/results_saa2a4BOTH2_tFE1ch.mat')




