% Computes CD test statistics (Pesaran, 2015). The CD stats are calculated on the OLS
% and IV residuals from the panel IV/OLS table in the paper; these residuals were 
% computed in STATA and then exported for these tests.

clear
LASTN=maxNumCompThreads(12)
addpath('matlabprograms')
addpath('../mydata')

load('../mydata/results_ss2aa2BOTH2_tFE2ch.mat')


ResIV_ssaaFEt=xlsread('ResIV_ssaaFEt_panel_insampleBOTH2_2ch.xls')';
ResOLS_ssaaFEt=xlsread('ResOLS_ssaaFEt_panel_insampleBOTH2_2ch.xls')';

CSDstatResIV_ssaaFEt=CSDtestPesaran15(ResIV_ssaaFEt);
CSDstatResOLS_ssaaFEt=CSDtestPesaran15(ResOLS_ssaaFEt);


save('../mydata/results_ss2aa2BOTH2_tFE2ch.mat')

