function hess = numhess2010_2(FUN,b,GRAD,varargin,EstimOpt)

%only use grad so far

if isfield(EstimOpt,'BACTIVE') & sum(EstimOpt.BACTIVE)>0
    b0 = b(EstimOpt.BACTIVE==1);
else
    b0 = b;
end

abs_b0 = abs(b0);
sign_b0 = sign(b0);


% make a small positive change when around zeros
% sign doesn't matter
%sign_b0(sign_b0==0)=1;
%db = (1e-8)*max(abs_b0,1e-2).*sign_b0;
%db = (1e-5);

%matlab
db = (eps^.25)*sign_b0.*max(abs_b0,1);

b1 = b0 + db;
db = b1-b0; % K by 1

db_mtx = diag(db); % K by K zeros with db on diagonal
b0_mtx = repmat(b0,1,length(b0));

b1_mtx = b0_mtx + db_mtx; % K by K

%use gradients
Grad0 = repmat(feval(GRAD,b0),1,length(b0));

Grad1=zeros(size(Grad0));

%hess = zeros(length(b0), length(b0));

if isfield(EstimOpt,'USEPARALLEL')==0|EstimOpt.USEPARALLEL==0
    
    for j = 1:length(b0)
        Grad1(:,j) = feval(GRAD,b1_mtx(:,j));
    end
elseif EstimOpt.USEPARALLEL ==1
    matlabpool(8)
    parfor j = 1:length(b0)
        Grad1(:,j) = feval(GRAD,b1_mtx(:,j));
    end
    matlabpool close
    
end

db = repmat(db',size(Grad0,1),1);

hess = (Grad1-Grad0)./db;
hess=.5*(hess+hess');
