
addpath c:\gmx2n2008b
clear all

fnameinput = ('c:\gmnl2009b\gmnl_data1');
fnameout_lc2 = ('c:\gmx2n2008b\output\test_clogit');
fnameout_mm1 = ('c:\gmx2n2008b\output\test_mm1_diag');


% *****************  loading & specifying data ***************
load(fnameinput)
% the input is in a stacked format:(the format Stata and Limdep require to estimate conditional MNL.)

% Number of people
EstimOpt.NP = 120;
% Number of observations
EstimOpt.NOBS = 120*32;
% Number of alternatives
EstimOpt.NALT = 2;
% Number of attributes
EstimOpt.NVAR = 4;
TIMES = 32*ones(EstimOpt.NP,1);

Results_clogit = clogit(Y,X,[]);
strvcat('         est.    std.err.',num2str([[1:length(Results_clogit.bhat)]' Results_clogit.bhat Results_clogit.std],4))
strvcat('LL at convergence: ',num2str(Results_clogit.LL,4))
%save(fnameout_clogit(s,:), 'Results_clogit')

% note: G-MX2NL function requires data in different format.
% The following lines reshape Y and X into 3-dimension matrices.
% If number of scenarios (TIMES) differ across individuals,
% need some modification...

YVEC = reshape(Y',EstimOpt.NALT,TIMES(1),EstimOpt.NP);
XMAT = reshape(X',EstimOpt.NVAR, EstimOpt.NALT*TIMES(1),EstimOpt.NP);
ZMAT = ones(EstimOpt.NP,1);
clear Y X

% ****************** ModelOpt = LC for latent class model *************************
ModelOpt = 'LC';
EstimOpt.NZVAR = size(ZMAT,2);
EstimOpt.NCLASS = 2;
EstimOpt.CZVAR = 0;EstimOpt.BACTIVE = [];

% initial value:
% order of parameters: mean for class 1, mean for class 2,..., mean for class S,
%                      parameters of class membership
 
EstimOpt.b0 = [Results_clogit.bhat+.02;Results_clogit.bhat-.02;0];
EstimOpt.LBVAR = [-20*ones(1,length(EstimOpt.b0)-EstimOpt.NCLASS+1) -5*ones(1,EstimOpt.NCLASS-1)];
EstimOpt.UBVAR = [20*ones(1,length(EstimOpt.b0)-EstimOpt.NCLASS+1) 5*ones(1,EstimOpt.NCLASS-1)];

tic
Results_lc2 =  GMX2N_2008b(YVEC,XMAT,TIMES,EstimOpt,ModelOpt,ZMAT)
toc
strvcat('         est.    std.err.',num2str([[1:length(EstimOpt.b0)]' Results_lc2.bhat Results_lc2.std],4))

save(fnameout_lc2, 'Results_lc2')

% ****************** ModelOpt = MM-MNL: mixture of 2 independent normal *************************

ModelOpt = 'MX1';
EstimOpt.COVTYPE = 'diag';
EstimOpt.NCLASS = 2;
bhat_lc2= Results_lc2.bhat;
EstimOpt.NUMGRAD = 0; EstimOpt.DISPLAY = 0;
EstimOpt.b0 = [bhat_lc2(1:EstimOpt.NVAR);.1*ones(EstimOpt.NVAR,1);...
                     bhat_lc2(EstimOpt.NVAR+1:EstimOpt.NVAR*2);.1*ones(EstimOpt.NVAR,1);
                     bhat_lc2(length(bhat_lc2))];
                     
EstimOpt.CZVAR = 0;EstimOpt.BACTIVE = [];
EstimOpt.LBVAR = [-20*ones(1,length(EstimOpt.b0)-1) -5];
EstimOpt.UBVAR = [20*ones(1,length(EstimOpt.b0)-1) 5];

Results_mx2n_diag =  GMX2N_2008b(YVEC,XMAT,TIMES,EstimOpt,ModelOpt,ZMAT);

strvcat('         est.    std.err.',num2str([[1:length(EstimOpt.b0)]' Results_mx2n_diag.bhat Results_mx2n_diag.std],4))

save(fnameout_mm1, 'Results_mx2n_diag')


% ****************** ModelOpt = MM-MNL: mixture of 2 normal with proportional cov matrices ************************

% ModelOpt = 'MX2';
% EstimOpt.COVTYPE = 'fullcov';
% EstimOpt.NCLASS = 2;
% 
% EstimOpt.NUMGRAD = 1; EstimOpt.DISPLAY = 0;
% NCV =ncv(EstimOpt.NVAR);
%   EstimOpt.b0 = [bhat_lc2(1:EstimOpt.NVAR);...
%                      bhat_lc2(EstimOpt.NVAR+1:EstimOpt.NVAR*2);.1*ones(NCV,1);
%                      1;bhat_lc2(length(bhat_lc2))];
%           
% EstimOpt.CZVAR = 0;EstimOpt.BACTIVE = [];
% EstimOpt.LBVAR = [-30*ones(1,length(EstimOpt.b0)-1) -5];
% EstimOpt.UBVAR = [30*ones(1,length(EstimOpt.b0)-1) 5];
% 
% Results_mx2n_ppl =  GMX2N_2008b(YVEC,XMAT,TIMES,EstimOpt,ModelOpt,ZMAT)
% 
% save(fname_mx2n_ppl_a(1,:),'Results_mx2n_ppl', 'EstimOpt')


