function f = gmx2n_like7(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,b,ZMAT)


% ModelOpt
% LC:  b = [b11,b12,...b1k; b21,...,b2k; lamda1, lamda2]
% MX1: b = [b11,b12,...b1k; cv1; b21,...,b2k; cv2; lamda1, lamda2]
% MX2: b = [b11,b12,...b1k; b21,...,b2k; cv; sc; lamda1, lamda2]
% MX3: b = [b11,b12,...b1k; b21,...,b2k; cv1 or tau1 ; cv2 or tau2; lamda1, lamda2] ?

% EstimOpt.COVTYPE = diag, fullcv, factor (with number of factors)

NALT = EstimOpt.NALT;
bn = b;
btmp = zeros(EstimOpt.NVAR,EstimOpt.NCLASS);
NCV = ncv(EstimOpt.NVAR);

switch lower(ModelOpt)
    case 'lc'
        
        btmp = reshape(bn(1:EstimOpt.NVAR*EstimOpt.NCLASS),EstimOpt.NVAR,EstimOpt.NCLASS);
        mm = EstimOpt.NVAR*EstimOpt.NCLASS;
        
    case 'mx1'
        
        switch lower(EstimOpt.COVTYPE)
            case {'diag','uncorr'}
                tmp = reshape(bn(1:EstimOpt.NVAR*2*EstimOpt.NCLASS),EstimOpt.NVAR*2,EstimOpt.NCLASS);
                btmp = tmp(1:EstimOpt.NVAR,:); % EstimOpt.NVAR by EstimOpt.NCLASS
                for s = 1:EstimOpt.NCLASS
                    tmp2 = tmp(EstimOpt.NVAR+1:EstimOpt.NVAR*2,s);
                    
                    Ltmp(:,:,s) = xpnd([tmp2;zeros(NCV-EstimOpt.NVAR,1)],-1);
                end
                mm = (EstimOpt.NVAR*2)*EstimOpt.NCLASS;
                
            case 'fullcov'
                tmp = reshape(bn(1:(EstimOpt.NVAR+NCV)*EstimOpt.NCLASS),EstimOpt.NVAR+NCV,EstimOpt.NCLASS);
                btmp = tmp(1:EstimOpt.NVAR,:); % EstimOpt.NVAR by EstimOpt.NCLASS
                for s = 1:EstimOpt.NCLASS
                    tmp2 = tmp(EstimOpt.NVAR+1:EstimOpt.NVAR+NCV,s);
                    Ltmp(:,:,s) = xpnd(tmp2,-1);
                end
                mm = (EstimOpt.NVAR+NCV)*EstimOpt.NCLASS;
                
            case 'facload'
                
                [NCVFAC Nalp Nsig] = ncvfac(EstimOpt.NVAR,EstimOpt.NFAC,1);
                tmp = reshape(bn(1:(EstimOpt.NVAR+NCVFAC)*EstimOpt.NCLASS),EstimOpt.NVAR+NCVFAC,EstimOpt.NCLASS);
                btmp = tmp(1:EstimOpt.NVAR,:); % EstimOpt.NVAR by EstimOpt.NCLASS
                
                for s = 1:EstimOpt.NCLASS
                    
                    tmp2 = tmp(EstimOpt.NVAR+1:EstimOpt.NVAR+Nalp,s);
                    alpha = reshape(tmp2,EstimOpt.NVAR,EstimOpt.NFAC) ;
                    load_mtx = alpha*alpha';
                    % variance - unique
                    sigload = tmp(EstimOpt.NVAR+Nalp+1:EstimOpt.NVAR+Nalp+Nsig,s);
                    sigload_mtx = diag(sigload.^2)*eye(EstimOpt.NVAR);
                    varn_mtx = load_mtx + sigload_mtx;
                    Ltmp(:,:,s) = chol(varn_mtx)';
                    
                end
                mm = (EstimOpt.NVAR+NCVFAC)*EstimOpt.NCLASS;
        end
        
        
    case 'mx2'
        
        btmp = reshape(bn(1:EstimOpt.NVAR*EstimOpt.NCLASS),EstimOpt.NVAR,EstimOpt.NCLASS);
        no_b = EstimOpt.NVAR*EstimOpt.NCLASS;
        switch lower(EstimOpt.COVTYPE)
            case 'diag'
                tmp = bn(no_b+1:no_b+EstimOpt.NVAR);
                Ltmp(:,:,1) = xpnd([tmp;zeros(NCV-EstimOpt.NVAR,1)],-1);
                
            case 'fullcov'
                tmp = bn(no_b+1:no_b+NCV);
                Ltmp(:,:,1) = xpnd(tmp,-1);
            case 'facload'
                [NCVFAC Nalp Nsig] = ncvfac(EstimOpt.NVAR,EstimOpt.NFAC,1);
                tmp = bn(no_b+1:no_b+NCVFAC);
                tmp2 = tmp(1:Nalp);
                alpha = reshape(tmp2,EstimOpt.NVAR,EstimOpt.NFAC) ;
                load_mtx = alpha*alpha';
                % variance - unique
                sigload = tmp(Nalp+1:Nalp+Nsig);
                sigload_mtx = diag(sigload.^2)*eye(EstimOpt.NVAR);
                varn_mtx = load_mtx + sigload_mtx;
                Ltmp(:,:,1) = chol(varn_mtx)';
        end
        no_cv = length(tmp);
        sc = bn(no_b+no_cv+1:no_b+no_cv+EstimOpt.NCLASS-1);
        
        
        for s = 2:EstimOpt.NCLASS
            Ltmp(:,:,s) = exp(sc(s-1))*Ltmp(:,:,1);
            
        end
        
        mm = no_b+no_cv+(EstimOpt.NCLASS-1);
        
end %case ModelOpt

%save gmx2n_debug
lamda_tmp = bn(mm+1:mm+(EstimOpt.NCLASS-1)*EstimOpt.NZVAR);
lamda = [reshape(lamda_tmp,EstimOpt.NCLASS-1,EstimOpt.NZVAR); zeros(1,EstimOpt.NZVAR)];
mem_like = ZMAT*lamda'; % NP x NCLASS

max_memlike = max(mem_like,[],2); % NP x 1
e_memdiff = exp(mem_like-repmat(max_memlike,1,EstimOpt.NCLASS)); % NP by NCLASS
sum_ememdiff = sum(e_memdiff,2); % NP by 1
w = e_memdiff./repmat(sum_ememdiff,1,EstimOpt.NCLASS); % NP by NCLASS

p0 = zeros(EstimOpt.NP,EstimOpt.NCLASS);

for n = 1:EstimOpt.NP
    
    %    XX = XMAT(:,:,n)'; %NALT*T by NVAR
    XX = XMAT(:,1:TIMES(n)*NALT,n)';
    switch lower(ModelOpt)
        case 'lc'
            NREP = 1;
            Ltmp = zeros(EstimOpt.NVAR,EstimOpt.NVAR,EstimOpt.NCLASS);
            err = zeros(EstimOpt.NVAR,NREP)';
            
        case {'mx1','mx2'}
            NREP = EstimOpt.NREP;
            err=err_mtx((NREP*(n-1)+1):(NREP*(n-1)+NREP),:);
            
            
    end
    
    for s = 1:EstimOpt.NCLASS
        
        switch lower(ModelOpt)
            case {'lc','mx1','mx2'}
                b_mtx= repmat(btmp(:,s),1,NREP)+(Ltmp(:,:,s)*err');
                
                
        end
        betaX = XX*b_mtx; clear b_mtx
        v = reshape(betaX,NALT,TIMES(n),NREP);
        
        maxv = max(v,[],1);
        evdiff = exp(v-repmat(maxv,[NALT,1,1])); clear v maxv
        sum_evdiff = sum(evdiff,1); %1 by T by NREP
        p1 = evdiff./repmat(sum_evdiff,[NALT,1,1]);
        
        clear evdiff sum_evdiff
        
        Ytmp = repmat(YVEC(:,1:TIMES(n),n),[1,1,NREP]);
        
        p00 = sum(p1.*Ytmp,1); % 1 by T by NREP
        p00 = prod(p00,2); % product over times
        
        clear Ytmp p1
        
        p0(n,s) = mean(p00);
        
    end
    
end % end NP


p = sum(p0.*w,2);

%p0: N by NCLASS, w: NCLASS by 1

f = log(max(p,realmin));
