function der = gmx2n_gr7b(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,b,ZMAT)

% der: NP x #parameters matrix
% analytical gradients of scores
% available for LC only now

% ModelOpt
% LC:  b = [b11,b12,...b1k; b21,...,b2k; lamda1, lamda2]
% MX1: b = [b11,b12,...b1k; cv1; b21,...,b2k; cv2; lamda1, lamda2]
% MX2: b = [b11,b12,...b1k; b21,...,b2k; cv; sc; lamda1, lamda2]
% MX3: b = [b11,b12,...b1k; b21,...,b2k; cv1 or tau1 ; cv2 or tau2; lamda1, lamda2] ?

% EstimOpt.COVTYPE = diag, fullcv, factor (with number of factors)

NALT = EstimOpt.NALT; NREP = EstimOpt.NREP;
bn = b; NCV = ncv(EstimOpt.NVAR);

der = zeros(EstimOpt.NP, length(b));

btmp = zeros(EstimOpt.NVAR,EstimOpt.NCLASS);
p0 = zeros(EstimOpt.NP,EstimOpt.NCLASS);

switch lower(ModelOpt)
    case 'lc'

        btmp = reshape(bn(1:EstimOpt.NVAR*EstimOpt.NCLASS),EstimOpt.NVAR,EstimOpt.NCLASS);
        mm = EstimOpt.NVAR*EstimOpt.NCLASS;

    case 'mx1'

        switch lower(EstimOpt.COVTYPE)
            case {'diag','uncorr'}
                tmp = reshape(bn(1:EstimOpt.NVAR*2*EstimOpt.NCLASS),EstimOpt.NVAR*2,EstimOpt.NCLASS);
                btmp = tmp(1:EstimOpt.NVAR,:); % EstimOpt.NVAR by EstimOpt.NCLASS
                for s = 1:EstimOpt.NCLASS
                    tmp2 = tmp(EstimOpt.NVAR+1:EstimOpt.NVAR*2,s);

                    Ltmp(:,:,s) = xpnd([tmp2;zeros(NCV-EstimOpt.NVAR,1)],-1);
                end
                mm = (EstimOpt.NVAR*2)*EstimOpt.NCLASS;
            otherwise
                error('analyical gradients available only COVTYPE = diag now')
        end

    otherwise
        error('analyical gradients available only ModelOpt = LC or mx1 now')

end

lamda_tmp = bn(mm+1:mm+(EstimOpt.NCLASS-1)*EstimOpt.NZVAR);
lamda = [reshape(lamda_tmp,EstimOpt.NCLASS-1,EstimOpt.NZVAR); zeros(1,EstimOpt.NZVAR)];
mem_like = ZMAT*lamda'; % NP x NCLASS

max_memlike = max(mem_like,[],2); % NP x 1
e_memdiff = exp(mem_like-repmat(max_memlike,1,EstimOpt.NCLASS)); % NP by NCLASS
sum_ememdiff = sum(e_memdiff,2); % NP by 1
w = e_memdiff./repmat(sum_ememdiff,1,EstimOpt.NCLASS); % NP by NCLASS


for n = 1:EstimOpt.NP
   % XX = XMAT(:,:,n)'; %NALT*T by NVAR
XX = XMAT(:,1:TIMES(n)*NALT,n)';
    switch lower(ModelOpt)
        case 'lc'
            NREP = 1;
            Ltmp = zeros(EstimOpt.NVAR,EstimOpt.NVAR,EstimOpt.NCLASS);
            err = zeros(EstimOpt.NVAR,NREP)';

        case 'mx1'
            NREP = EstimOpt.NREP;
            err=err_mtx((NREP*(n-1)+1):(NREP*(n-1)+NREP),:);

        otherwise
            error('analyical gradients available only LC or mx1 now')

    end

    for s = 1:EstimOpt.NCLASS

        switch lower(ModelOpt)
            case {'lc','mx1'}
                b_mtx= repmat(btmp(:,s),1,NREP)+(Ltmp(:,:,s)*err');

            otherwise
                error('analyical gradients available only ModelOpt = LC now')

        end

        betaX = XX*b_mtx; clear b_mtx
        v = reshape(betaX,NALT,TIMES(n),NREP);

        maxv = max(v,[],1);
        evdiff = exp(v-repmat(maxv,[NALT,1,1])); clear v maxv
        sum_evdiff = sum(evdiff,1); %1 by T by NREP
        p1 = evdiff./repmat(sum_evdiff,[NALT,1,1]);

        clear evdiff sum_evdiff

      %  Ytmp = repmat(YVEC(:,:,n),[1,1,NREP]);
 Ytmp = repmat(YVEC(:,1:TIMES(n),n),[1,1,NREP]);

        p00 = sum(p1.*Ytmp,1); % 1 by T by NREP
        p00 = prod(p00,2); % product over times 1x1xNREPxS
        p00_s(:,:,:,s) = p00;
        Y_minus_p1(:,:,:,s) = Ytmp-p1; % NALT by TIMES(n) by NREP

        clear Ytmp p1

        p0(n,s) = mean(p00);

    end %end class



    % gradients for betas for S classes

    for k = 1:EstimOpt.NVAR
        km = k;
        x_k = reshape(XX(:,k),NALT,TIMES(n));
        x_k = repmat(x_k,[1,1,NREP,EstimOpt.NCLASS]);

        g_tmp = sum(sum(Y_minus_p1.*x_k,1),2); % 1 x 1 x NREP x NCLASS
        g_tmp = mean(p00_s.*g_tmp,3); %1 x 1 x 1 x NCLASS
        g_tmp2(:,km,:) = w(n,:).*permute(g_tmp,[3,4,1,2]); % 1 x NCLASS
        clear g_tmp

        %
        if strmatch('mx1', lower(ModelOpt))==1
            err_k = reshape(err(:,k),1,1,NREP);
            err_k = repmat(err_k, [NALT,TIMES(n),1]);
            err_k = repmat(err_k,[1,1,1,EstimOpt.NCLASS]);

            g_tmp = sum(sum(Y_minus_p1.*err_k.*x_k,1),2);% 1 x 1 x NREP x NCLASS
            g_tmp = mean(p00_s.*g_tmp,3); %1 x 1 x 1 x NCLASS
            g_tmp2(:,km+EstimOpt.NVAR,:) = w(n,:).*permute(g_tmp,[3,4,1,2]); % 1 x NVAR x NCLASS

            clear g_tmp
        end
    end
    
        % g_tmp2 = 1 x NVAR x NCLASS
        % g_tmp2 = 1 x NVAR*2 x NCLASS for mx1

        g = reshape(g_tmp2,[1,size(g_tmp2,2)*EstimOpt.NCLASS,1]);
        km = size(g_tmp2,2)*EstimOpt.NCLASS+1;


        tmp = [1:1:EstimOpt.NCLASS];
        % gradients for lamda

        for s = 1:EstimOpt.NCLASS -1
            w_tmp = w(n,s);
            for l = 1:EstimOpt.NZVAR

                for ss = 1:EstimOpt.NCLASS

                    if ss==s
                        g_tmp(:,ss) = ZMAT(n,l)*(1-w_tmp);
                    else
                        g_tmp(:,ss)= -w_tmp*ZMAT(n,1);
                    end

                end

                %g_tmp = repmat(-(ZMAT(n,l)*w_tmp),1,EstimOpt.NCLASS) % 1 by NCLASS

                g(:,km) = sum(w(n,:).*p0(n,:).*g_tmp,2); % scalar

                km = km+1;

            end
        end

        der(n,:) = g; % 1 by # parameters
        clear Y_minus_p1
    end % end NP

    p = sum(p0.*w,2);
    %p0,w : N by NCLASS

    der = der./repmat(max(p,realmin),1,length(b));

end
