function Results = bhhh2010_2(FUN,GRAD,b0,EstimOpt,varargin)

f0 = feval(FUN,b0);
f0 = sum(f0);

b=b0;

tol  = 1; %tolerance
biter = 0; %iteration


while (tol > EstimOpt.EPS) & (tol >= 0) & (biter < EstimOpt.NITER)
    biter = biter + 1;
    if EstimOpt.DISPLAY==1
        disp ('==========================================================================')
        disp(strcat('Iteration:   ',num2str(biter)))
        disp(strcat('Function:   ',num2str(f0)))
        disp(strcat('Tolerance:   ',num2str(tol)))
    end


    % GRAD maybe analytical or numerical
    grad = feval(GRAD,b);

    % if some variables are constrained at their initial values,
    % take out those columns from the score matrix
    if EstimOpt.CZVAR == 1
        grad = grad(:,EstimOpt.BACTIVE==1);
    end

    hesh = grad'*grad;
    sgrad = sum(grad);

    if (det(hesh)==0)
        save singH_debug
        error('Singular Hessian!')
    else
        if EstimOpt.MHESS ==1 % modify hessian
            tmp = ones(size(hesh))+EstimOpt.FACHESS*eye(size(hesh));
            ihesh = inv(tmp.*hesh);
        else
            ihesh = inv(hesh);
        end
        direc = ihesh * sgrad';
    end
    tol   = direc'*sgrad';


    % if some variables are constrained,,
    % insert zero to the positions of direction vector when updating b
    if EstimOpt.CZVAR == 1
        direc = direcXpnd(direc,EstimOpt.BACTIVE);
    end

    lambda = .5;
    step1 = EstimOpt.STEP;
    fold = f0;
    first = 1;
    btmp = b+step1*direc;
    if isempty(EstimOpt.LBVAR)==0
        btmp((btmp<=EstimOpt.LBVAR))=EstimOpt.LBVAR((btmp<=EstimOpt.LBVAR));
    end

    if isempty(EstimOpt.UBVAR)==0
        btmp((btmp>=EstimOpt.UBVAR))=EstimOpt.UBVAR((btmp>=EstimOpt.UBVAR));
    end

    f1 = sum(feval(FUN,btmp));


    if EstimOpt.DISPLAY==1
        disp ('--------------------------------------------------------------------------')
        disp(strcat('step:   ',num2str(step1)))
        disp(strcat('b+step*direc:  ', mat2str(btmp',2)))
        disp(strcat('Change:   ',num2str(f1-f0)))
    end

    %-----------------------steploop---------------------
    %step is adjusted for each iteration
    %if MNR = 1, allow lamda to increase, this will help speed convergence
    %if MNR = 1, and STEPMAX = 1, set the largest step

    if EstimOpt.MNR==0

        while f1<f0 %f0 is given from the previous iter
            step1 = step1*lambda;
            if (step1 < 1.e-5)
                disp ('Failed to find increase.')
                b = btmp;  %btmp from previous calculation
                break % break while f1<f0
            end

            btmp = b+step1*direc;


            if isempty(EstimOpt.LBVAR)==0
                btmp((btmp<=EstimOpt.LBVAR))=EstimOpt.LBVAR((btmp<=EstimOpt.LBVAR));
            end

            if isempty(EstimOpt.UBVAR)==0
                btmp((btmp>=EstimOpt.UBVAR))=EstimOpt.UBVAR((btmp>=EstimOpt.UBVAR));
            end

            f1 = sum(feval(FUN,btmp));

            if EstimOpt.DISPLAY==1
                disp ('--------------------------------------------------------------------------')
                disp(strcat('step:   ',num2str(step1)))
                %   disp(strcat('direction: ', num2str(direc')))
                disp(strcat('b+step*direc:  ', mat2str(btmp',2)))
                disp(strcat('Change:   ',num2str(f1-f0)))
            end
        end

        if f1<=f0
            f1 = f0;
            break %exit while loop
        end
        f0 = f1;
        b = btmp;


    else % EstimOpt.MNR==1
        if f1<=f0

            while f1<=f0 %f0 is given from the previous iter
                step1 = step1*lambda;
                btmp = b+step1*direc;
                if isempty(EstimOpt.LBVAR)==0
                    btmp((btmp<=EstimOpt.LBVAR))=EstimOpt.LBVAR((btmp<=EstimOpt.LBVAR));
                end

                if isempty(EstimOpt.UBVAR)==0
                    btmp((btmp>=EstimOpt.UBVAR))=EstimOpt.UBVAR((btmp>=EstimOpt.UBVAR));
                end
                if (step1 < 1.e-5)
                    disp ('Failed to find increase.')
                    break; %exit only this loop
                end

                f1 =  sum(feval(FUN,btmp));


                if EstimOpt.DISPLAY==1
                    disp ('--------------------------------------------------------------------------');
                    disp(strcat('step:   ',num2str(step1)))
                    disp(strcat('b+step*direc:  ', mat2str(btmp',2)))
                    disp(strcat('Change:   ',num2str(f1-f0)))

                end
            end %end while f1<=f0 loop

            if f1<=f0
                f1 = f0;
                break %exit while loop
            else
                b = btmp;
                f0 = f1;
            end
            first = 0;


        elseif f1>fold & first==1

            while f1> fold & step1<=EstimOpt.MAXSTEP
                fold = f1;
                lambda = 2;
                step1 = step1*lambda;
                if step1<=EstimOpt.MAXSTEP
                    btmp = b+step1*direc;
                    if isempty(EstimOpt.LBVAR)==0
                        btmp((btmp<=EstimOpt.LBVAR))=EstimOpt.LBVAR((btmp<=EstimOpt.LBVAR));
                    end

                    if isempty(EstimOpt.UBVAR)==0
                        btmp((btmp>=EstimOpt.UBVAR))=EstimOpt.UBVAR((btmp>=EstimOpt.UBVAR));
                    end
                    f1 = sum(feval(FUN,btmp));
                else

                    break
                end



                if EstimOpt.DISPLAY==1
                    disp ('--------------------------------------------------------------------------');
                    disp(strcat('step:   ',num2str(step1)))
                    disp(strcat('additional change:   ',num2str(f1-fold)))
                end

            end % end while with increase steps

            b = b + .5 * step1 * direc;
            if isempty(EstimOpt.LBVAR)==0
                b((b<=EstimOpt.LBVAR))=EstimOpt.LBVAR((b<=EstimOpt.LBVAR));
            end

            if isempty(EstimOpt.UBVAR)==0
                b((b>=EstimOpt.UBVAR))=EstimOpt.UBVAR((b>=EstimOpt.UBVAR));
            end
            f0 = fold;
            % adjust values of step and f at the one before the last
            % because the program exits the while loop when f1<fold

            if EstimOpt.DISPLAY==1
                disp ('--------------------------------------------------------------------------');
                disp(strcat('step:   ',num2str(.5*step1)))
                %disp(strcat('direction: ', num2str(direc')))
                disp(strcat('b+step*direc:  ', mat2str(b',2)))
            end

        end % end elseif

        f1 = f0; % in case exit at this loop; otherwise f1 is calculated at next iter

    end %end MNR

end

disp ('**=============================================================================================**')


if (tol< EstimOpt.EPS & tol>0)
    disp(strcat('Converged with tolerance:   ',num2str(tol)))
    disp(strcat('Function value:   ',num2str(f0)))
else
    disp(strcat('Stopped with tolerance:   ',num2str(tol)))
    disp(strcat('Function value:   ',num2str(f1)))
end


lambda = eig(hesh);
if lambda>0
    disp ('Function is concave at stopping point.')
else
    disp ('WARNING:  Function is not concave at stopping point.')
end

Results.bhat = b;
Results.LL = f1;
Results.Tol = tol;
Results.Iter = biter;
Results.b0 = b0;

grad_final = feval(GRAD,b);
% if some variables are constrained at their initial values,
% take out those columns from the score matrix
if EstimOpt.CZVAR == 1
    grad_final = grad_final(:,EstimOpt.BACTIVE==1);
end

hesh_final = grad_final'*grad_final;
Results.bhat = b;
Results.grad = grad_final;
Results.ihesh = inv(hesh_final);
std = sqrt(diag(Results.ihesh));
Results.std = std;


