function Results = GMX2N_2008b(YVEC,XMAT,TIMES,EstimOpt,ModelOpt,ZMAT)
% this program estimates mixture of continuous & discrete choice models

if nargin < 5
    error('the number of input is incorrect.');
end

if isfield(EstimOpt,'DEMO')==1 & EstimOpt.DEMO==1 & nargin<6
    error('the number of input is incorrect.');
end

if isfield(EstimOpt,'b0')==0
    error('need to specify initial values')
end

if isfield(EstimOpt,'NCLASS')==0
    error('need to specify number of classes')
end

switch lower(ModelOpt)
    case 'lc'
        disp('Latent Class')
        if length(EstimOpt.b0)~=EstimOpt.NVAR*EstimOpt.NCLASS + (EstimOpt.NCLASS-1)*size(ZMAT,2)
            error('check no. of starting value or ModelOpt')
        end

    case 'mx1'
        disp('mixture,...')
        disp('unique covariance matrix for each class')

        switch lower(EstimOpt.COVTYPE)
            case 'diag'
                if length(EstimOpt.b0)~=(EstimOpt.NVAR*2)*EstimOpt.NCLASS + (EstimOpt.NCLASS-1)
                    error('check no. of starting value or ModelOpt')
                end
            case 'fullcov'
                if length(EstimOpt.b0)~=(EstimOpt.NVAR+ncv(EstimOpt.NVAR))*EstimOpt.NCLASS + (EstimOpt.NCLASS-1)
                    error('check no. of starting value or ModelOpt')
                end
            case 'facload'
                if length(EstimOpt.b0)~=(EstimOpt.NVAR*3)*EstimOpt.NCLASS + (EstimOpt.NCLASS-1)
                    error('check no. of starting value or ModelOpt')
                end

        end

    case 'mx2'
        disp('mixture,...')
        disp('correlated errors in each class,...')
        disp('cov matrices are constrained to be proportional.')

    case 'mx3'
        disp('mixture,...')
        disp('one or more classes,...')
        disp('are specified with Scale Heterogeneity Model.')

        % specify class distribution
        if isfield(EstimOpt,'CLASSTYPE')==0
            error('need to specify which class has which distribution')
        end

    otherwise
        error('ModelOpt does not match.')
end


if isempty(EstimOpt.BACTIVE)==0 & length(EstimOpt.b0)~=length(EstimOpt.BACTIVE)
    error('check no. of starting value or constraints')
end

b0 =EstimOpt.b0;
NALT =EstimOpt.NALT;

switch lower(ModelOpt)
    case 'lc'
        err_mtx = [];EstimOpt.NREP=1;
    otherwise
        if isfield(EstimOpt,'NREP')==0
            EstimOpt.NREP = 500;
        end
        disp(strcat('No. of draws:   ',num2str(EstimOpt.NREP)))
        switch lower(ModelOpt)
            case {'mx1','mx2'}
                %draws = {normal or halton}
                if isfield(EstimOpt,'DRAWS')==0|EstimOpt.DRAWS >2
                    EstimOpt.DRAWS =1;
                end
                
        end


        if EstimOpt.DRAWS ==1
            if isfield(EstimOpt,'SEED1')==1
                randn('state', EstimOpt.SEED1);
            end
            err_mtx = randn(EstimOpt.NP*EstimOpt.NREP,EstimOpt.NVAR);
            disp('all draws are standard normal')

        elseif EstimOpt.DRAWS == 2
            %% Create the Halton sequence %
            % /* Provide prime number vector */
            prim = primes(113);
            %       display ('Halton sequences are based in primes: ');
            prim(1,1:EstimOpt.NECOL);
            % /* Develop a halton matrix (hm) of size nrep x (nobs*necol); The first 'nobs'
            hm = [];
            for h = 1:EstimOpt.NECOL
                hm1 = halton(10+EstimOpt.NREP*EstimOpt.NP,prim(h));
                %hm1 is a 10+EstimOpt.NREP*EstimOpt.NP column vector
                hm1 = icdf('Normal',hm1,0,1);
                %truncated to avoid very extreme values
                hm1 = hm1.*(hm1<=10)+(10*(hm1>=10));
                hm1 = hm1.*(hm1>=-10)-(10*(hm1<=-10));
                hm = [hm hm1(11:length(hm1))];

            end
            err_mtx = hm; clear hm
            disp('all draws are halton')

       

        end

end

% setting some default values %
if isfield(EstimOpt,'DISPLAY')==0
    EstimOpt.DISPLAY =0;
end

if isfield(EstimOpt,'CZVAR')==0
    EstimOpt.CZVAR = 0; EstimOpt.BACTIVE = [];
end

if EstimOpt.CZVAR == 0
    disp(strcat('Initial values:   ',mat2str(EstimOpt.b0',2)))
    disp('no constraints on parameters')
elseif EstimOpt.CZVAR==1
    disp(strcat('Initial values:   ',mat2str(EstimOpt.b0',2)))
    disp(strcat('Parameters with zeros are constrained to their initial values', mat2str(EstimOpt.BACTIVE)))
end

if isfield(EstimOpt,'LBVAR') ==1 & isempty(EstimOpt.LBVAR)==0
    if length(EstimOpt.LBVAR)~=length(EstimOpt.b0)
        error('wrong numbers of LBVAR')
    else
        disp(strcat('Some parameters have lower bound constraints', mat2str(EstimOpt.LBVAR)))
        EstimOpt.LBVAR = EstimOpt.LBVAR(:);
    end
else
    EstimOpt.LBVAR = [];
    error('should specify LBVAR for parameters determining prob')

end

if isfield(EstimOpt,'UBVAR') ==1 & isempty(EstimOpt.UBVAR)==0
    if length(EstimOpt.UBVAR)~=length(EstimOpt.b0)
        error('wrong numbers of UBVAR')
    else
        disp(strcat('Some parameters have upper bound constraints', mat2str(EstimOpt.UBVAR)))
        EstimOpt.UBVAR = EstimOpt.UBVAR(:);
    end
else
    EstimOpt.UBVAR = [];
    error('should specify UBVAR for parameters determining prob')

end
if isfield(EstimOpt,'FACLOAD')==0
    EstimOpt.FACLOAD =0;
end
if isfield(EstimOpt,'OPTIM')== 0
    EstimOpt.OPTIM=1;
    disp('BHHH')
end

if EstimOpt.OPTIM==1
    if isfield(EstimOpt,'MBHHH')==0
        EstimOpt.MBHHH= 0;
    end
    if isfield(EstimOpt,'MAXSTEP')==0
        EstimOpt.MAXSTEP = 1;
    end
    if isfield(EstimOpt,'NUMGRAD')==0
        EstimOpt.NUMGRAD = 0;
    end
    if isfield(EstimOpt, 'EPS')==0
        EstimOpt.EPS = 1.e-4;
    end
    if isfield(EstimOpt, 'NITER')==0
        EstimOpt.NITER = 500;
    end
    if isfield(EstimOpt, 'STEP')==0
        EstimOpt.STEP = 1;
    end
    if isfield(EstimOpt, 'MNR')==0
        EstimOpt.MNR = 1;
    end
    if EstimOpt.MNR==1 & isfield(EstimOpt,'MAXSTEP')==0
        EstimOpt.MAXSTEP = 1;
    end

    % if want to modify the diagonal of hessian before inverting
    if isfield(EstimOpt, 'MHESS')==0
        EstimOpt.MHESS=0;
    elseif isfield(EstimOpt,'MHESS')==1
        if isfield(EstimOpt,'FACHESS')==0
            EstimOpt.FACHESS = .01;
        end
    end



    if isfield(EstimOpt,'NUMGRAD')==0|EstimOpt.NUMGRAD==0

        if isfield(EstimOpt,'CHECKGRAD')==1 & EstimOpt.CHECKGRAD==1
            disp('check whether analytical grad = numerical grad ')

            a_grad = sum(gmx2n_gr7b(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,b0,ZMAT))';
            n_grad = sum(gmx2n_ngr7(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,b0,ZMAT))';
            graddiff = a_grad-n_grad;

            Results.agrad = a_grad;
            Results.ngrad = n_grad;
            Results.graddiff = graddiff;
            return

        end

        Results = bhhh2010_2(@(B) gmx2n_like7(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,B,ZMAT),...
            @(b) gmx2n_gr7b(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,b,ZMAT),b0,EstimOpt);

    elseif EstimOpt.NUMGRAD==1

        disp('BHHH with numerical gradients')
        Results = bhhh2010_2(@(B) gmx2n_like7(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,B,ZMAT),...
            @(b) gmx2n_ngr7(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,b,ZMAT),b0,EstimOpt);
    end

end


