function der = numdiff2008_1(FUN,b,EstimOpt)
% output of FUN is a scalar or an N x 1 vector
% b is K x 1 vector
 

if nargin <3
    EstimOpt= [];
end

if isfield(EstimOpt,'BACTIVE') & sum(EstimOpt.BACTIVE)>0
    b0 = b(EstimOpt.BACTIVE==1);
else
    b0 = b;

end

abs_b0 = abs(b0);
sign_b0 = sign(b0);


% make a small positive change when around zeros
% sign doesn't matter
sign_b0(sign_b0==0)=1;

%db = (1e-8)*max(abs_b0,1e-2).*sign_b0;
db = (1e-5);

b1 = b0 + db;
db = b1-b0; % K by 1

db_mtx = diag(db); % K by K zeros with db on diagonal
b0_mtx = repmat(b0,1,length(b0));

b1_mtx = b0_mtx + db_mtx; % K by K


for j = 1:length(b0)
    if isfield(EstimOpt,'BACTIVE') &sum(EstimOpt.BACTIVE)>0
        bnew = direcXpnd(b1_mtx(:,j),EstimOpt.BACTIVE);
        bnew(EstimOpt.BACTIVE==0)= EstimOpt.b0(EstimOpt.BACTIVE==0);
        f1_mtx(:,j) = feval(FUN,bnew);

    else
        f1_mtx(:,j) = feval(FUN,b1_mtx(:,j));
    end
end

% f1_mtx is N by K matrix (or 1 by K if f is scalar)

if isfield(EstimOpt,'BACTIVE') &sum(EstimOpt.BACTIVE)>0
    b00 = direcXpnd(b0,EstimOpt.BACTIVE);
    b00(EstimOpt.BACTIVE==0)= b(EstimOpt.BACTIVE==0);
    f0_mtx = repmat(feval(FUN,b00),1,length(b0));
else
    f0_mtx = repmat(feval(FUN,b0),1,length(b0));
end


db = repmat(db',size(f0_mtx,1),1);

der = (f1_mtx-f0_mtx)./db;
% der is N by K matrix

% if some b are constrained to initial values
% der is zero for that b
if isfield(EstimOpt,'BACTIVE') &sum(EstimOpt.BACTIVE)>0
    dernew = direcXpnd(der',EstimOpt.BACTIVE);
    der = dernew';
end



