diary('c:\gmnl2009b\output\diary1') 

clear all

fnameinput = ('c:\gmnl2009b\gmnl_data1');
fnameout_clogit = ('c:\gmnl2009b\output\test_clogit');
fnameout_clogit_t = ('c:\gmnl2009b\output\test_clogit_t');
fnameout_clogit_t_b = ('c:\gmnl2009b\output\test_clogit_t_b');
fnameout_mxl_diag = ('c:\gmnl2009b\output\test_mxl_diag');
fnameout_mxl = ('c:\gmnl2009b\output\test_mxl');
fnameout_gmnl_diag = strvcat('c:\gmnl2009b\output\test_gmnl_diag_a',...
    'c:\gmnl2009b\output\test_gmnl_diag_b');
fnameout_gmnl_diag_g0 = ('c:\gmnl2009b\output\test_gmnl_diag_g0');
fnameout_gmnl_g0 = ('c:\gmnl2009b\output\test_gmnl_g0');
fnameout_gmnl = strvcat('c:\gmnl2009b\output\test_gmnl_a',...
   'c:\gmnl2009b\output\test_gmnl_b',...
   'c:\gmnl2009b\output\test_gmnl_c');



    % *****************  loading & specifying data ***************
s=1;
    load(fnameinput(s,:))
    % the input is in a stacked format:(the format Stata and Limdep require to estimate conditional MNL.)

    % Number of people
    EstimOpt.NP = 120;
    % Number of observations
    EstimOpt.NOBS = 120*32;
    % Number of alternatives
    EstimOpt.NALT = 2;
    % Number of attributes
    EstimOpt.NVAR = 4;
    TIMES = 32*ones(EstimOpt.NP,1);

    Results_clogit = clogit(Y,X,[]);
    strvcat('         est.    std.err.',num2str([[1:length(Results_clogit.bhat)]' Results_clogit.bhat Results_clogit.std],4))
    strvcat('LL at convergence: ',num2str(Results_clogit.LL,4))
    save(fnameout_clogit(s,:), 'Results_clogit')

    % note: G-MMNL function requires data in different format.
    % The following lines reshape Y and X into 3-dimension matrices.
    % If number of scenarios (TIMES) differ across individuals,
    % need some modification...

    YVEC = reshape(Y',EstimOpt.NALT,TIMES(1),EstimOpt.NP);
    XMAT = reshape(X',EstimOpt.NVAR, EstimOpt.NALT*TIMES(1),EstimOpt.NP);

    clear Y X


    % ****************** ModelOpt = S_MNL *************************
    ModelOpt = 's_mnl';

    tau0 = 0.1;
    % initial value
    EstimOpt.b0 = [Results_clogit.bhat; tau0];
    
    tic
    Results_clogit_t = GMNL_2009b(YVEC,XMAT,TIMES,EstimOpt,ModelOpt,[]);
    toc
    strvcat('         est.    std.err.',num2str([[1:length(EstimOpt.b0)]' Results_clogit_t.bhat Results_clogit_t.std],4))

    save(fnameout_clogit_t(s,:), 'Results_clogit_t')

    % not scale the first coefficient
%     EstimOpt.NOTSCALE = [1 zeros(1,EstimOpt.NVAR-1)];
% 
%     Results_clogit_t_b = GMNL_2009b(YVEC,XMAT,TIMES,EstimOpt,ModelOpt,[]);
%     strvcat('         est.    std.err.',num2str([[1:length(EstimOpt.b0)]' Results_clogit_t_b.bhat Results_clogit_t_b.std],4))
% 
%     save(fnameout_clogit_t_b(s,:), 'Results_clogit_t_b')


    % ****************** ModelOpt = MXL *************************
     EstimOpt.NOTSCALE = []; % this option is irrelevant for MXL

    % uncorrelated coefficients
    ModelOpt = 'mxl';
    EstimOpt.COVTYPE = 'uncorr';
    EstimOpt.b0 = [Results_clogit.bhat; zeros(EstimOpt.NVAR,1)];

    tic
    Results_mxl_diag = GMNL_2009b(YVEC,XMAT,TIMES,EstimOpt,ModelOpt,[]);
    toc
    strvcat('         est.    std.err.',num2str([[1:length(EstimOpt.b0)]' Results_mxl_diag.bhat Results_mxl_diag.std],4))

    save(fnameout_mxl_diag(s,:), 'Results_mxl_diag')

         
    % correlated coefficients
    
    ModelOpt = 'mxl';
    EstimOpt.COVTYPE = 'fullcov';
    NCV = ncv(EstimOpt.NVAR); % a helper to calculate number of choleski elements of cov matrix
    EstimOpt.b0 = [Results_mxl_diag.bhat; .1*ones(NCV-EstimOpt.NVAR,1)];

    
    tic
    Results_mxl = GMNL_2009b(YVEC,XMAT,TIMES,EstimOpt,ModelOpt,[]);
    toc
    strvcat('         est.    std.err.',num2str([[1:length(EstimOpt.b0)]' Results_mxl.bhat Results_mxl.std],4))

    save(fnameout_mxl(s,:), 'Results_mxl')


    % ******************G-MNL *************************
    % G-MNL with uncorrelated coefficients
    % 2 possible good sets of initial values
    % 1) MIXL with uncorrelated coefficients
    % 2) First estimate a model with gamma fixed at .5
    %    then, use those estimates as initial values and free gamma
    
    % 1) b0 = MIXL with uncorrelated coefficients
    tau0 = 0.1;  gamma0 = -1;
    EstimOpt.b0 = [Results_mxl_diag.bhat; tau0; gamma0];
    ModelOpt = 'g_mnl';
    EstimOpt.COVTYPE = 'uncorr';
    EstimOpt.GRADCHECK = 0; 
    tic
    Results_gmnl_diag = GMNL_2009b(YVEC,XMAT,TIMES,EstimOpt,ModelOpt,[]);
    toc
    strvcat('         est.    std.err.',num2str([[1:length(EstimOpt.b0)]' Results_gmnl_diag.bhat Results_gmnl_diag.std],4))

    save(fnameout_gmnl_diag(s,:), 'Results_gmnl_diag')

    % 2) First estimate a model with gamma fixed at .5
    tau0 = 0.5;  gamma0 = 0;
    EstimOpt.b0 = [Results_clogit.bhat; .1*ones(EstimOpt.NVAR,1); tau0; gamma0];
    % to constrain the last parameter to initial value
    EstimOpt.CZVAR = 1;
    EstimOpt.BACTIVE = [ones(1,length(EstimOpt.b0)-1) 0];
    tic
    Results_gmnl_diag_g0 = GMNL_2009b(YVEC,XMAT,TIMES,EstimOpt,ModelOpt,[]);
    toc
    strvcat('         est.    std.err.',num2str([[1:sum(EstimOpt.BACTIVE)]' Results_gmnl_diag_g0.bhat(EstimOpt.BACTIVE==1) Results_gmnl_diag_g0.std],4))

    save(fnameout_gmnl_diag_g0(s,:), 'Results_gmnl_diag_g0')
    
    %    then, use those estimates as initial values and free gamma
    EstimOpt.b0 = Results_gmnl_diag_g0.bhat;
    EstimOpt.CZVAR = 0; EstimOpt.BACTIVE = [];
    
    tic
    Results_gmnl_diag = GMNL_2009b(YVEC,XMAT,TIMES,EstimOpt,ModelOpt,[]);
    toc
    strvcat('         est.    std.err.',num2str([[1:length(EstimOpt.b0)]' Results_gmnl_diag.bhat Results_gmnl_diag.std],4))

    s = 2;
    save(fnameout_gmnl_diag(s,:), 'Results_gmnl_diag')

    %  the case of scale + random effects is specified as special case of
    %  'g_mnl' with 'uncorr' where coefficients without random effects are
    %  constrained to zero.
    
    
    % G-MNL with correlated coefficients
    % 3 possible good sets of initial values
    % 1) MIXL with correlated coefficients
    % 2) First estimate a model with gamma fixed at .5
    %    then, use those estimates as initial values and free gamma
    % 3) G-MNL with correlated coefficients
    
    ModelOpt = 'g_mnl';
    EstimOpt.COVTYPE = 'fullcov';

    % 1) MIXL with correlated coefficients
    EstimOpt.b0 = [Results_mxl.bhat;.5;-1];
    tic
    Results_gmnl = GMNL_2009b(YVEC,XMAT,TIMES,EstimOpt,ModelOpt,[]);
    toc
    strvcat('         est.    std.err.',num2str([[1:length(EstimOpt.b0)]' Results_gmnl.bhat Results_gmnl.std],4))

    s=1;
    save(fnameout_gmnl(s,:), 'Results_gmnl')
    
    % 2) First estimate a model with gamma fixed at .5
    %    then, use those estimates as initial values and free gamma
    
    tau0 = 0.5;  gamma0 = 0;
    EstimOpt.b0 = [Results_clogit.bhat; .1*ones(NCV,1); tau0; gamma0];
    % to constrain the last parameter to initial value
    EstimOpt.CZVAR = 1;
    EstimOpt.BACTIVE = [ones(1,length(EstimOpt.b0)-1) 0];
    tic
    Results_gmnl_g0 = GMNL_2009b(YVEC,XMAT,TIMES,EstimOpt,ModelOpt,[]);
    toc
    strvcat('         est.    std.err.',num2str([[1:sum(EstimOpt.BACTIVE)]' Results_gmnl_g0.bhat(EstimOpt.BACTIVE==1) Results_gmnl_g0.std],4))

    save(fnameout_gmnl_g0(s,:), 'Results_gmnl_g0')
    
     EstimOpt.b0 = Results_gmnl_g0.bhat;
    EstimOpt.CZVAR = 0; EstimOpt.BACTIVE = [];
    
    tic
    Results_gmnl = GMNL_2009b(YVEC,XMAT,TIMES,EstimOpt,ModelOpt,[]);
    toc
    strvcat('         est.    std.err.',num2str([[1:length(EstimOpt.b0)]' Results_gmnl.bhat Results_gmnl.std],4))

    s = 2;
    save(fnameout_gmnl(s,:), 'Results_gmnl')

    % 3) G-MNL with correlated coefficients
     EstimOpt.b0 = [Results_gmnl_diag.bhat(1:EstimOpt.NVAR*2);.1*ones(NCV-EstimOpt.NVAR,1);Results_gmnl_diag.bhat(EstimOpt.NVAR*2+1:EstimOpt.NVAR*2+2)];
    tic
    Results_gmnl = GMNL_2009b(YVEC,XMAT,TIMES,EstimOpt,ModelOpt,[]);
    toc
    strvcat('         est.    std.err.',num2str([[1:length(EstimOpt.b0)]' Results_gmnl.bhat Results_gmnl.std],4))

    s = 3;
    save(fnameout_gmnl(s,:), 'Results_gmnl')
    

diary off



