function f = g_mnl_like7a(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,b)

% ModelOpt, EstimOpt.COVTYPE
% S_MNL:        b = [b1 b2 ... bk; tau]
% MXL,uncorr:   b = [b1,b2,...bk; l11,l22,...,lkk]
% MXL,corr:     b = [b1,b2,...bk; l11,l22,...,lkk,l21,l32,....,lk1]
% MXL,factor:   b = [b1,b2,...bk; alpha1,...,alphak, sig1,...,sigk]
% G_MNL,uncorr:   b = [b1,b2,...bk; l11,l22,...,lkk,tau,gamma]
% G_MNL,corr:     b = [b1,b2,...bk;l11,l22,...,lkk,l21,l32,....,lk1,tau,gamma]
% G_MNL,factor:   b = [b1,b2,...bk; alpha1,...,alphak,sig1,...,sigk,tau,gamma]

NALT = EstimOpt.NALT; NREP = EstimOpt.NREP;
bn = b; NCV = ncv(EstimOpt.NVAR);
% mean betas
btmp = bn(1:EstimOpt.NVAR);

switch lower(ModelOpt)
    case 's_mnl'
        tau = bn(EstimOpt.NVAR+1);
        sigma_bar = -log(mean(exp(tau*reshape(err_mtx(:,1),NREP,EstimOpt.NP)'),1)); % 1 by NREP

    case {'mxl','g_mnl'}
        switch lower(EstimOpt.COVTYPE)
            case 'uncorr'
                tmp = bn(EstimOpt.NVAR+1:EstimOpt.NVAR*2);
                Ltmp = xpnd([tmp;zeros(NCV-EstimOpt.NVAR,1)],-1);

            case 'fullcov'
                tmp = bn(EstimOpt.NVAR+1:EstimOpt.NVAR+NCV);
                Ltmp = xpnd(tmp,-1);

            case 'factor'

                [NCVFAC Nalp Nsig] = ncvfac(EstimOpt.NVAR,EstimOpt.NFAC,1);

                tmp = bn(EstimOpt.NVAR+1:EstimOpt.NVAR+Nalp);
                alpha = reshape(tmp,EstimOpt.NVAR,EstimOpt.NFAC) ;
                load_mtx = alpha*alpha';

                % variance - unique
                sigload = bn(EstimOpt.NVAR+Nalp+1:EstimOpt.NVAR+Nalp+Nsig);
                sigload_mtx = diag(sigload.^2)*eye(EstimOpt.NVAR);
                varn_mtx = load_mtx + sigload_mtx;
                Ltmp = chol(varn_mtx)';
        end
        if strmatch('g_mnl', ModelOpt)==1
            tau = bn(length(bn)-1);
            sigma_bar = -log(mean(exp(tau*reshape(err_mtx(:,1),NREP,EstimOpt.NP)'),1)); % 1 by NREP

            % gamma here is gamma_star in the paper and vice versa

            gamma = bn(length(bn));


        end

end


p0 = zeros(EstimOpt.NP,1);

for n = 1:EstimOpt.NP

    err=err_mtx((NREP*(n-1)+1):(NREP*(n-1)+NREP),:) ;
    % err has NREP rows and NVAR+1 columns for each person. %

    switch lower(ModelOpt)
        case 's_mnl'
            if isfield(EstimOpt,'TAUFUN')==1 &  EstimOpt.TAUFUN ==1
                sigma_n = exp(sigma_bar +jay_n(n)+tau*err(:,1)'); % 1 by NREP
            else
                sigma_n = exp(sigma_bar +tau*err(:,1)'); % 1 by NREP
            end

            if isfield(EstimOpt,'NOTSCALE')==1 & sum(EstimOpt.NOTSCALE)>0
                tmp = repmat(sigma_n,EstimOpt.NVAR,1);
                tmp(EstimOpt.NOTSCALE==1,:)=1;
            else
                tmp = repmat(sigma_n,EstimOpt.NVAR,1); % NVAR by NREP
            end

            b_mtx = tmp.*repmat(btmp,1,NREP);

        case 'mxl'
            b_mtx = repmat(btmp,1,NREP) + Ltmp*err(:,1:EstimOpt.NVAR)';

        case 'g_mnl'

            sigma_n = exp(sigma_bar +tau*err(:,1)'); % 1 by NREP

            gamma_star = exp(gamma)/(1+exp(gamma)); % N by 1

            if isfield(EstimOpt,'NOTSCALE')==1 & sum(EstimOpt.NOTSCALE)>0
                tmp = repmat(sigma_n,EstimOpt.NVAR,1);
                tmp(EstimOpt.NOTSCALE==1,:)=1;
            else
                tmp = repmat(sigma_n,EstimOpt.NVAR,1);
            end

            b_mtx = tmp.*repmat(btmp,1,NREP)...
                + gamma_star*Ltmp*err(:,2:EstimOpt.NVAR+1)'...
                + (1-gamma_star)*tmp.*(Ltmp*err(:,2:EstimOpt.NVAR+1)');

    end


    XX = XMAT(:,1:TIMES(n)*NALT,n)'; %NALT*T by NVAR

    betaX = XX*b_mtx; clear XX b_mtx
    v = reshape(betaX,NALT,TIMES(n),NREP);

    maxv = max(v,[],1);
    evdiff = exp(v-repmat(maxv,[NALT,1,1])); clear v maxv
    sum_evdiff = sum(evdiff,1); %1 by T by NREP
    p1 = evdiff./repmat(sum_evdiff,[NALT,1,1]);

    clear evdiff sum_evdiff

    Ytmp = repmat(YVEC(:,1:TIMES(n),n),[1,1,NREP]);

    p00 = sum(p1.*Ytmp,1); % 1 by T by NREP
    p00 = prod(p00,2); % product over times
    clear Ytmp p1

    p0(n,1) = mean(p00);


end % end NP

f = log(max(p0,realmin));

