function der = g_mnl_gr8a(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,b)

% ModelOpt, EstimOpt.COVTYPE
% S_MNL:        b = [b1 b2 ... bk; tau]
% MXL,uncorr:   b = [b1,b2,...bk; l11,l22,...,lkk]
% MXL,corr:     b = [b1,b2,...bk; l11,l22,...,lkk,l21,l32,....,lk1]
% MXL,factor:   b = [b1,b2,...bk; alpha1,...,alphak, sig1,...,sigk]
% G_MNL,uncorr:   b = [b1,b2,...bk; l11,l22,...,lkk,tau,gamma]
% G_MNL,corr:     b = [b1,b2,...bk;l11,l22,...,lkk,l21,l32,....,lk1,tau,gamma]
% G_MNL,factor:   b = [b1,b2,...bk; alpha1,...,alphak,sig1,...,sigk,tau,gamma]

NALT = EstimOpt.NALT; NREP = EstimOpt.NREP;
bn = b; NCV = ncv(EstimOpt.NVAR);
% mean betas
btmp = bn(1:EstimOpt.NVAR);

switch lower(ModelOpt)
    case 's_mnl'
        tau = bn(EstimOpt.NVAR+1);

        exp_tau_err1 = exp(tau*reshape(err_mtx(:,1),NREP,EstimOpt.NP)'); % NP by NREP

        sum_e_tau_err1= sum(exp_tau_err1.*reshape(err_mtx(:,1),NREP,EstimOpt.NP)',1); %1 by NREP
        p_e_tau = sum_e_tau_err1./sum(exp_tau_err1,1); %1 by NREP
        sigma_bar = -log(mean(exp_tau_err1,1)); % 1 by NREP

        clear exp_tau_err1 sum_e_tau_err1

    case {'mxl','g_mnl'}
        switch lower(EstimOpt.COVTYPE)
            case 'uncorr'
                tmp = bn(EstimOpt.NVAR+1:EstimOpt.NVAR*2);
                Ltmp = xpnd([tmp;zeros(NCV-EstimOpt.NVAR,1)],-1);

            case 'fullcov'
                tmp = bn(EstimOpt.NVAR+1:EstimOpt.NVAR+NCV);
                Ltmp = xpnd(tmp,-1);

            case 'factor'

                [NCVFAC Nalp Nsig] = ncvfac(EstimOpt.NVAR,EstimOpt.NFAC,1);

                tmp = bn(EstimOpt.NVAR+1:EstimOpt.NVAR+Nalp);
                alpha = reshape(tmp,EstimOpt.NVAR,EstimOpt.NFAC) ;
                load_mtx = alpha*alpha';

                % variance - unique
                sigload = bn(EstimOpt.NVAR+Nalp+1:EstimOpt.NVAR+Nalp+Nsig);
                sigload_mtx = diag(sigload.^2)*eye(EstimOpt.NVAR);
                varn_mtx = load_mtx + sigload_mtx;
                Ltmp = chol(varn_mtx)';
        end
        if strmatch('g_mnl', ModelOpt)==1
            tau = bn(length(bn)-1);

            gamma = bn(length(bn));

            tau = bn(length(bn)-1);
            exp_tau_err1 = exp(tau*reshape(err_mtx(:,1),NREP,EstimOpt.NP)'); % NP by NREP

            sum_e_tau_err1= sum(exp_tau_err1.*reshape(err_mtx(:,1),NREP,EstimOpt.NP)',1); %1 by NREP
            p_e_tau = sum_e_tau_err1./sum(exp_tau_err1,1); %1 by NREP
            sigma_bar = -log(mean(exp_tau_err1,1)); % 1 by NREP

            clear exp_tau_err1 sum_e_tau_err1

        end

end

p0 = zeros(EstimOpt.NP,1);
der = zeros(EstimOpt.NP, length(b));

for n = 1:EstimOpt.NP
    err=err_mtx((NREP*(n-1)+1):(NREP*(n-1)+NREP),:) ;
    % err has NREP rows and NVAR+1 columns for each person. %

    switch lower(ModelOpt)
        case 's_mnl'

            sigma_n = exp(sigma_bar +tau*err(:,1)'); % 1 by NREP


            if isfield(EstimOpt,'NOTSCALE')==1 & sum(EstimOpt.NOTSCALE)>0
                tmp = repmat(sigma_n,EstimOpt.NVAR,1);
                tmp(EstimOpt.NOTSCALE==1,:)=1;
            else
                tmp = repmat(sigma_n,EstimOpt.NVAR,1);
            end
            b_mtx = tmp.*repmat(btmp,1,NREP);

        case 'mxl'
            b_mtx = repmat(btmp,1,NREP) + Ltmp*err(:,1:EstimOpt.NVAR)';

        case 'g_mnl'
            sigma_n = exp(sigma_bar +tau*err(:,1)'); % 1 by NREP


            gamma_star = exp(gamma)/(1+exp(gamma)); % N by 1

            if isfield(EstimOpt,'NOTSCALE')==1 & sum(EstimOpt.NOTSCALE)>0
                tmp = repmat(sigma_n,EstimOpt.NVAR,1);
                tmp(EstimOpt.NOTSCALE==1,:)=1;
            else
                tmp = repmat(sigma_n,EstimOpt.NVAR,1);
            end

            b_mtx = tmp.*repmat(btmp,1,NREP)...
                + gamma_star*Ltmp*err(:,2:EstimOpt.NVAR+1)'...
                + (1-gamma_star)*tmp.*(Ltmp*err(:,2:EstimOpt.NVAR+1)');

    end


    XX = XMAT(:,1:TIMES(n)*NALT,n)'; %NALT*T by NVAR

    betaX = XX*b_mtx; clear b_mtx
    v = reshape(betaX,NALT,TIMES(n),NREP);

    maxv = max(v,[],1);
    evdiff = exp(v-repmat(maxv,[NALT,1,1])); clear v maxv
    sum_evdiff = sum(evdiff,1); %1 by T by NREP
    p1 = evdiff./repmat(sum_evdiff,[NALT,1,1]);

    clear evdiff sum_evdiff

    Ytmp = repmat(YVEC(:,1:TIMES(n),n),[1,1,NREP]);

    p00 = sum(p1.*Ytmp,1); % 1 by T by NREP
    p00 = prod(p00,2); % product over times
    Y_minus_p1 = Ytmp-p1; % NALT by TIMES(n) by NREP

    clear Ytmp p1

    p0(n,1) = mean(p00);


    % gradients
    g = zeros(EstimOpt.NREP, length(b));
    switch lower(ModelOpt)
        case 's_mnl'
            sigma_n_tmp = reshape(sigma_n,1,1,NREP);
            sigma_n_tmp = repmat(sigma_n_tmp, [NALT,TIMES(n),1]); %NALT by TIMES(n) by NREP

            % scale or not scale
            for k = 1:EstimOpt.NVAR
                km = k;

                if EstimOpt.NOTSCALE(k)==1
                    % gradients for betas
                    x_k = reshape(XX(:,k),NALT,TIMES(n));
                    x_k = repmat(x_k,[1,1,NREP]);
                    g_tmp = sum(sum(Y_minus_p1.*x_k,1),2);
                    g(:,km) = reshape(g_tmp,NREP,1); clear g_tmp

                else
                    % gradients for betas
                    x_k = reshape(XX(:,k),NALT,TIMES(n));
                    x_k = repmat(x_k,[1,1,NREP]);

                    g_tmp = sum(sum(Y_minus_p1.*x_k.*sigma_n_tmp,1),2);
                    g(:,km) = reshape(g_tmp,NREP,1); clear g_tmp

                end
            end
            % gradients for tau

            km = EstimOpt.NVAR+1;

            tmp = XX(:,EstimOpt.NOTSCALE~=1)*btmp(EstimOpt.NOTSCALE~=1); % JT by 1
            tmp2 = repmat(reshape(tmp,[NALT,TIMES(n),1]),[1,1,NREP]); % J by T by NREP

            g_tmp = sum(sum(Y_minus_p1.*tmp2,1),2); % 1 by 1 by NREP
            g(:,km) =  reshape(g_tmp,NREP,1).*sigma_n'.*(-p_e_tau'+err(:,1)); % NREP by 1
        case 'mxl'
            % gradients for betas

            for k = 1:EstimOpt.NVAR
                km = k;
                x_k = reshape(XX(:,k),NALT,TIMES(n));
                x_k = repmat(x_k,[1,1,NREP]);

                g_tmp = sum(sum(Y_minus_p1.*x_k,1),2);
                g(:,km) = reshape(g_tmp,NREP,1); clear g_tmp
                err_k = reshape(err(:,k),1,1,NREP);
                err_k = repmat(err_k, [NALT,TIMES(n),1]);
                g_tmp = sum(sum(Y_minus_p1.*err_k.*x_k,1),2);
                g(:,km+EstimOpt.NVAR) = reshape(g_tmp,NREP,1); clear g_tmp err_k x_k

            end

            if strmatch('fullcov', lower(EstimOpt.COVTYPE))==1
                km = EstimOpt.NVAR*2+1;
                % gradients for off-diagonal elements of var-cov matrix
                for d = 1:EstimOpt.NVAR-1
                    for k = 1:EstimOpt.NVAR-d
                        err_k = reshape(err(:,k),1,1,NREP);
                        err_k = repmat(err_k, [NALT,TIMES(n),1]);
                        x_k = reshape(XX(:,k+d),NALT,TIMES(n));
                        x_k = repmat(x_k,[1,1,NREP]);

                        g_tmp = sum(sum(Y_minus_p1.*err_k.*x_k,1),2);
                        g(:,km) = reshape(g_tmp,NREP,1); clear g_tmp err_k x_k
                        km = km+1;

                    end
                end
            end

            % if EstimOpt.COV = FACTOR -- switch to numerical gradients

        case 'g_mnl'
            % gradients for betas & diagonal
            sigma_n_tmp = reshape(sigma_n,1,1,NREP);
            sigma_n_tmp = repmat(sigma_n_tmp, [NALT,TIMES(n),1]); %NALT by TIMES(n) by NREP

            g = zeros(EstimOpt.NREP, length(b));

            if isfield(EstimOpt,'NOTSCALE')==1 & sum(EstimOpt.NOTSCALE)>0
                for k = 1:EstimOpt.NVAR
                    km = k;

                    if EstimOpt.NOTSCALE(k)==1
                        % gradients for betas
                        x_k = reshape(XX(:,k),NALT,TIMES(n));
                        x_k = repmat(x_k,[1,1,NREP]);
                        g_tmp = sum(sum(Y_minus_p1.*x_k,1),2);
                        g(:,km) = reshape(g_tmp,NREP,1); clear g_tmp

                        % gradients for diagonal elements of var-cov matrix
                        err_k = reshape(err(:,k+1),1,1,NREP);
                        err_k = repmat(err_k, [NALT,TIMES(n),1]);
                        g_tmp = sum(sum(Y_minus_p1.*err_k.*x_k,1),2);
                        g(:,km+EstimOpt.NVAR) = reshape(g_tmp,NREP,1); clear g_tmp err_k x_k
                        km = EstimOpt.NVAR*2+1;

                    else
                        % gradients for betas
                        x_k = reshape(XX(:,k),NALT,TIMES(n));
                        x_k = repmat(x_k,[1,1,NREP]);

                        g_tmp = sum(sum(Y_minus_p1.*x_k.*sigma_n_tmp,1),2);
                        g(:,km) = reshape(g_tmp,NREP,1); clear g_tmp

                        % gradients for diagonal elements of var-cov matrix
                        err_k = reshape(err(:,k+1),1,1,NREP);
                        err_k = repmat(err_k, [NALT,TIMES(n),1]);
                        g_tmp = sum(sum(Y_minus_p1.*(gamma_star+((1-gamma_star)*sigma_n_tmp)).*err_k.*x_k,1),2);
                        g(:,km+EstimOpt.NVAR) = reshape(g_tmp,NREP,1); clear g_tmp err_k x_k
                    end
                end
                km = EstimOpt.NVAR*2+1;

                if strmatch('fullcov', lower(EstimOpt.COVTYPE))==1

                    OFFDIAGNOTSCALE = LtoVEC(tril(EstimOpt.NOTSCALE'*EstimOpt.NOTSCALE));
                    OFFDIAGNOTSCALE = OFFDIAGNOTSCALE(EstimOpt.NVAR+1:length(OFFDIAGNOTSCALE));
                    offdiag = 1;

                    % gradients for off-diagonal elements of var-cov matrix
                    for d = 1:EstimOpt.NVAR-1
                        for k = 1:EstimOpt.NVAR-d
                            err_k = reshape(err(:,k+1),1,1,NREP);
                            err_k = repmat(err_k, [NALT,TIMES(n),1]);
                            x_k = reshape(XX(:,k+d),NALT,TIMES(n));
                            x_k = repmat(x_k,[1,1,NREP]);
                            
                            if OFFDIAGNOTSCALE(offdiag)==1
                                g_tmp = sum(sum(Y_minus_p1.*(gamma_star+((1-gamma_star))).*err_k.*x_k,1),2);
                            else
                                g_tmp = sum(sum(Y_minus_p1.*(gamma_star+((1-gamma_star)*sigma_n_tmp)).*err_k.*x_k,1),2);
                            end

                            g(:,km) = reshape(g_tmp,NREP,1); clear g_tmp err_k x_k
                            km = km+1;
                            offdiag = offdiag+1;
                        end
                    end
                end

                clear sigma_n_tmp

                % gradients for tau
                tmp = repmat(btmp(EstimOpt.NOTSCALE~=1),1,NREP)+ (1-gamma_star).*(Ltmp(EstimOpt.NOTSCALE~=1,:)*err(:,2:EstimOpt.NVAR+1)'); % NVAR by NREP
                tmp2 = reshape(XX(:,EstimOpt.NOTSCALE~=1)*tmp,NALT,TIMES(n),NREP);
                g_tmp = sum(sum(Y_minus_p1.*tmp2,1),2); % 1 by 1 by NREP

                g(:,km) =  reshape(g_tmp,NREP,1).*sigma_n'.*(-p_e_tau'+err(:,1)); % NREP by 1
                km = km+1;
                clear g_tmp tmp tmp2

                % gradients for gamma
                tmp = (1-repmat(sigma_n,sum(EstimOpt.NOTSCALE==0),1)).*(Ltmp(EstimOpt.NOTSCALE~=1,:)*err(:,2:EstimOpt.NVAR+1)'); % NVAR by NREP
                tmp2 = reshape(XX(:,EstimOpt.NOTSCALE~=1)*tmp,NALT,TIMES(n),NREP);
                g_tmp = sum(sum(Y_minus_p1.*tmp2,1),2); % 1 by 1 by NREP

                g(:,km) =  reshape(g_tmp,NREP,1); % NREP by 1

            else %EstimOpt.NOTSCALE = []; no intercept
                for k = 1:EstimOpt.NVAR
                    km = k;
                    % gradients for betas
                    x_k = reshape(XX(:,k),NALT,TIMES(n));
                    x_k = repmat(x_k,[1,1,NREP]);

                    g_tmp = sum(sum(Y_minus_p1.*x_k.*sigma_n_tmp,1),2);
                    g(:,km) = reshape(g_tmp,NREP,1); clear g_tmp

                    % gradients for diagonal elements of var-cov matrix
                    err_k = reshape(err(:,k+1),1,1,NREP);
                    err_k = repmat(err_k, [NALT,TIMES(n),1]);
                    g_tmp = sum(sum(Y_minus_p1.*(gamma_star+((1-gamma_star)*sigma_n_tmp)).*err_k.*x_k,1),2);
                    g(:,km+EstimOpt.NVAR) = reshape(g_tmp,NREP,1); clear g_tmp err_k x_k

                end
                km = EstimOpt.NVAR*2+1;


                if strmatch('fullcov', lower(EstimOpt.COVTYPE))==1

                    % gradients for off-diagonal elements of var-cov matrix
                    for d = 1:EstimOpt.NVAR-1
                        for k = 1:EstimOpt.NVAR-d
                            err_k = reshape(err(:,k+1),1,1,NREP);
                            err_k = repmat(err_k, [NALT,TIMES(n),1]);
                            x_k = reshape(XX(:,k+d),NALT,TIMES(n));
                            x_k = repmat(x_k,[1,1,NREP]);

                            g_tmp = sum(sum(Y_minus_p1.*(gamma_star+((1-gamma_star)*sigma_n_tmp)).*err_k.*x_k,1),2);
                            g(:,km) = reshape(g_tmp,NREP,1); clear g_tmp err_k x_k
                            km = km+1;

                        end
                    end
                    clear sigma_n_tmp
                end % end fullcov

                % gradients for tau
                tmp = repmat(btmp,1,NREP)+ (1-gamma_star).*(Ltmp*err(:,2:EstimOpt.NVAR+1)'); % NVAR by NREP
                tmp2 = reshape(XX*tmp,NALT,TIMES(n),NREP);
                g_tmp = sum(sum(Y_minus_p1.*tmp2,1),2); % 1 by 1 by NREP

                g(:,km) =  reshape(g_tmp,NREP,1).*sigma_n'.*(-p_e_tau'+err(:,1)); % NREP by 1
                clear g_tmp tmp tmp2

                km = km+1;

                clear g_tmp tmp tmp2

                % gradients for gamma
                tmp = (1-repmat(sigma_n,EstimOpt.NVAR,1)).*(Ltmp*err(:,2:EstimOpt.NVAR+1)'); % NVAR by NREP
                tmp2 = reshape(XX*tmp,NALT,TIMES(n),NREP);
                g_tmp = sum(sum(Y_minus_p1.*tmp2,1),2); % 1 by 1 by NREP
                g(:,km) =  reshape(g_tmp,NREP,1)*(gamma_star/(1+exp(gamma))); % NREP by 1
            end % end NOTSCLAE

    end % end case

    der(n,:) = mean(repmat(reshape(p00,NREP,1),1,length(b)).*g);

end % end NP


der = der./kron(max(p0,realmin),ones(1,length(b)));

