function [g, h] = clogit_gr(y,X1,WT,B)

if isempty(WT)==1
    WT = ones(size(y));
end

N=sum(y);J=length(y)/N;
N_wtg = sum(WT.*y);
K1=size(X1,2);

% computing utility levels

V1=kron(B',ones(N*J,1)).*X1;
v=sum(V1,2); clear V1
v=reshape(v,J,N);

maxv = max(v,[],1);
evdiff = exp(v-repmat(maxv,[J,1])); clear v maxv
sum_evdiff = sum(evdiff,1); %1 by N

P = evdiff./repmat(sum_evdiff,[J,1]); % J by N

%probs=sum(reshape(y,J,N).*P);

%logprobs = log(max(probs,realmin)); %1 *N


Y_tmp = reshape(y,J,N);

for i = 1:K1
    X_tmp = reshape(X1(:,i),J,N);
    g_tmp = (Y_tmp-P).*X_tmp; %J by N
    g(i,:) = sum(g_tmp,1); % sum across J
    
end
g = g';% N by K


if nargout >1
    
for i = 1:K1
    X_tmp = reshape(X1(:,i),J,N); 
    h_tmp = X_tmp- repmat(sum(P.*X_tmp,1),[J,1]); %J by N
    h_tmp2(i,1,:,:) = reshape(h_tmp,1,J,N);
end
h_tmp2t = reshape(h_tmp2,1,K1,J,N);
h_tmp = repmat(h_tmp2,[1,K1,1,1]).*repmat(h_tmp2t,[K1,1,1,1]); % K1 by K1 by J by N

P_tmp = repmat(reshape(P,1,1,J,N),[K1,K1,1,1]);

h = sum(sum(P_tmp.*h_tmp,3),4);
end

