function Results = clogit(y,X1,WT,EstimOpt,OptimOpt)

% Nov 20, 2006 modified to allow for bhhh
% Feb 15, 2006 modified to allow for weights

% conditional (multinomial logit regression)
% following Stata clogit command format
% Y is the N*J vector; where choice for each individual is stacked, then all indiv are stacked.
% X1 is N*J by K vector of attributes

N=sum(y);J=length(y)/N;
K1=size(X1,2);

% if don't specify EstimOpt or OptimOpt,
% use default algorithm and starting value
%

if nargin<4
    EstimOpt = []; OptimOpt = []; 
elseif nargin>=4 & nargin<5
    OptimOpt = [];
end

% default starting value = regress y on X
b0=regress(y,X1);

if isempty(EstimOpt)|EstimOpt.OPTIM==2

    if isempty(OptimOpt)
        OptimOpt.LargeScale = 'off';
        OptimOpt.GradObj = 'off';
        OptimOpt.DerivativeCheck = 'on';
        OptimOpt.FunValCheck= 'on';
        OptimOpt.MaxFunEvals = 10000;
    end

    options = optimset(OptimOpt);

    [bhat f exitf output g hess] = fminunc(@(B) clogit_MATlike(y,X1,WT,EstimOpt,OptimOpt,B), b0, options);

    Results.bhat = bhat;
    Results.LL = -f;
    Results.exitf = exitf;
    Results.output = output;
    Results.grad = g;
    Results.hess = hess;
    Results.std = sqrt(diag(inv(hess)));


elseif EstimOpt.OPTIM==1
    if isfield(EstimOpt, 'CZVAR')==0
        EstimOpt.CZVAR=0;
    end
    if isfield(EstimOpt, 'DISPLAY')==0
        EstimOpt.DISPLAY=0;
    end
    if isfield(EstimOpt, 'EPS')==0
        EstimOpt.EPS = 1.e-4;
    end
    if isfield(EstimOpt, 'NITER')==0
        EstimOpt.NITER = 500;
    end
    if isfield(EstimOpt, 'STEP')==0
        EstimOpt.STEP = 1;
    end
    if isfield(EstimOpt, 'MNR')==0
        EstimOpt.MNR = 0;
    end
    if EstimOpt.MNR==1 & isfield(EstimOpt,'MAXSTEP')==0
            EstimOpt.MAXSTEP = 10;
    end

    if isfield(EstimOpt, 'MHESS')==0  % modify hessian
        EstimOpt.MHESS=0;
    elseif isfield(EstimOpt,'MHESS')==1  % modify hessian
        if isfield(EstimOpt,'FACHESS')==0
            EstimOpt.FACHESS = .01;
        end
    end

 
        
        
    if isfield(EstimOpt,'NUMGRAD')==0|EstimOpt.NUMGRAD==0
      
    Results = bhhh2010_2(@(B) clogit_like(y,X1,WT,B),@(b) clogit_gr(y,X1,WT,b),b0,EstimOpt);

    elseif EstimOpt.NUMGRAD==1
 
    Results = bhhh2010_2(@(B) clogit_like(y,X1,WT,B),@(b) clogit_ngr(y,X1,WT,b),b0,EstimOpt);

 
    end
end

