function [Results] = GMNL_2009b(YVEC,XMAT,TIMES,EstimOpt,ModelOpt,OptimOpt)
% this program esimates Generalized MNL Model
% ModelOpt = {S_MNL, MXL, G_MNL}
% if ModelOpt = MXL or G_MNL,
% need to specify EstimOpt.COVTYPE = {uncorr, corr, factor}

% ModelOpt, EstimOpt.COVTYPE
% S_MNL:        b = [b1 b2 ... bk; tau]
% MXL,uncorr:   b = [b1,b2,...bk; l11,l22,...,lkk]
% MXL,corr:     b = [b1,b2,...bk; l11,l22,...,lkk,l21,l32,....,lk1]
% MXL,factor:   b = [b1,b2,...bk; alpha1,...,alphak, sig1,...,sigk]
% G_MNL,uncorr:   b = [b1,b2,...bk; l11,l22,...,lkk,tau,gamma]
% G_MNL,corr:     b = [b1,b2,...bk;l11,l22,...,lkk,l21,l32,....,lk1,tau,gamma]
% G_MNL,factor:   b = [b1,b2,...bk; alpha1,...,alphak,sig1,...,sigk,tau,gamma]

if nargin < 5
    error('the number of input is not correct.');
end

if isfield(EstimOpt,'b0')==0
    error('need to specify initial values')
end
if isfield(EstimOpt,'BACTIVE')==1
    if isempty(EstimOpt.BACTIVE)==0 & length(EstimOpt.b0)~=length(EstimOpt.BACTIVE)
        error('check no. of starting value or constraints')
    end
else
    EstimOpt.BACTIVE = [];

end

switch lower(ModelOpt)

    case 's_mnl'
        disp('estimating scale heterogeneity model...')
        if length(EstimOpt.b0)~=EstimOpt.NVAR+1
            error('check no. of starting value or ModelOpt')
        end

    case 'mxl'
        disp('estimating mixed logit model...')
        if isfield(EstimOpt,'COVTYPE')==0
            EstimOpt.COVTYPE = 'uncorr';
        end

        switch lower(EstimOpt.COVTYPE)
            case 'uncorr'
                if length(EstimOpt.b0)~=(EstimOpt.NVAR*2)
                    error('check no. of starting value or ModelOpt')
                end
                disp('with uncorrelated errors...')

            case 'fullcov'
                if length(EstimOpt.b0)~=(EstimOpt.NVAR)+ncv(EstimOpt.NVAR)
                    error('check no. of starting value or ModelOpt')
                end
                disp('with correlated errors...')

            case 'factor'
                if length(EstimOpt.b0)~=(EstimOpt.NVAR)+ncvfac(EstimOpt.NVAR,EstimOpt.NFAC,1)
                    error('check no. of starting value or ModelOpt')
                end

                disp('with factor structure imposed on cov matrix...')
                EstimOpt.NUMGRAD = 1;
        end

    case 'g_mnl'
        disp('estimating G-MNL model...')
        switch lower(EstimOpt.COVTYPE)
            case 'uncorr'
                if length(EstimOpt.b0)~=(EstimOpt.NVAR*2)+2
                    error('check no. of starting value or ModelOpt')
                end
                disp('with uncorrelated errors...')

            case 'fullcov'
                if length(EstimOpt.b0)~=(EstimOpt.NVAR)+ncv(EstimOpt.NVAR)+2
                    error('check no. of starting value or ModelOpt')
                end
                disp('with correlated errors...')

            case 'factor'
                if length(EstimOpt.b0)~=(EstimOpt.NVAR)+ncvfac(EstimOpt.NVAR,EstimOpt.NFAC,1)+2
                    error('check no. of starting value or ModelOpt')
                end

                disp('with factor structure imposed on cov matrix...')
                EstimOpt.NUMGRAD = 1;
        end


end

NALT =EstimOpt.NALT;

% Draw 1+ NVAR = NECOL vectors of standard normal
% but will keep only what is needed for ModelOpt
% this is to make sure that we use the same draw when we
% comparing across models

EstimOpt.NECOL = 1+ EstimOpt.NVAR;
if isfield(EstimOpt,'NREP')==0
    EstimOpt.NREP = 500;
end
disp(strcat('No. of draws:   ',num2str(EstimOpt.NREP)))

if isfield(EstimOpt,'DRAWS')==0
    EstimOpt.DRAWS = 3;
end

if isfield(EstimOpt,'SEED1')==0
    EstimOpt.SEED1 = 2061;
end
if isfield(EstimOpt,'SEED2')==0
    EstimOpt.SEED2 = 10700;
end


if EstimOpt.DRAWS ==1
    if isfield(EstimOpt,'SEED1')==1
        randn('state', EstimOpt.SEED1);
    end
    err_mtx = randn(EstimOpt.NP*EstimOpt.NREP,EstimOpt.NECOL);
    disp('all draws are standard normal')

elseif EstimOpt.DRAWS == 2
    %% Create the Halton sequence %
    % /* Provide prime number vector */
    prim = primes(113);
    prim(1,1:EstimOpt.NECOL);
    % /* Develop a halton matrix (hm) of size nrep x (nobs*necol); The first 'nobs'
    hm = [];
    for h = 1:EstimOpt.NECOL
        hm1 = halton(15+EstimOpt.NREP*EstimOpt.NP,prim(h));
        %hm1 is a 10+EstimOpt.NREP*EstimOpt.NP column vector
        hm1 = icdf('Normal',hm1,0,1);
        %truncated to avoid very extreme values
        hm1 = hm1.*(hm1<=10)+(10*(hm1>=10));
        hm1 = hm1.*(hm1>=-10)-(10*(hm1<=-10));
        hm = [hm hm1(16:length(hm1))];

    end
    err_mtx = hm; clear hm
    disp('all draws are halton')


elseif EstimOpt.DRAWS == 3
    if isfield(EstimOpt,'SEED1')==1
        randn('state', EstimOpt.SEED1);
    end
    if isfield(EstimOpt,'SEED2')==1
        rand('state', EstimOpt.SEED2);
    end
    % the first column is drawn from truncated normal
    if isfield(EstimOpt,'LB')==0
        EstimOpt.LB = -2;
    end
    if isfield(EstimOpt,'UB')==0
        EstimOpt.UB = 2;
    end

    tmp = normt_rnd(zeros(EstimOpt.NP*EstimOpt.NREP,1),ones(EstimOpt.NP*EstimOpt.NREP,1),...
        EstimOpt.LB*ones(EstimOpt.NP*EstimOpt.NREP,1),EstimOpt.UB*ones(EstimOpt.NP*EstimOpt.NREP,1));

    err_mtx = [tmp randn(EstimOpt.NP*EstimOpt.NREP,EstimOpt.NECOL-1)];
end


switch lower(ModelOpt)

    case 's_mnl'
        err_mtx = err_mtx(:,1);
        if EstimOpt.DRAWS ==3
            disp('draw for random scale is truncated normal.')
        end
    case 'mxl'

        err_mtx = err_mtx(:,2:size(err_mtx,2));

    case 'g_mnl'
        if EstimOpt.DRAWS ==3
            disp('draw for random scale is truncated normal. the rest are standard normal.')
        end

end

b0 =EstimOpt.b0;

if isfield(EstimOpt,'CZVAR')==0
    EstimOpt.CZVAR = 0; EstimOpt.BACTIVE = [];
    disp(strcat('Initial values:   ',mat2str(EstimOpt.b0',2)))
    disp('no constraints on parameters')

elseif EstimOpt.CZVAR==1
    disp(strcat('Initial values:   ',mat2str(EstimOpt.b0',2)))
    disp(strcat('Parameters with zeros are constrained to their initial values', mat2str(EstimOpt.BACTIVE)))

end

% ------------------ relevant only for S-MNL and G-MNL -------------------
switch lower(ModelOpt)
    case {'s_mnl','g_mnl'}

        if isfield(EstimOpt,'NOTSCALE')==1 & sum(EstimOpt.NOTSCALE)>0
            disp(strcat('Parameters with ones are not scaled:   ',mat2str(EstimOpt.NOTSCALE)))
        else
            disp('All parameters are scaled.')
            EstimOpt.NOTSCALE = zeros(1,EstimOpt.NVAR);
        end
    otherwise

        EstimOpt.NOTSCALE = [];
end

switch lower(ModelOpt)
    case 'g_mnl'
        if isfield(EstimOpt,'LBVAR') ==1 & isempty(EstimOpt.LBVAR)==0
            if length(EstimOpt.LBVAR)~=length(EstimOpt.b0)
                error('wrong numbers of LBVAR')
            else
                disp(strcat('Some parameters have lower bound constraints', mat2str(EstimOpt.LBVAR)))
                EstimOpt.LBVAR = EstimOpt.LBVAR(:);
            end
        else
            disp(strcat('setting LBVAR for gamma* to -5'))
            EstimOpt.LBVAR = [-Inf*ones(length(EstimOpt.b0)-1,1); -5];
        end

        if isfield(EstimOpt,'UBVAR') ==1 & isempty(EstimOpt.UBVAR)==0
            if length(EstimOpt.UBVAR)~=length(EstimOpt.b0)
                error('wrong numbers of UBVAR')
            else
                disp(strcat('Some parameters have upper bound constraints', mat2str(EstimOpt.UBVAR)))
                EstimOpt.UBVAR = EstimOpt.UBVAR(:);
            end
        else
            disp(strcat('setting UBVAR for gamma* to 5'))
            EstimOpt.UBVAR = [Inf*ones(length(EstimOpt.b0)-1,1); 5];
        end

    case {'s_mnl','mxl'}
        if isfield(EstimOpt,'LBVAR') ==1 & isempty(EstimOpt.LBVAR)==0
            if length(EstimOpt.LBVAR)~=length(EstimOpt.b0)
                error('wrong numbers of LBVAR')
            else
                disp(strcat('Some parameters have lower bound constraints', mat2str(EstimOpt.LBVAR)))
                EstimOpt.LBVAR = EstimOpt.LBVAR(:);
            end
        else
            EstimOpt.LBVAR = [];
        end

        if isfield(EstimOpt,'UBVAR') ==1 & isempty(EstimOpt.UBVAR)==0
            if length(EstimOpt.UBVAR)~=length(EstimOpt.b0)
                error('wrong numbers of UBVAR')
            else
                disp(strcat('Some parameters have upper bound constraints', mat2str(EstimOpt.UBVAR)))
                EstimOpt.UBVAR = EstimOpt.UBVAR(:);
            end
        else
            EstimOpt.UBVAR = [];
        end
end

if isfield(EstimOpt,'DISPLAY')==0
    EstimOpt.DISPLAY =0;
end

if isfield(EstimOpt,'GRADCHECK')==1 & EstimOpt.GRADCHECK ==1
    disp('check whether analytical grad = numerical gradients')
    a_grad = sum(g_mnl_gr8a(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,b0))';
    n_grad = sum(g_mnl_ngr7a(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,b0))';
    graddiff = a_grad-n_grad;

    Results.agrad = a_grad;
    Results.ngrad = n_grad;
    Results.graddiff = graddiff;

    return
end

if isfield(EstimOpt,'OPTIM')==0
    EstimOpt.OPTIM =1;
end

if EstimOpt.OPTIM==1
    if isfield(EstimOpt,'MBHHH')==0
        EstimOpt.MBHHH= 0;
    end
    if isfield(EstimOpt,'MAXSTEP')==0
        EstimOpt.MAXSTEP = 1;
    end
    if isfield(EstimOpt,'NUMGRAD')==0
        EstimOpt.NUMGRAD = 0;
    end

    if isfield(EstimOpt, 'EPS')==0
        EstimOpt.EPS = 1.e-4;
    end
    if isfield(EstimOpt, 'NITER')==0
        EstimOpt.NITER = 500;
    end
    if isfield(EstimOpt, 'STEP')==0
        EstimOpt.STEP = 1;
    end
    if isfield(EstimOpt, 'MNR')==0
        EstimOpt.MNR = 1;
    end
    if EstimOpt.MNR==1 & isfield(EstimOpt,'MAXSTEP')==0
        EstimOpt.MAXSTEP = 1;
    end

    if isfield(EstimOpt, 'MHESS')==0  % modify hessian
        EstimOpt.MHESS=0;
    elseif isfield(EstimOpt,'MHESS')==1
        if isfield(EstimOpt,'FACHESS')==0
            EstimOpt.FACHESS = .01;
        end
    end



    if isfield(EstimOpt,'NUMGRAD')==0|EstimOpt.NUMGRAD==0
        disp('BHHH with analytical gradients')
        Results = bhhh2010_2(@(B)  g_mnl_like7a(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,B),...
            @(b) g_mnl_gr8a(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,b),b0,EstimOpt);
    elseif EstimOpt.NUMGRAD==1
        disp('BHHH with numerical gradients')
        Results = bhhh2010_2(@(B) g_mnl_like7a(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,B),...
            @(b) g_mnl_ngr7a(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,b),b0,EstimOpt);
    end

    if isfield(EstimOpt,'ROBUSTSTD') ==1
        if EstimOpt.ROBUSTSTD==1
            SGRAD = @(bhat) g_mnl_sumngr7gr8a(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,bhat);
            hessFinDiff = numhess2010_2([],Results.bhat,SGRAD,[],EstimOpt);
            Results.hessFinDiff = hessFinDiff;
            Results.stdHessFinDiff = sqrt(diag(inv(-hessFinDiff)));

            RobustCov = inv(hessFinDiff)*inv(Results.ihesh)*inv(hessFinDiff);
            Results.RobustStd=sqrt(diag(RobustCov));
            Results.RobustCov=RobustCov;


        end

    end

elseif EstimOpt.OPTIM ==2
     % use matlab 'fminunc' algorithm
     % this option may not work with certain restrictions on parameters
    if isempty(OptimOpt)
        OptimOpt.LargeScale = 'off';
        OptimOpt.GradObj = 'off';
        OptimOpt.DerivativeCheck = 'on';
        OptimOpt.FunValCheck= 'on';
        OptimOpt.MaxFunEvals = 10000;
    end

    options = optimset(OptimOpt);

    [bhat f exitf output g hess] = fminunc(@(B) g_mnl7a_MATlike(YVEC,XMAT,TIMES,err_mtx,EstimOpt,ModelOpt,OptimOpt,B), b0, options);

    Results.bhat = bhat;
    Results.LL = -f;
    Results.exitf = exitf;
    Results.output = output;
    Results.grad = g;
    Results.hess = hess;
    Results.std = sqrt(diag(inv(hess)));

end

